package ai.botbrain.ttcloud.sdk.activity;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputMethodManager;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.TextView;
import android.widget.Toast;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.model.BotBrainEntity;
import ai.botbrain.ttcloud.sdk.model.RecommendEntity;
import ai.botbrain.ttcloud.sdk.util.KeyBoardUtil;

/**
 * Description：Load web pages with webview only.
 * Creator: Created by peter.
 * Date: 17/3/22.
 */
public class TsdH5ReaderOnWvActivity extends Activity implements TextView.OnEditorActionListener {
    private static final String TAG = TsdH5ReaderOnWvActivity.class.getSimpleName();
    private Context mContext;

    private String mUrl;
    private String title;
    private RecommendEntity.Data2 data2;

    //private TextView mUrlEditor;
    private WebView mWebView;
    private WebChromeClient mWebChromeClient;
    private BotBrainEntity mBrainEntity;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.tsd_activity_h5_reader_onwv);
        mContext = this;
        initParams();
        initView();
    }

    private void initView() {
        mWebView = (WebView) findViewById(R.id.content);
        //mUrlEditor = (TextView) findViewById(R.id.txt_url);
        //ImageButton ib_more = (ImageButton) findViewById(R.id.ib_more);
        /*
        ib_more.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

            }
        });
        */

        boolean isHasShare = null == mBrainEntity ? false : mBrainEntity.isHasShare();
        if (!isHasShare) {
            //ib_more.setVisibility(View.INVISIBLE);
        }
        initWebView();
        mUrl = TextUtils.isEmpty(mUrl) ? "" : mUrl;
        Log.i(TAG, "loadUrl:" + mUrl);
        mUrl = "http://www.baidu.com/";
        //mWebView.loadUrl(mUrl);
        //mWebView.loadUrl("https://bkd.botbrain.ai/h5/v1/J8KMZCESXG/index?type=4");
        mWebView.loadUrl(mUrl);
    }

    private void initParams() {
        Intent intent = getIntent();
        Bundle params = intent.getExtras();
        if (params != null) {
            mUrl = params.getString("url");
            title = params.getString("title");

            mBrainEntity = (BotBrainEntity) params.getSerializable("botBrainEntity");
            data2 = (RecommendEntity.Data2) params.getSerializable("data2");
        }
    }

    public void clickUp(View view) {
    }

    public void clickDown(View view) {
    }


    public void back(View view) {
        finish();
    }

    public void openShare(View view) {
        Toast.makeText(mContext, "share", Toast.LENGTH_SHORT).show();
    }

    @Override
    public boolean onEditorAction(TextView textView, int actionId, KeyEvent keyEvent) {
        boolean handled = false;
        if (actionId == EditorInfo.IME_ACTION_DONE) {
            Toast.makeText(mContext, "完成", Toast.LENGTH_SHORT).show();
            handled = true;
            InputMethodManager inputMethodManager = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
            if (inputMethodManager.isActive()) {
                inputMethodManager.hideSoftInputFromWindow(TsdH5ReaderOnWvActivity.this.getCurrentFocus().getWindowToken(), 0);
            }
        }
        return handled;
    }

    private void initWebView() {
        this.mWebChromeClient = new WebChromeClient();
        this.mWebView.setWebChromeClient(this.mWebChromeClient);
        mWebView.setWebViewClient(new WebViewClient() {
            @Override
            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                //mUrlEditor.setText(url);
            }

            @Override
            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                //mUrlEditor.setText(view.getTitle());
            }
        });

        this.mWebView.getSettings().setDomStorageEnabled(true);
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.getSettings().setBlockNetworkImage(false);
        this.mWebView.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        this.mWebView.getSettings().setUserAgentString(this.mWebView.getSettings().getUserAgentString());
        this.mWebView.getSettings().setDatabaseEnabled(true);
        this.mWebView.setScrollBarStyle(View.SCROLLBARS_INSIDE_OVERLAY);
        Log.i("DETAIL", mWebView.getSettings().getUserAgentString());
        if (Build.VERSION.SDK_INT >= 21) {
            this.mWebView.getSettings().setMixedContentMode(WebSettings.MIXED_CONTENT_ALWAYS_ALLOW);
        }
        if (Build.VERSION.SDK_INT > 15) {
            this.mWebView.getSettings().setAllowUniversalAccessFromFileURLs(true);
        }
        if ((Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB) && (Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN_MR1)) {
            fixWebView();
        }
    }

    @TargetApi(Build.VERSION_CODES.HONEYCOMB)
    private void fixWebView() {
        this.mWebView.removeJavascriptInterface("searchBoxJavaBridge_");
    }

    public void writeCommentClick(View view) {
        KeyBoardUtil.show(TsdH5ReaderOnWvActivity.this);
    }

    public void publishClick(View view) {
    }

}
