/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mma.mobile.tracking.util;

import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import cn.com.mma.mobile.tracking.util.Logger;

public class LocationUtil {
    private LocationManager locationManager;
    private static LocationUtil locationUtil = null;
    private StringBuilder locationBuilder = new StringBuilder();
    public LocationListener listener = new LocationListener(){

        public void onStatusChanged(String s, int i, Bundle bundle) {
            Logger.d("onStatusChanged:" + s);
        }

        public void onProviderEnabled(String s) {
            Logger.d("onProviderEnabled:" + s);
        }

        public void onProviderDisabled(String s) {
            Logger.d("onProviderDisabled:" + s);
        }

        public void onLocationChanged(Location location) {
            double longitude = location.getLongitude();
            double latitude = location.getLatitude();
            Logger.d(String.valueOf(latitude) + "x" + longitude);
            LocationUtil.this.locationBuilder = LocationUtil.this.locationBuilder.append(latitude).append("x").append(longitude);
        }
    };

    public String getLocation() {
        return this.locationBuilder.toString();
    }

    private LocationUtil(Context context) {
        this.locationManager = (LocationManager)context.getSystemService("location");
    }

    public static LocationUtil getInstance(Context context) {
        if (locationUtil == null) {
            locationUtil = new LocationUtil(context);
        }
        return locationUtil;
    }

    public void startLocationListener() {
        try {
            Criteria criteria = new Criteria();
            criteria.setAccuracy(2);
            criteria.setAltitudeRequired(false);
            criteria.setBearingRequired(false);
            criteria.setCostAllowed(true);
            criteria.setPowerRequirement(1);
            String provider = this.locationManager.getBestProvider(criteria, true);
            this.locationManager.requestLocationUpdates(provider, 3600000L, 0.0f, this.listener);
        }
        catch (Exception e) {
            Logger.d("mma_Error data LBS" + e);
            e.printStackTrace();
        }
    }

    public void stopListenLocation() {
        if (this.locationManager != null) {
            this.locationManager.removeUpdates(this.listener);
            Logger.d("\u505c\u6b62\u4f4d\u7f6e\u76d1\u542c");
        }
    }
}

