/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.widget;

import android.content.Context;
import android.os.Build;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.NestedScrollingChildHelper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ListView;

public class NestedListView
extends ListView {
    private static final String TAG = "NestedListView";
    private static final int INVALID_POINTER = -1;
    private NestedScrollingChildHelper mChildHelper;
    private int mScrollPointerId = -1;
    private int mLastTouchY;
    private final int[] mScrollOffset = new int[2];
    private final int[] mScrollConsumed = new int[2];
    private int mNestedOffsetY;
    private boolean mScrollable = true;

    public NestedListView(Context context) {
        super(context);
        this.init();
    }

    public NestedListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public NestedListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mChildHelper = new NestedScrollingChildHelper((View)this);
        this.setNestedScrollingEnabled(true);
        this.setTouchScrollable(true);
    }

    public void setTouchScrollable(boolean scrollable) {
        this.mScrollable = scrollable;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (Build.VERSION.SDK_INT < 21) {
            return this.onInterceptTouchEventUnder21(ev);
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (Build.VERSION.SDK_INT < 21) {
            return this.onTouchEventUnder21(event);
        }
        return super.onTouchEvent(event);
    }

    private boolean onInterceptTouchEventUnder21(MotionEvent event) {
        return super.onInterceptTouchEvent(event);
    }

    private boolean onTouchEventUnder21(MotionEvent event) {
        MotionEvent vtev = MotionEvent.obtain((MotionEvent)event);
        int action = MotionEventCompat.getActionMasked((MotionEvent)event);
        int actionIndex = MotionEventCompat.getActionIndex((MotionEvent)event);
        if (action == 0) {
            this.mNestedOffsetY = 0;
        }
        vtev.offsetLocation(0.0f, (float)this.mNestedOffsetY);
        switch (action) {
            case 0: {
                this.mScrollPointerId = event.getPointerId(0);
                this.mLastTouchY = (int)(event.getY() + 0.5f);
                this.startNestedScroll(2);
                break;
            }
            case 5: {
                this.mScrollPointerId = event.getPointerId(actionIndex);
                this.mLastTouchY = (int)(event.getX(actionIndex) + 0.5f);
                break;
            }
            case 2: {
                int newScrollY;
                int originDy;
                int index = event.findPointerIndex(this.mScrollPointerId);
                if (index < 0) {
                    Log.e((String)TAG, (String)("Error processing scroll; pointer index for id " + this.mScrollPointerId + " not found. Did any MotionEvents get skipped?"));
                    return false;
                }
                int y = (int)(event.getY(index) + 0.5f);
                int dy = originDy = this.mLastTouchY - y;
                int oldY = this.getScrollY();
                if (this.dispatchNestedPreScroll(0, dy, this.mScrollConsumed, this.mScrollOffset)) {
                    dy -= this.mScrollConsumed[1];
                    vtev.offsetLocation(0.0f, (float)(-this.mScrollOffset[1]));
                    this.mNestedOffsetY += this.mScrollOffset[1];
                }
                this.mLastTouchY = y - this.mScrollOffset[1];
                if (dy < 0 && this.dispatchNestedScroll(0, (newScrollY = Math.max(0, oldY + dy)) - (dy -= newScrollY - oldY), 0, dy, this.mScrollOffset)) {
                    vtev.offsetLocation(0.0f, (float)this.mScrollOffset[1]);
                    this.mNestedOffsetY += this.mScrollOffset[1];
                    this.mLastTouchY -= this.mScrollOffset[1];
                }
                if (this.mScrollable || Math.abs(originDy) < 1) break;
                event.setAction(3);
                break;
            }
            case 6: {
                this.onPointerUp(event);
            }
            case 1: 
            case 3: {
                this.stopNestedScroll();
            }
        }
        vtev.recycle();
        super.onTouchEvent(event);
        return true;
    }

    private void onPointerUp(MotionEvent e) {
        int actionIndex = MotionEventCompat.getActionIndex((MotionEvent)e);
        if (e.getPointerId(actionIndex) == this.mScrollPointerId) {
            int newIndex = actionIndex == 0 ? 1 : 0;
            this.mScrollPointerId = e.getPointerId(newIndex);
            this.mLastTouchY = (int)(e.getY(newIndex) + 0.5f);
        }
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mChildHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean startNestedScroll(int axes) {
        return this.mChildHelper.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        this.mChildHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.mChildHelper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.mChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.mChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.mChildHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.mChildHelper.dispatchNestedPreFling(velocityX, velocityY);
    }
}

