/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.swipeBack;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.swipeBack.SwipeBackLayout;
import ai.botbrain.ttcloud.sdk.swipeBack.Utils;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;

public class SwipeBackActivityHelper {
    private Activity mActivity;
    private SwipeBackLayout mSwipeBackLayout;

    public SwipeBackActivityHelper(Activity activity) {
        this.mActivity = activity;
    }

    public void onActivityCreate() {
        this.mActivity.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.mActivity.getWindow().getDecorView().setBackgroundDrawable(null);
        this.mSwipeBackLayout = (SwipeBackLayout)LayoutInflater.from((Context)this.mActivity).inflate(R.layout.tsb_swipeback_layout, null);
        this.mSwipeBackLayout.addSwipeListener(new SwipeBackLayout.SwipeListener(){

            @Override
            public void onScrollStateChange(int state, float scrollPercent) {
            }

            @Override
            public void onEdgeTouch(int edgeFlag) {
                Utils.convertActivityToTranslucent(SwipeBackActivityHelper.this.mActivity);
            }

            @Override
            public void onScrollOverThreshold() {
            }
        });
    }

    public void onPostCreate() {
        this.mSwipeBackLayout.attachToActivity(this.mActivity);
    }

    public View findViewById(int id2) {
        if (this.mSwipeBackLayout != null) {
            return this.mSwipeBackLayout.findViewById(id2);
        }
        return null;
    }

    public SwipeBackLayout getSwipeBackLayout() {
        return this.mSwipeBackLayout;
    }
}

