/*
 * Decompiled with CFR 0.152.
 */
package com.ta.utdid2.android.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class SystemUtils {
    public static String getCpuInfo() {
        String str = null;
        FileReader localFileReader = null;
        BufferedReader localBufferedReader = null;
        try {
            localFileReader = new FileReader("/proc/cpuinfo");
            if (localFileReader != null) {
                try {
                    localBufferedReader = new BufferedReader(localFileReader, 1024);
                    str = localBufferedReader.readLine();
                    localBufferedReader.close();
                    localFileReader.close();
                }
                catch (IOException localIOException) {
                    Log.e((String)"Could not read from file /proc/cpuinfo", (String)localIOException.toString());
                }
            }
        }
        catch (FileNotFoundException localFileNotFoundException) {
            Log.e((String)"BaseParameter-Could not open file /proc/cpuinfo", (String)localFileNotFoundException.toString());
        }
        if (str != null) {
            int i = str.indexOf(58) + 1;
            str = str.substring(i);
            return str.trim();
        }
        return "";
    }

    public static int getSystemVersion() {
        int SDK_INT = 2;
        try {
            SDK_INT = Build.VERSION.class.getField("SDK_INT").getInt(null);
        }
        catch (Exception e) {
            try {
                SDK_INT = Integer.parseInt((String)Build.VERSION.class.getField("SDK").get(null));
            }
            catch (Exception e2) {
                SDK_INT = 2;
                e2.printStackTrace();
            }
        }
        return SDK_INT;
    }

    public static File getRootFolder(String folderName) {
        File sdCardFile = Environment.getExternalStorageDirectory();
        if (sdCardFile != null) {
            File rootFolder = new File(String.format("%s%s%s", sdCardFile.getAbsolutePath(), File.separator, folderName));
            if (rootFolder != null && !rootFolder.exists()) {
                rootFolder.mkdirs();
            }
            return rootFolder;
        }
        return null;
    }

    public static String getAppLabel(Context pContext) {
        try {
            PackageManager lPM = pContext.getPackageManager();
            String lPackageName = pContext.getPackageName();
            if (lPM != null && lPackageName != null) {
                PackageInfo lPI = lPM.getPackageInfo(lPackageName, 1);
                String lLabelName = lPM.getApplicationLabel(lPI.applicationInfo).toString();
                return lLabelName;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }
}

