package ai.botbrain.ttcloud.sdk.widget;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.view.View;
import android.widget.GridView;
import android.widget.ImageButton;
import android.widget.TextView;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.adapter.TvAdapter1;
import ai.botbrain.ttcloud.sdk.model.RecommendEntity;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/5/12.
 */

public class RecommendDialog extends Dialog {

    private RecommendEntity.Datas mData;
    private Context mContext;
    private String title;
    private TextView tv_title;
    private ImageButton ib_cancel;

    public RecommendDialog(Context context, RecommendEntity.Datas datas) {
        super(context, R.style.tsd_commonDialog);
        this.mData = datas;
        this.mContext = context;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.tsd_dlg_anthology);
        initView();
    }

    private void initView() {
        String channel = null == mData.channel ? "" : mData.channel;
        String title = null == mData.channel ? "" : mData.channel;

        tv_title = (TextView) findViewById(R.id.tv_title);
        ib_cancel = (ImageButton) findViewById(R.id.ib_cancel);
        GridView gv = (GridView) findViewById(R.id.gv);

        tv_title.setText(title);
        ib_cancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                RecommendDialog.this.dismiss();
            }
        });

        ib_cancel.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View arg0) {
                dismiss();
            }
        });

        if (!channel.equals(mContext.getResources().getString(R.string.tsd_variety))) {
            gv.setNumColumns(4);
        } else {
            gv.setNumColumns(2);
        }

        final TvAdapter1 adapter = new TvAdapter1(mContext, mData);
        gv.setAdapter(adapter);
        gv.setSelector(new ColorDrawable(Color.TRANSPARENT));
    }
}
