package ai.botbrain.ttcloud.sdk.util;

import android.widget.Button;

import com.qq.e.ads.nativ.NativeMediaADData;

import org.greenrobot.eventbus.EventBus;

import ai.botbrain.ttcloud.sdk.TsdConstant;
import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.model.AdEntity;
import ai.botbrain.ttcloud.sdk.model.BuriedPointEvent;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/4/24.
 */

public class AdQqManager {

    public static void renderDownLoadView(Button download, NativeMediaADData ad) {
        if (null == ad) return;
        String rs_browse = TsdContextHolder.getContext().getResources().getString(R.string.tsd_browse);
        String rs_download = TsdContextHolder.getContext().getResources().getString(R.string.tsd_download);
        String rs_start = TsdContextHolder.getContext().getResources().getString(R.string.tsd_start);
        String rs_update = TsdContextHolder.getContext().getResources().getString(R.string.tsd_update);
        String rs_installation = TsdContextHolder.getContext().getResources().getString(R.string.tsd_installation);
        String rs_re_install = TsdContextHolder.getContext().getResources().getString(R.string.tsd_re_install);
        if (!ad.isAPP()) {
            download.setText(rs_browse);
        } else {
            int status = ad.getAPPStatus();
            if (status == 0) {
                download.setText(rs_download);
                return;
            }

            if (status == 1) {
                download.setText(rs_start);
                return;
            }

            if (status == 2) {
                download.setText(rs_update);
                return;
            }

            if (status == 4) {
                String rs_down_pro = TsdContextHolder.getContext().getResources().getString(R.string.tsd_down_pro);
                download.setText(String.format(rs_down_pro, ""));
                download.setText(String.format(rs_down_pro, String.valueOf(ad.getProgress())));
                return;
            }

            if (status == 8) {
                download.setText(rs_installation);
                return;
            }

            if (status == 16) {
                download.setText(rs_re_install);
                return;
            }
            download.setText(rs_browse);

        }
    }

    public static void adError() {
        String appid = CommonUtil.getAppId(TsdContextHolder.getContext());
        String nativevideoposid = CommonUtil.getNativevideoposid(TsdContextHolder.getContext());
        AdEntity adEntity = new AdEntity();
        adEntity.src = TsdConstant.TYPE_QQ;
        adEntity.appid = appid;
        adEntity.nativevideoposid = nativevideoposid;
        String params = GsonUtil.GsonString(adEntity);
        EventBus.getDefault().post(new BuriedPointEvent(TsdConstant.ACTION_AD_ERROR, null, null, params, null));
    }
}
