package ai.botbrain.ttcloud.sdk.adapter;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.qq.e.ads.nativ.NativeMediaAD;
import com.qq.e.ads.nativ.NativeMediaADData;

import org.greenrobot.eventbus.EventBus;

import java.util.List;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.TsdConstant;
import ai.botbrain.ttcloud.sdk.disLike.FitPopupUtil;
import ai.botbrain.ttcloud.sdk.model.AdEntity;
import ai.botbrain.ttcloud.sdk.model.BuriedPointEvent;
import ai.botbrain.ttcloud.sdk.model.DislikeEvent;
import ai.botbrain.ttcloud.sdk.model.RecommendEntity;
import ai.botbrain.ttcloud.sdk.model.TopTitleEntity;
import ai.botbrain.ttcloud.sdk.net.RestApi;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.util.AdQqManager;
import ai.botbrain.ttcloud.sdk.util.CommonUtil;
import ai.botbrain.ttcloud.sdk.util.TsdContextHolder;
import ai.botbrain.ttcloud.sdk.util.FireDataManager;
import ai.botbrain.ttcloud.sdk.util.GsonUtil;
import ai.botbrain.ttcloud.sdk.util.LogUtil;

import static ai.botbrain.ttcloud.sdk.presenter.AdManager.setMediaADDataHashMap;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/22.
 */
public class GraphicAdapter extends TsdBaseAdapter implements NativeMediaAD.NativeMediaADListener {

    private static final String TAG = GraphicAdapter.class.getSimpleName();
    private static final int TYPE_NO_PIC = 0;
    private static final int TYPE_ONE_SMALL = 1;
    private static final int TYPE_ONE_BIG = 2;
    private static final int TYPE_THREE_PIC = 3;
    private static final int TYPE_QQ_AD = 4;
    private static final int TYPE_SEE_HERE = 5;

    private static final int TYPE_COUNT = 6;

    private RestApi restApi;

    private List<RecommendEntity.Data> mData;
    private TopTitleEntity.Columns mColumns;
    private Context mContext;

    public GraphicAdapter(Context context, TopTitleEntity.Columns columns, List<RecommendEntity.Data> data) {
        this.mContext = context;
        this.mData = data;
        this.mColumns = columns;
        restApi = new RestApiImpl();
    }

    private String getCompose() {
        return null == mColumns.compose ? "" : mColumns.compose;
    }

    @Override
    public int getCount() {
        return null == mData ? 0 : mData.size();
    }

    @Override
    public Object getItem(int position) {
        return mData.get(position);
    }

    @Override
    public long getItemId(int i) {
        return 0;
    }

    @Override
    public int getViewTypeCount() {
        return TYPE_COUNT;
    }

    @Override
    public int getItemViewType(int position) {
        RecommendEntity.Data data = mData.get(position);
        String type = data.type;

        if (type.equals("ad") && data.data.src.equals("qq.e")) {
            return TYPE_QQ_AD;
        }
        if (getType(position).equals("feed")) {
            return getFeedType(position);
        } else if (getType(position).equals("seeHere")) {
            return TYPE_SEE_HERE;
        }
        return TYPE_NO_PIC;
    }

    private String getType(int position) {
        RecommendEntity.Data data = mData.get(position);
        return data.type;
    }

    private boolean checkImgIsNull(RecommendEntity.Data2 data2) {
        return null == data2.images || data2.images.length == 0;
    }

    private int getFeedType(int position) {
        RecommendEntity.Data data = mData.get(position);
        RecommendEntity.Data2 data2 = data.data;
        String[] imgs = data2.images;
        String coverUrl = data2.cover_url;
        String view_img_type = null == data2.view_img_type ? "" : data2.view_img_type;
        if (TextUtils.isEmpty(coverUrl) && checkImgIsNull(data2))
            return TYPE_NO_PIC;

        if (getCompose().equals("2")) {
            return TYPE_ONE_SMALL;
        }

        if (getCompose().equals("3")) {
            return TYPE_ONE_BIG;
        }

        if (view_img_type.equals("1") && !TextUtils.isEmpty(coverUrl)) {
            return TYPE_ONE_BIG;
        }
        if (view_img_type.equals("2")) {
            return TYPE_ONE_SMALL;
        }
        if (view_img_type.equals("3")) {
            return TYPE_THREE_PIC;
        }

        if (!TextUtils.isEmpty(coverUrl)) {
            return TYPE_ONE_BIG;
        } else if (TextUtils.isEmpty(coverUrl) && null != imgs && imgs.length == 0) {
            return TYPE_NO_PIC;
        } else if (TextUtils.isEmpty(coverUrl) && null != imgs && imgs.length == 1) {
            return TYPE_ONE_SMALL;
        } else if (TextUtils.isEmpty(coverUrl) && null != imgs && imgs.length >= 3) {
            return TYPE_THREE_PIC;
        } else {
            return TYPE_NO_PIC;
        }
    }

    private void initViewDisLike(View convertView, ViewHolder viewHolder) {
        viewHolder.iv_dislike = (ImageView) convertView.findViewById(R.id.iv_dislike);
        viewHolder.iv_dislike.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                int position2 = (int) v.getTag();
                initPopup(v, position2);
            }
        });
    }

    private void initViewCommon(View convertView, ViewHolder viewHolder) {
        viewHolder.mTitle = (TextView) convertView.findViewById(R.id.item_title);
        viewHolder.mSource = (TextView) convertView.findViewById(R.id.item_source);
        viewHolder.tsd_tv_stickied = (TextView) convertView.findViewById(R.id.tsd_tv_stickied);
        viewHolder.tsd_article_divider = convertView.findViewById(R.id.tsd_article_divider);
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        final ViewHolder viewHolder;
        int type = getItemViewType(position);
        if (convertView == null || convertView.getTag() == null) {
            viewHolder = new ViewHolder();
            switch (type) {
                case TYPE_SEE_HERE:
                    convertView = View.inflate(mContext, R.layout.tsd_item_see_here, null);
                    break;
                case TYPE_NO_PIC:
                    convertView = View.inflate(mContext, R.layout.tsd_item_article_plain, null);
                    initViewDisLike(convertView, viewHolder);
                    initViewCommon(convertView, viewHolder);
                    break;
                case TYPE_ONE_SMALL:
                    convertView = View.inflate(mContext, R.layout.tsd_item_article_small, null);
                    viewHolder.mRightImage = (ImageView) convertView.findViewById(R.id.right_image);
                    initViewDisLike(convertView, viewHolder);
                    initViewCommon(convertView, viewHolder);
                    break;
                case TYPE_THREE_PIC:
                    convertView = View.inflate(mContext, R.layout.tsd_item_article_multi_pics, null);
                    viewHolder.mImageLeft = (ImageView) convertView.findViewById(R.id.left_image);
                    viewHolder.mImageMid = (ImageView) convertView.findViewById(R.id.mid_image);
                    viewHolder.mImageRight = (ImageView) convertView.findViewById(R.id.right_image);
                    initViewDisLike(convertView, viewHolder);
                    initViewCommon(convertView, viewHolder);
                    break;
                case TYPE_ONE_BIG:
                    convertView = View.inflate(mContext, R.layout.tsd_item_article_big_pic, null);
                    viewHolder.mBigImage = (ImageView) convertView.findViewById(R.id.big_image);
                    initViewDisLike(convertView, viewHolder);
                    initViewCommon(convertView, viewHolder);
                    break;
                case TYPE_QQ_AD:
                    convertView = View.inflate(mContext, R.layout.tsd_item_qq_ad2, null);
                    viewHolder.adInfoContainer = (LinearLayout) convertView.findViewById(R.id.ad_info);
                    viewHolder.logo = (ImageView) convertView.findViewById(R.id.img_logo);
                    viewHolder.poster = (ImageView) convertView.findViewById(R.id.img_poster);
                    viewHolder.name = (TextView) convertView.findViewById(R.id.text_title);
                    viewHolder.desc = (TextView) convertView.findViewById(R.id.text_desc);
                    viewHolder.download = (Button) convertView.findViewById(R.id.btn_download);
                    initViewCommon(convertView, viewHolder);
                    break;
            }
            if (null != convertView)
                convertView.setTag(viewHolder);
        } else {
            viewHolder = (ViewHolder) convertView.getTag();
        }

        if (type == TYPE_QQ_AD) {
            renderQqAd(viewHolder, position, convertView);
        } else if (type == TYPE_THREE_PIC || type == TYPE_NO_PIC || type == TYPE_ONE_SMALL || type == TYPE_ONE_BIG) {
            viewHolder.iv_dislike.setTag(position);

            viewHolder.mTitle.setTextSize(TsdContextHolder.getFont_size());

            RecommendEntity.Data data = mData.get(position);
            RecommendEntity.Data2 data2 = data.data;
            if (data2 == null) {
                return convertView;
            }
            boolean has_read = data2.has_read;
            String channel = data2.channel == null ? "" : data2.channel;
            String coverUrl = data2.cover_url == null ? "" : data2.cover_url;
            String[] images = data2.images;
            String flag = data.flag == null ? "" : data.flag;
            if (flag.equals("top")) {
                viewHolder.tsd_tv_stickied.setVisibility(View.VISIBLE);
            } else {
                viewHolder.tsd_tv_stickied.setVisibility(View.GONE);
            }
            viewHolder.mTitle.setText(data2.title);
            /*
            if (has_read) {
                viewHolder.mTitle.setTextColor(mContext.getResources().getColor(R.color.tsd_color_feed_item_text_hasread));
            } else {
                viewHolder.mTitle.setTextColor(mContext.getResources().getColor(R.color.tsd_color_feed_item_text));
            }
            */

            viewHolder.mSource.setText(channel);
            if (type == TYPE_ONE_BIG) {
                Glide.with(mContext).load(coverUrl).transition(new DrawableTransitionOptions().crossFade(TsdConstant.CROSSFADEDURATION)).into(viewHolder.mBigImage);
            } else if (type == TYPE_ONE_SMALL) {
                String img = null == images[0] ? "" : images[0];
                Glide.with(mContext).load(img).transition(new DrawableTransitionOptions().crossFade(TsdConstant.CROSSFADEDURATION)).into(viewHolder.mRightImage);
            } else if (type == TYPE_THREE_PIC) {
                String image0 = null == images[0] ? "" : images[0];
                String image1 = null == images[1] ? "" : images[1];
                String image2 = null == images[2] ? "" : images[2];
                RequestManager manager = Glide.with(mContext).setDefaultRequestOptions(options_common);
                RequestBuilder builder = manager.load(image0).transition(new DrawableTransitionOptions().crossFade(TsdConstant.CROSSFADEDURATION));
                builder.into(viewHolder.mImageLeft);

                Glide.with(mContext).applyDefaultRequestOptions(options_common).load(image1).transition(new DrawableTransitionOptions().crossFade(TsdConstant.CROSSFADEDURATION)).into(viewHolder.mImageMid);
                Glide.with(mContext).load(image2).transition(new DrawableTransitionOptions().crossFade(TsdConstant.CROSSFADEDURATION)).into(viewHolder.mImageRight);
            }

            if ((position + 1) < mData.size()) {
                RecommendEntity.Data data22 = mData.get(position + 1);
                if (data22.type.equals("seeHere")) {
                    viewHolder.tsd_article_divider.setVisibility(View.GONE);
                } else {
                    viewHolder.tsd_article_divider.setVisibility(View.VISIBLE);
                }
            }

        }

        return convertView;
    }

    private void fetchQqAd(final RecommendEntity.Data2 data2) {
        String adPlaceId = data2.appid;
        String nativeVideoPosID = data2.nativevideoposid;
        NativeMediaAD mediaAD = new NativeMediaAD(TsdContextHolder.getContext(), adPlaceId, nativeVideoPosID, new NativeMediaAD.NativeMediaADListener() {

            @Override
            public void onADLoaded(List<NativeMediaADData> list) {
                if (null != list && list.size() > 0) {
                    data2.nativeMediaADData = list.get(0);
                    if (null != mNotiListener)
                        mNotiListener.notifyData();
                }
            }

            @Override
            public void onNoAD(int errorCode) {
                LogUtil.i(TAG, "加载失败，错误码：" + errorCode);
                CommonUtil.clearAppidQ(mContext.getApplicationContext());
            }

            @Override
            public void onADStatusChanged(NativeMediaADData nativeMediaADData) {

            }

            @Override
            public void onADError(NativeMediaADData nativeMediaADData, int i) {

            }

            @Override
            public void onADVideoLoaded(NativeMediaADData nativeMediaADData) {

            }

            @Override
            public void onADExposure(NativeMediaADData nativeMediaADData) {
                adExposure(nativeMediaADData);
            }

            @Override
            public void onADClicked(NativeMediaADData nativeMediaADData) {
                adClick(nativeMediaADData);
            }
        });
        mediaAD.loadAD(1);
    }

    private void renderQqAd(final ViewHolder viewHolder, final int position, final View convertView) {
        //viewHolder.iv_ad.setVisibility(View.VISIBLE);
        //viewHolder.rl_ad.setVisibility(View.GONE);
        viewHolder.poster.setVisibility(View.VISIBLE);
        RecommendEntity.Data data = mData.get(position);
        RecommendEntity.Data2 data2 = data.data;
        final NativeMediaADData ad = data2.nativeMediaADData;
        if (null == ad) {
            fetchQqAd(data2);
        }

        String ad_img = null == ad ? "" : ad.getImgUrl();
        String title = null == ad ? "" : ad.getTitle();
        String iconUrl = null == ad ? "" : ad.getIconUrl();
        String desc = null == ad ? "" : ad.getDesc();

        viewHolder.name.setText(title);
        viewHolder.desc.setText(desc);
        Glide.with(mContext).load(ad_img).transition(new DrawableTransitionOptions().crossFade(500)).into(viewHolder.poster);
        Glide.with(mContext).load(TextUtils.isEmpty(iconUrl) ? ad_img : iconUrl).transition(new DrawableTransitionOptions().crossFade(500)).into(viewHolder.logo);

        viewHolder.download.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                if (null != ad)
                    ad.onClicked(v);
            }
        });
        convertView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (null == ad) return;
                FireDataManager.qqAdClick(ad);
                ad.onClicked(view);

                AdEntity adEntity = new AdEntity();
                adEntity.setDes(ad.getDesc());
                adEntity.setSrc("qq.e");
                adEntity.setTitle(ad.getTitle());
                String params = GsonUtil.GsonString(adEntity);
                restApi.adClickHttp(params);
            }
        });
        AdQqManager.renderDownLoadView(viewHolder.download, ad);
        if (null != ad)
            ad.onExposured(viewHolder.adInfoContainer);
    }

    private static class ViewHolder {
        private TextView name, desc;
        private TextView mTitle;
        private TextView mSource;
        private TextView tsd_tv_stickied;
        private ImageView mImageLeft;
        private ImageView iv_dislike;
        private ImageView mImageMid;
        private ImageView mImageRight;
        private ImageView mBigImage;
        private ImageView mRightImage;
        private LinearLayout adInfoContainer;
        private ImageView logo, poster;
        private Button download;
        private View tsd_article_divider;
    }

    @Override
    public void onADLoaded(List<NativeMediaADData> list) {
        LogUtil.i(TAG, "成功加载原生广告：" + list.size() + "条");
        setMediaADDataHashMap(list);
    }

    @Override
    public void onNoAD(int errorCode) {
        LogUtil.i(TAG, "加载失败，错误码：" + errorCode);
        Toast.makeText(mContext.getApplicationContext(), "加载失败，错误码：" + errorCode, Toast.LENGTH_SHORT).show();
    }

    @Override
    public void onADStatusChanged(NativeMediaADData nativeMediaADData) {
    }

    @Override
    public void onADError(NativeMediaADData nativeMediaADData, int errorCode) {
        LogUtil.i(TAG, "onADError: " + errorCode);
    }

    @Override
    public void onADVideoLoaded(NativeMediaADData adData) {
        Log.i(TAG, adData.getTitle() + " ---> 视频加载完成");
    }

    @Override
    public void onADExposure(NativeMediaADData adData) {
        Log.i(TAG, adData.getTitle() + " onADExposure");
        //AdPresenter.getInstance().QqAdShowHttp(TtCloudManager.getSid(), adData);
    }

    @Override
    public void onADClicked(NativeMediaADData adData) {
        Log.i(TAG, adData.getTitle() + " onADClicked");
    }

    private void initPopup(View anchorView, final int position) {
        FitPopupUtil fitPopupUtil = new FitPopupUtil((Activity) mContext);
        fitPopupUtil.setOnClickListener(new FitPopupUtil.OnCommitClickListener() {
            @Override
            public void onClick(String reason) {
                RecommendEntity.Data data = mData.get(position);
                RecommendEntity.Data2 data2 = data.data;
                String iid = null == data2.iid ? "" : data2.iid;
                EventBus.getDefault().post(new BuriedPointEvent(TsdConstant.ACTION_DISLIKE, iid, null, null, null));
                EventBus.getDefault().post(new DislikeEvent(position, GraphicAdapter.this));
            }
        });
        fitPopupUtil.showPopup(anchorView);
    }

    private void adClick(NativeMediaADData ad) {
        LogUtil.i(TAG, ad.getTitle() + " onADClicked");
        AdEntity adEntity = new AdEntity();
        adEntity.setDes(ad.getDesc());
        adEntity.setSrc("qq.e");
        adEntity.setTitle(ad.getTitle());
        String params = GsonUtil.GsonString(adEntity);
        restApi.adClickHttp(params);

        FireDataManager.qqAdClick(ad);
    }

    private void adExposure(NativeMediaADData nativeMediaADData) {
        LogUtil.i(TAG, nativeMediaADData.getTitle() + " onADExposure");
        AdEntity adEntity = new AdEntity();
        adEntity.setDes(nativeMediaADData.getDesc());
        adEntity.setSrc("qq.e");
        adEntity.setTitle(nativeMediaADData.getTitle());
        String params = GsonUtil.GsonString(adEntity);
        EventBus.getDefault().post(new BuriedPointEvent("adshow", null, null, params, null));

        FireDataManager.qqAdShow(nativeMediaADData);
    }

    public interface NotiListener {
        void notifyData();
    }

    private NotiListener mNotiListener;

    public void setNotiListener(NotiListener notiListener) {
        mNotiListener = notiListener;
    }
}

