/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model.util;

import android.database.Cursor;
import android.database.CursorWrapper;
import android.util.LruCache;
import java.lang.ref.SoftReference;
import za.co.cporm.model.generate.TableDetails;
import za.co.cporm.model.util.ModelInflater;

public class CPOrmCursor<T>
extends CursorWrapper {
    private final TableDetails tableDetails;
    private LruCache<Integer, SoftReference<T>> objectCache;

    public CPOrmCursor(TableDetails tableDetails, Cursor cursor) {
        super(cursor);
        this.tableDetails = tableDetails;
    }

    public CPOrmCursor(TableDetails tableDetails, Cursor cursor, int cacheSize) {
        this(tableDetails, cursor);
        this.enableCache(cacheSize);
    }

    public void enableCache(int size) {
        if (size > 0) {
            this.objectCache = new LruCache(size);
        }
    }

    public void enableCache() {
        this.enableCache(this.getCount());
    }

    public boolean isCacheEnabled() {
        return this.objectCache != null;
    }

    public T inflate() {
        return this.getObjectFromCacheOrInflate();
    }

    public TableDetails getTableDetails() {
        return this.tableDetails;
    }

    private T getObjectFromCacheOrInflate() {
        if (this.objectCache == null) {
            return ModelInflater.inflate((Cursor)this, this.tableDetails);
        }
        SoftReference objectReference = (SoftReference)this.objectCache.get((Object)this.getPosition());
        T cachedObject = null;
        if (objectReference != null) {
            cachedObject = objectReference.get();
        }
        if (cachedObject == null) {
            cachedObject = this.insertCacheObject();
        }
        return cachedObject;
    }

    private T insertCacheObject() {
        Object cachedObject = ModelInflater.inflate((Cursor)this, this.tableDetails);
        this.objectCache.put((Object)this.getPosition(), new SoftReference(cachedObject));
        return cachedObject;
    }
}

