/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model.util;

import android.content.Context;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import za.co.cporm.model.generate.ReflectionHelper;
import za.co.cporm.model.generate.TableDetails;

public class TableDetailsCache {
    private final Map<Class<?>, TableDetails> cache = new HashMap();

    public synchronized void init(Context context, List<Class<?>> objects) {
        for (int i = 0; i < objects.size(); ++i) {
            Class<?> object = objects.get(i);
            this.findTableDetails(context, object);
        }
    }

    public synchronized TableDetails findTableDetails(Context context, Class<?> object) {
        if (!this.cache.containsKey(object)) {
            try {
                this.cache.put(object, ReflectionHelper.getTableDetails(context, object));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Failed load table details for object " + object.getSimpleName(), ex);
            }
            if (!this.cache.containsKey(object)) {
                throw new IllegalArgumentException("No table details could be found for supplied object: " + object.getSimpleName());
            }
        }
        return this.cache.get(object);
    }
}

