/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model.loader.support;

import android.content.Context;
import android.database.Cursor;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import java.lang.ref.SoftReference;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import za.co.cporm.model.loader.support.CPOrmCursorAdaptor;
import za.co.cporm.model.util.CPOrmCursor;
import za.co.cporm.util.CPOrmLog;

public abstract class CPOrmAsyncCursorAdaptor<T, K>
extends CPOrmCursorAdaptor<T, K> {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final Queue<T> loaderQueue = new LinkedList<T>();
    private final LoaderThreadHandler threadHandler = new LoaderThreadHandler(this);
    private LoaderThread loaderThread;

    public CPOrmAsyncCursorAdaptor(Context context, int layoutId) {
        super(context, layoutId);
    }

    public CPOrmAsyncCursorAdaptor(Context context, Cursor c, int layoutId) {
        super(context, c, layoutId);
    }

    public CPOrmAsyncCursorAdaptor(Context context, Cursor c, int layoutId, int flags) {
        super(context, c, layoutId, flags);
    }

    @Override
    public void changeCursor(Cursor cursor) {
        this.dispose();
        super.changeCursor(cursor);
    }

    @Override
    public void bindView(View view, Context context, Cursor cursor) {
        this.startLoaderThreadIfStopped();
        this.lock.lock();
        Object inflate = ((CPOrmCursor)this.getCursor()).inflate();
        if (!this.loaderQueue.contains(inflate)) {
            this.loaderQueue.offer(inflate);
        }
        this.condition.signal();
        this.lock.unlock();
        super.bindView(view, context, cursor);
    }

    private void dispose() {
        this.lock.lock();
        if (this.loaderThread != null) {
            this.loaderThread.isCancelled = true;
            this.loaderThread = null;
        }
        this.condition.signal();
        this.lock.unlock();
    }

    private void startLoaderThreadIfStopped() {
        if (this.loaderThread == null) {
            this.loaderThread = new LoaderThread();
            this.loaderThread.start();
        }
    }

    public abstract boolean loadAsyncInformation(T var1);

    private static class LoaderThreadHandler
    extends Handler {
        private final SoftReference<CPOrmCursorAdaptor> adaptorReference;

        LoaderThreadHandler(CPOrmCursorAdaptor adaptor) {
            this.adaptorReference = new SoftReference<CPOrmCursorAdaptor>(adaptor);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            CPOrmCursorAdaptor adaptor = this.adaptorReference.get();
            if (adaptor != null) {
                adaptor.notifyDataSetChanged();
            }
        }
    }

    private class LoaderThread
    extends Thread {
        volatile boolean isCancelled = false;
        CPOrmCursor<T> cursor = (CPOrmCursor)CPOrmAsyncCursorAdaptor.this.getCursor();

        private LoaderThread() {
        }

        @Override
        public void run() {
            this.setName(CPOrmAsyncCursorAdaptor.class.getSimpleName() + "_Loader");
            try {
                while (this.isStillValid()) {
                    CPOrmAsyncCursorAdaptor.this.lock.lock();
                    while (CPOrmAsyncCursorAdaptor.this.loaderQueue.peek() == null && this.isStillValid()) {
                        CPOrmAsyncCursorAdaptor.this.condition.await();
                    }
                    if (!this.isStillValid()) {
                        CPOrmAsyncCursorAdaptor.this.lock.unlock();
                        break;
                    }
                    Object item = CPOrmAsyncCursorAdaptor.this.loaderQueue.poll();
                    CPOrmAsyncCursorAdaptor.this.lock.unlock();
                    if (!CPOrmAsyncCursorAdaptor.this.loadAsyncInformation(item)) continue;
                    CPOrmAsyncCursorAdaptor.this.threadHandler.sendEmptyMessage(0);
                }
            }
            catch (InterruptedException e) {
                CPOrmLog.e("Failed while waiting for items", e);
            }
        }

        private boolean isStillValid() {
            return this.cursor != null && !this.cursor.isClosed() && !this.isCancelled;
        }
    }
}

