/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.provider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.text.TextUtils;
import java.util.Arrays;
import za.co.cporm.model.CPOrmConfiguration;
import za.co.cporm.model.CPOrmDatabase;
import za.co.cporm.model.generate.TableDetails;
import za.co.cporm.model.util.ManifestHelper;
import za.co.cporm.provider.util.UriMatcherHelper;
import za.co.cporm.util.CPOrmLog;

public class CPOrmContentProvider
extends ContentProvider {
    public static final String PARAMETER_OFFSET = "OFFSET";
    public static final String PARAMETER_LIMIT = "LIMIT";
    public static final String PARAMETER_SYNC = "IS_SYNC";
    private CPOrmConfiguration cPOrmConfiguration;
    private CPOrmDatabase database;
    private UriMatcherHelper uriMatcherHelper;
    private boolean debugEnabled;

    public boolean onCreate() {
        this.cPOrmConfiguration = ManifestHelper.getConfiguration(this.getContext());
        this.database = new CPOrmDatabase(this.getContext(), this.cPOrmConfiguration);
        this.uriMatcherHelper = new UriMatcherHelper(this.getContext());
        this.uriMatcherHelper.init(this.getContext(), this.database.getcPOrmConfiguration(), this.database.getTableDetailsCache());
        this.debugEnabled = this.cPOrmConfiguration.isQueryLoggingEnabled();
        return true;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        Cursor cursor;
        TableDetails tableDetails = this.uriMatcherHelper.getTableDetails(uri);
        SQLiteDatabase db = this.database.getReadableDatabase();
        String limit = this.constructLimit(uri);
        if (this.debugEnabled) {
            CPOrmLog.d("********* Query **********");
            CPOrmLog.d("Uri: " + uri);
            CPOrmLog.d("Projection: " + Arrays.toString(projection));
            CPOrmLog.d("Selection: " + selection);
            CPOrmLog.d("Args: " + Arrays.toString(selectionArgs));
            CPOrmLog.d("Sort: " + sortOrder);
            CPOrmLog.d("Limit: " + limit);
        }
        if (this.uriMatcherHelper.isSingleItemRequested(uri)) {
            String itemId = uri.getLastPathSegment();
            TableDetails.ColumnDetails primaryKeyColumn = tableDetails.findPrimaryKeyColumn();
            cursor = db.query(tableDetails.getTableName(), projection, primaryKeyColumn.getColumnName() + " = ?", new String[]{itemId}, null, sortOrder, limit);
        } else {
            cursor = db.query(tableDetails.getTableName(), projection, selection, selectionArgs, null, null, sortOrder, limit);
        }
        cursor.setNotificationUri(this.getContext().getContentResolver(), uri);
        return cursor;
    }

    public String getType(Uri uri) {
        return this.uriMatcherHelper.getType(uri);
    }

    public Uri insert(Uri uri, ContentValues contentValues) {
        long insertId;
        TableDetails tableDetails = this.uriMatcherHelper.getTableDetails(uri);
        SQLiteDatabase db = this.database.getWritableDatabase();
        if (this.debugEnabled) {
            CPOrmLog.d("********* Insert **********");
            CPOrmLog.d("Uri: " + uri);
            CPOrmLog.d("Content Values: " + contentValues);
        }
        if ((insertId = db.insertOrThrow(tableDetails.getTableName(), null, contentValues)) == -1L) {
            throw new IllegalArgumentException("Failed to insert row for into table " + tableDetails.getTableName() + " using values " + contentValues);
        }
        this.notifyChanges(uri, tableDetails);
        TableDetails.ColumnDetails primaryKeyColumn = tableDetails.findPrimaryKeyColumn();
        if (primaryKeyColumn.isAutoIncrement()) {
            return this.uriMatcherHelper.generateSingleItemUri(tableDetails, insertId);
        }
        String primaryKeyValue = contentValues.getAsString(primaryKeyColumn.getColumnName());
        return this.uriMatcherHelper.generateSingleItemUri(tableDetails, primaryKeyValue);
    }

    public int delete(Uri uri, String where, String[] args) {
        int deleteCount;
        TableDetails tableDetails = this.uriMatcherHelper.getTableDetails(uri);
        SQLiteDatabase db = this.database.getWritableDatabase();
        if (this.debugEnabled) {
            CPOrmLog.d("********* Delete **********");
            CPOrmLog.d("Uri: " + uri);
            CPOrmLog.d("Where: " + where);
            CPOrmLog.d("Args: " + Arrays.toString(args));
        }
        if (this.uriMatcherHelper.isSingleItemRequested(uri)) {
            String itemId = uri.getLastPathSegment();
            TableDetails.ColumnDetails primaryKeyColumn = tableDetails.findPrimaryKeyColumn();
            deleteCount = db.delete(tableDetails.getTableName(), primaryKeyColumn.getColumnName() + " = ?", new String[]{itemId});
        } else {
            deleteCount = db.delete(tableDetails.getTableName(), where, args);
        }
        if (deleteCount == 0) {
            return deleteCount;
        }
        this.notifyChanges(uri, tableDetails);
        return deleteCount;
    }

    public int update(Uri uri, ContentValues contentValues, String where, String[] args) {
        int updateCount;
        TableDetails tableDetails = this.uriMatcherHelper.getTableDetails(uri);
        SQLiteDatabase db = this.database.getWritableDatabase();
        if (this.debugEnabled) {
            CPOrmLog.d("********* Update **********");
            CPOrmLog.d("Uri: " + uri);
            CPOrmLog.d("Content Values: " + contentValues);
            CPOrmLog.d("Where: " + where);
            CPOrmLog.d("Args: " + Arrays.toString(args));
        }
        if (this.uriMatcherHelper.isSingleItemRequested(uri)) {
            String itemId = uri.getLastPathSegment();
            TableDetails.ColumnDetails primaryKeyColumn = tableDetails.findPrimaryKeyColumn();
            updateCount = db.update(tableDetails.getTableName(), contentValues, primaryKeyColumn.getColumnName() + " = ?", new String[]{itemId});
        } else {
            updateCount = db.update(tableDetails.getTableName(), contentValues, where, args);
        }
        if (updateCount > 0 && this.shouldChangesBeNotified(tableDetails, contentValues)) {
            this.notifyChanges(uri, tableDetails);
        }
        return updateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int bulkInsert(Uri uri, ContentValues[] values) {
        TableDetails tableDetails = this.uriMatcherHelper.getTableDetails(uri);
        SQLiteDatabase db = this.database.getWritableDatabase();
        db.beginTransactionNonExclusive();
        if (this.debugEnabled) {
            CPOrmLog.d("********* Bulk Insert **********");
            CPOrmLog.d("Uri: " + uri);
        }
        int count = 0;
        try {
            for (ContentValues contentValues : values) {
                db.insertOrThrow(tableDetails.getTableName(), null, contentValues);
                ++count;
            }
            db.setTransactionSuccessful();
            this.notifyChanges(uri, tableDetails);
        }
        finally {
            db.endTransaction();
        }
        return count;
    }

    private String constructLimit(Uri uri) {
        String offsetParam = uri.getQueryParameter(PARAMETER_OFFSET);
        String limitParam = uri.getQueryParameter(PARAMETER_LIMIT);
        Integer offset = null;
        Integer limit = null;
        if (!TextUtils.isEmpty((CharSequence)offsetParam) && TextUtils.isDigitsOnly((CharSequence)offsetParam)) {
            offset = Integer.valueOf(offsetParam);
        }
        if (!TextUtils.isEmpty((CharSequence)limitParam) && TextUtils.isDigitsOnly((CharSequence)limitParam)) {
            limit = Integer.valueOf(limitParam);
        }
        if (limit == null && offset == null) {
            return null;
        }
        StringBuilder limitStatement = new StringBuilder();
        if (limit != null && offset != null) {
            limitStatement.append(offset);
            limitStatement.append(",");
            limitStatement.append(limit);
        } else if (limit != null) {
            limitStatement.append(limit);
        } else {
            throw new IllegalArgumentException("A limit must also be provided when setting an offset");
        }
        return limitStatement.toString();
    }

    private boolean shouldChangesBeNotified(TableDetails tableDetails, ContentValues contentValues) {
        boolean notify = false;
        for (String columnName : contentValues.keySet()) {
            TableDetails.ColumnDetails column = tableDetails.findColumn(columnName);
            if (column == null) continue;
            notify = notify || column.notifyChanges();
        }
        return notify;
    }

    private void notifyChanges(Uri uri, TableDetails tableDetails) {
        Boolean sync = uri.getBooleanQueryParameter(PARAMETER_SYNC, true);
        this.getContext().getContentResolver().notifyChange(uri, null, sync.booleanValue());
        if (!tableDetails.getChangeListeners().isEmpty()) {
            for (Class<?> changeListener : tableDetails.getChangeListeners()) {
                TableDetails changeListenerDetails = this.database.getTableDetailsCache().findTableDetails(this.getContext(), changeListener);
                if (changeListenerDetails == null) continue;
                Uri changeUri = this.uriMatcherHelper.generateItemUri(changeListenerDetails);
                this.getContext().getContentResolver().notifyChange(changeUri, null, sync.booleanValue());
            }
        }
    }
}

