/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model.util;

import android.content.Context;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import za.co.cporm.model.CPOrm;
import za.co.cporm.model.annotation.References;
import za.co.cporm.model.generate.ReflectionHelper;
import za.co.cporm.model.util.CPOrmException;

public class ReferenceMap
extends IdentityHashMap<Class<?>, SoftReference<Object>> {
    private final Object referenceObject;

    public ReferenceMap(Object referenceObject) {
        this.referenceObject = referenceObject;
    }

    public <T> T findReferent(Context context, Class<T> referenceToFind) {
        SoftReference softReference;
        Object referent;
        if (this.containsKey(referenceToFind) && (referent = (softReference = (SoftReference)super.get(referenceToFind)).get()) != null) {
            return referent;
        }
        for (Field field : ReflectionHelper.getAllObjectFields(this.referenceObject.getClass())) {
            try {
                T reference;
                if (!field.isAnnotationPresent(References.class) || field.getAnnotation(References.class).value() != referenceToFind) continue;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                if ((reference = CPOrm.findByPrimaryKey(context, referenceToFind, field.get(this.referenceObject))) != null) {
                    this.put(referenceToFind, new SoftReference<T>(reference));
                }
                return reference;
            }
            catch (IllegalAccessException e) {
                throw new CPOrmException("Could not access required field " + field.getName(), e);
            }
        }
        throw new CPOrmException("No Reference found to " + referenceToFind.getSimpleName() + " from " + this.referenceObject.getClass().getSimpleName());
    }
}

