/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model;

import android.annotation.TargetApi;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.util.Log;
import za.co.cporm.model.ModelFactory;
import za.co.cporm.model.generate.TableDetails;
import za.co.cporm.model.generate.TableGenerator;
import za.co.cporm.model.generate.TableView;
import za.co.cporm.model.generate.TableViewGenerator;
import za.co.cporm.model.util.CPOrmCursorFactory;
import za.co.cporm.model.util.ManifestHelper;
import za.co.cporm.model.util.TableDetailsCache;

public class CPOrmDatabase
extends SQLiteOpenHelper {
    private static final String TAG = "CPOrmDatabase";
    private final Context context;
    private final ModelFactory modelFactory;
    private final TableDetailsCache tableDetailsCache;
    private final boolean debugEnabled;

    public CPOrmDatabase(Context context, boolean debugEnabled) {
        super(context, ManifestHelper.getDatabaseName(context), (SQLiteDatabase.CursorFactory)new CPOrmCursorFactory(debugEnabled), ManifestHelper.getDatabaseVersion(context));
        this.modelFactory = ManifestHelper.getModelFactory(context);
        this.context = context;
        this.tableDetailsCache = new TableDetailsCache();
        this.tableDetailsCache.init(context, this.modelFactory.getDataModelObjects());
        this.debugEnabled = debugEnabled;
    }

    public void onCreate(SQLiteDatabase sqLiteDatabase) {
        for (Class<?> dataModelObject : this.modelFactory.getDataModelObjects()) {
            String createStatement;
            if (TableView.class.isAssignableFrom(dataModelObject)) {
                createStatement = TableViewGenerator.createViewStatement(this.findTableDetails(dataModelObject), dataModelObject);
                if (this.debugEnabled) {
                    Log.d((String)TAG, (String)("Creating View: " + createStatement));
                }
                sqLiteDatabase.execSQL(createStatement);
                continue;
            }
            createStatement = TableGenerator.generateTableCreate(this.findTableDetails(dataModelObject), false);
            if (this.debugEnabled) {
                Log.d((String)TAG, (String)("Creating Table: " + createStatement));
            }
            sqLiteDatabase.execSQL(createStatement);
        }
    }

    public void onUpgrade(SQLiteDatabase sqLiteDatabase, int i, int i1) {
        for (Class<?> dataModelObject : this.modelFactory.getDataModelObjects()) {
            String statement;
            if (TableView.class.isAssignableFrom(dataModelObject)) {
                statement = TableViewGenerator.createDropViewStatement(this.findTableDetails(dataModelObject));
                if (this.debugEnabled) {
                    Log.d((String)TAG, (String)("Dropping View: " + statement));
                }
                sqLiteDatabase.execSQL(statement);
                continue;
            }
            statement = TableGenerator.generateTableDrop(this.findTableDetails(dataModelObject), false);
            if (this.debugEnabled) {
                Log.d((String)TAG, (String)("Dropping Table: " + statement));
            }
            sqLiteDatabase.execSQL(statement);
        }
        this.onCreate(sqLiteDatabase);
    }

    @TargetApi(value=16)
    public void onConfigure(SQLiteDatabase db) {
        super.onConfigure(db);
        if (!db.isReadOnly()) {
            db.enableWriteAheadLogging();
        }
    }

    public void onOpen(SQLiteDatabase db) {
        super.onOpen(db);
        if (Build.VERSION.SDK_INT < 16 && Build.VERSION.SDK_INT > 11) {
            db.enableWriteAheadLogging();
        }
    }

    private TableDetails findTableDetails(Class<?> object) {
        return this.tableDetailsCache.findTableDetails(this.context, object);
    }

    public TableDetailsCache getTableDetailsCache() {
        return this.tableDetailsCache;
    }

    public ModelFactory getModelFactory() {
        return this.modelFactory;
    }
}

