/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model.query;

import android.content.Context;
import android.text.TextUtils;
import java.util.Collection;
import java.util.Iterator;
import za.co.cporm.model.map.SqlColumnMappingFactory;
import za.co.cporm.model.query.DataFilterClause;
import za.co.cporm.model.query.QueryBuilder;
import za.co.cporm.model.query.Select;

public class DataFilterCriterion
implements DataFilterClause<DataFilterCriterion> {
    public String filterColumn;
    public DataFilterOperator filterOperator;
    public Object filterValue;

    private DataFilterCriterion() {
    }

    public DataFilterCriterion(String filterColumn, DataFilterOperator operator, Object filterValue) {
        this.filterColumn = filterColumn;
        this.filterOperator = operator;
        this.filterValue = filterValue;
    }

    @Override
    public QueryBuilder buildWhereClause(Context context, SqlColumnMappingFactory columnMappingFactory) {
        QueryBuilder builder = new QueryBuilder();
        builder.append(this.filterColumn, new Object[0]);
        builder.append(" ", new Object[0]);
        builder.append(this.filterOperator.getSqlRepresentation(), new Object[0]);
        if (this.filterValue != null) {
            if (this.filterValue instanceof Collection) {
                Iterator collectionIterator = ((Collection)this.filterValue).iterator();
                builder.append(" (", new Object[0]);
                while (collectionIterator.hasNext()) {
                    builder.append("?", this.convertToSQLFormat(columnMappingFactory, collectionIterator.next()));
                    if (!collectionIterator.hasNext()) continue;
                    builder.append(", ", new Object[0]);
                }
                builder.append(")", new Object[0]);
            } else if (this.filterValue instanceof Select) {
                Select innerSelect = (Select)this.filterValue;
                if (!innerSelect.isSingleColumnProjection()) {
                    throw new IllegalArgumentException("Inner select can only contain a single column selection");
                }
                builder.append(" (", new Object[0]);
                builder.append(innerSelect.getSelectQuery(context));
                builder.append(")", new Object[0]);
            } else {
                builder.append(" ?", this.convertToSQLFormat(columnMappingFactory, this.filterValue));
            }
        }
        return builder;
    }

    @Override
    public String getWhereClause() {
        QueryBuilder builder = new QueryBuilder();
        builder.append(this.filterColumn, new Object[0]);
        builder.append(" ", new Object[0]);
        builder.append(this.filterOperator.getSqlRepresentation(), new Object[0]);
        if (this.filterValue != null) {
            if (this.filterValue instanceof Collection) {
                Iterator collectionIterator = ((Collection)this.filterValue).iterator();
                builder.append(" (", new Object[0]);
                while (collectionIterator.hasNext()) {
                    builder.append("?", new Object[0]);
                    if (!collectionIterator.hasNext()) continue;
                    builder.append(", ", new Object[0]);
                }
                builder.append(")", new Object[0]);
            } else if (this.filterValue instanceof Select) {
                Select innerSelect = (Select)this.filterValue;
                if (!innerSelect.isSingleColumnProjection()) {
                    throw new IllegalArgumentException("Inner select can only contain a single column selection");
                }
                builder.append(" (", new Object[0]);
                builder.append(innerSelect.getSelectQuery(null));
                builder.append(")", new Object[0]);
            } else {
                builder.append(" ?", new Object[0]);
            }
        }
        return builder.toString();
    }

    @Override
    public boolean hasFilterValue() {
        return this.filterColumn != null && this.filterOperator != null;
    }

    @Override
    public DataFilterCriterion addClause(DataFilterClause clause, DataFilterClause.DataFilterConjunction conjunction) {
        throw new UnsupportedOperationException("Clauses cannot be added to a data filter criterion");
    }

    private Object convertToSQLFormat(SqlColumnMappingFactory columnMappingFactory, Object object) {
        if (this.filterOperator == DataFilterOperator.LIKE || this.filterOperator == DataFilterOperator.NOT_LIKE) {
            return "%" + object + "%";
        }
        if (this.filterOperator == DataFilterOperator.BEGINS_WITH) {
            return object + "%";
        }
        if (this.filterOperator == DataFilterOperator.ENDS_WITH) {
            return "%" + object;
        }
        return columnMappingFactory.findColumnMapping(object.getClass()).toSqlType(object);
    }

    private void validate() {
        if (TextUtils.isEmpty((CharSequence)this.filterColumn)) {
            throw new IllegalStateException("Filter column is empty");
        }
        if (this.filterOperator == null) {
            throw new IllegalStateException("Filter operator not specified");
        }
        if (this.filterValue == null && this.filterOperator != DataFilterOperator.IS_NULL && this.filterOperator != DataFilterOperator.IS_NOT_NULL) {
            throw new IllegalStateException("Filter value must be supplied with this operator");
        }
    }

    private void setFilterColumn(String filterColumn) {
        this.filterColumn = filterColumn;
    }

    private void setFilterOperator(DataFilterOperator filterOperator) {
        this.filterOperator = filterOperator;
    }

    private void setFilterValue(Object filterValue) {
        this.filterValue = filterValue;
    }

    public static enum DataFilterOperator {
        EQUAL("="),
        NOT_EQUAL("<>"),
        GREATER_OR_EQUAL(">="),
        SMALLER_OR_EQUAL("<="),
        GREATER_THAN(">"),
        SMALLER_THAN("<"),
        LIKE("LIKE"),
        NOT_LIKE("NOT LIKE"),
        IN("IN"),
        NOT_IN("NOT IN"),
        IS_NULL("IS NULL"),
        IS_NOT_NULL("IS NOT NULL"),
        BEGINS_WITH("LIKE"),
        ENDS_WITH("LIKE");

        private final String sqlRepresentation;

        private DataFilterOperator(String sqlRepresentation) {
            this.sqlRepresentation = sqlRepresentation;
        }

        public String getSqlRepresentation() {
            return this.sqlRepresentation;
        }
    }

    public static class Builder<T extends DataFilterClause<T>> {
        private final T originator;
        private final DataFilterClause.DataFilterConjunction conjunction;
        private final DataFilterCriterion criterion;

        protected Builder(T originator, DataFilterClause.DataFilterConjunction conjunction) {
            this.originator = originator;
            this.conjunction = conjunction;
            this.criterion = new DataFilterCriterion();
        }

        public T equal(String column, Object value) {
            this.column(column);
            this.criterion.setFilterOperator(DataFilterOperator.EQUAL);
            return this.value(value);
        }

        public T notEqual(String column, Object value) {
            this.column(column);
            this.criterion.setFilterOperator(DataFilterOperator.NOT_EQUAL);
            return this.value(value);
        }

        public T greaterOrEqual(String column, Object value) {
            this.column(column);
            this.criterion.setFilterOperator(DataFilterOperator.GREATER_OR_EQUAL);
            return this.value(value);
        }

        public T smallerOrEqual(String column, Object value) {
            this.column(column);
            this.criterion.setFilterOperator(DataFilterOperator.SMALLER_OR_EQUAL);
            return this.value(value);
        }

        public T greaterThan(String column, Object value) {
            this.column(column);
            this.criterion.setFilterOperator(DataFilterOperator.GREATER_THAN);
            return this.value(value);
        }

        public T smallerThan(String column, Object value) {
            this.column(column);
            this.criterion.setFilterOperator(DataFilterOperator.SMALLER_THAN);
            return this.value(value);
        }

        public T like(String column, Object value) {
            this.column(column);
            this.criterion.setFilterOperator(DataFilterOperator.LIKE);
            return this.value(value);
        }

        public T notLike(String column, Object value) {
            this.column(column);
            this.criterion.setFilterOperator(DataFilterOperator.NOT_LIKE);
            return this.value(value);
        }

        public T in(String column, Collection value) {
            this.column(column);
            this.criterion.setFilterOperator(DataFilterOperator.IN);
            return this.value(value);
        }

        public T in(String column, Select value) {
            this.column(column);
            this.criterion.setFilterOperator(DataFilterOperator.IN);
            return this.value(value);
        }

        public T notIn(String column, Collection value) {
            this.column(column);
            this.criterion.setFilterOperator(DataFilterOperator.NOT_IN);
            return this.value(value);
        }

        public T notIn(String column, Select value) {
            this.column(column);
            this.criterion.setFilterOperator(DataFilterOperator.NOT_IN);
            return this.value(value);
        }

        public T isNull(String column) {
            this.column(column);
            this.criterion.setFilterOperator(DataFilterOperator.IS_NULL);
            return this.build();
        }

        public T isNotNull(String column) {
            this.column(column);
            this.criterion.setFilterOperator(DataFilterOperator.IS_NOT_NULL);
            return this.build();
        }

        private Builder<T> column(String column) {
            this.criterion.setFilterColumn(column);
            return this;
        }

        private T value(Object value) {
            this.criterion.setFilterValue(value);
            return this.build();
        }

        private T build() {
            this.criterion.validate();
            this.originator.addClause(this.criterion, this.conjunction);
            return this.originator;
        }
    }
}

