/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model.query;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import za.co.cporm.model.CPHelper;
import za.co.cporm.model.generate.TableDetails;
import za.co.cporm.model.query.DataFilterClause;
import za.co.cporm.model.query.DataFilterCriteria;
import za.co.cporm.model.query.DataFilterCriterion;
import za.co.cporm.model.query.QueryBuilder;
import za.co.cporm.model.util.CPOrmCursor;
import za.co.cporm.model.util.ContentResolverValues;
import za.co.cporm.model.util.CursorIterator;
import za.co.cporm.provider.util.UriMatcherHelper;

public class Select<T>
implements DataFilterClause {
    private final Class<T> dataObjectClass;
    private final Context context;
    private DataFilterCriteria filterCriteria;
    private List<String> sortingOrderList;
    private List<String> includedColumns;
    private List<String> excludedColumns;

    private Select(Context context, Class<T> dataObjectClass) {
        this.context = context;
        this.dataObjectClass = dataObjectClass;
        this.sortingOrderList = new LinkedList<String>();
        this.filterCriteria = new DataFilterCriteria(context);
        this.includedColumns = new ArrayList<String>();
        this.excludedColumns = new ArrayList<String>();
    }

    public static <T> Select<T> from(Context context, Class<T> dataObjectClass) {
        return new Select<T>(context, dataObjectClass);
    }

    public Select<T> where(DataFilterClause filterClause) {
        this.filterCriteria.addClause(filterClause);
        return this;
    }

    public Select<T> where(DataFilterClause filterClause, DataFilterClause.DataFilterConjunction conjunction) {
        this.filterCriteria.addClause(filterClause, conjunction);
        return this;
    }

    public Select<T> whereEquals(String column, Object value) {
        this.addClause(new DataFilterCriterion(this.context, column, DataFilterCriterion.DataFilterOperator.EQUAL, value), DataFilterClause.DataFilterConjunction.AND);
        return this;
    }

    public Select<T> whereLike(String column, Object value) {
        this.addClause(new DataFilterCriterion(this.context, column, DataFilterCriterion.DataFilterOperator.LIKE, value), DataFilterClause.DataFilterConjunction.AND);
        return this;
    }

    public DataFilterCriterion.Builder<Select<T>> and() {
        return new DataFilterCriterion.Builder<Select<T>>(this.context, this, DataFilterClause.DataFilterConjunction.AND);
    }

    public DataFilterCriterion.Builder<Select<T>> or() {
        return new DataFilterCriterion.Builder<Select<T>>(this.context, this, DataFilterClause.DataFilterConjunction.OR);
    }

    public DataFilterCriteria.Builder<Select<T>> openBracketAnd() {
        return new DataFilterCriteria.Builder<Select<T>>(this.context, this, DataFilterClause.DataFilterConjunction.AND);
    }

    public DataFilterCriteria.Builder<Select<T>> openBracketOr() {
        return new DataFilterCriteria.Builder<Select<T>>(this.context, this, DataFilterClause.DataFilterConjunction.OR);
    }

    public Select<T> sortDesc(String ... columns) {
        for (String column : columns) {
            this.sortingOrderList.add(column + " DESC");
        }
        return this;
    }

    public Select<T> sortAsc(String ... columns) {
        for (String column : columns) {
            this.sortingOrderList.add(column + " ASC");
        }
        return this;
    }

    public Select<T> include(String ... columns) {
        for (String column : columns) {
            this.includedColumns.add(column);
        }
        return this;
    }

    public Select<T> exclude(String ... columns) {
        for (String column : columns) {
            this.excludedColumns.add(column);
        }
        return this;
    }

    public CPOrmCursor<T> queryAsCursor() {
        TableDetails tableDetails = CPHelper.findTableDetails(this.context, this.dataObjectClass);
        ContentResolverValues contentResolverValues = this.asContentResolverValue();
        ContentResolver contentResolver = this.context.getContentResolver();
        Cursor cursor = contentResolver.query(contentResolverValues.getItemUri(), contentResolverValues.getProjection(), contentResolverValues.getWhere(), contentResolverValues.getWhereArgs(), contentResolverValues.getSortOrder());
        return new CPOrmCursor(tableDetails, cursor);
    }

    public Iterator<T> queryAsIterator() {
        CPOrmCursor<T> cursor = this.queryAsCursor();
        return new CursorIterator(cursor.getTableDetails(), (Cursor)cursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> queryAsList() {
        ArrayList<T> resultList = new ArrayList<T>();
        try (CPOrmCursor<T> cursor = this.queryAsCursor();){
            while (cursor.moveToNext()) {
                resultList.add(cursor.inflate());
            }
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queryAsCount() {
        try (CPOrmCursor<T> cursor = this.queryAsCursor();){
            int n = cursor.getCount();
            return n;
        }
    }

    public ContentResolverValues asContentResolverValue() {
        TableDetails tableDetails = CPHelper.findTableDetails(this.context, this.dataObjectClass);
        QueryBuilder where = this.getWhereClause();
        QueryBuilder sort = this.buildSort();
        Uri itemUri = UriMatcherHelper.generateItemUri(this.context, tableDetails);
        return new ContentResolverValues(itemUri, this.getProjection(tableDetails), where.getQueryString(), where.getQueryArgsAsArray(), sort.getQueryString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T first() {
        try (CPOrmCursor<T> cursor = this.queryAsCursor();){
            if (cursor.moveToNext()) {
                T t = cursor.inflate();
                return t;
            }
            T t = null;
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T last() {
        try (CPOrmCursor<T> cursor = this.queryAsCursor();){
            if (cursor.moveToLast()) {
                T t = cursor.inflate();
                return t;
            }
            T t = null;
            return t;
        }
    }

    private String[] getProjection(TableDetails tableDetails) {
        if (!this.includedColumns.isEmpty()) {
            return this.includedColumns.toArray(new String[0]);
        }
        if (!this.excludedColumns.isEmpty()) {
            ArrayList<String> columns = new ArrayList<String>();
            for (String column : tableDetails.getColumnNames()) {
                if (this.excludedColumns.contains(column)) continue;
                columns.add(column);
            }
            return columns.toArray(new String[0]);
        }
        return tableDetails.getColumnNames();
    }

    private QueryBuilder buildSort() {
        QueryBuilder builder = new QueryBuilder();
        Iterator<String> sortIterator = this.sortingOrderList.iterator();
        while (sortIterator.hasNext()) {
            builder.append(sortIterator.next(), new Object[0]);
            if (!sortIterator.hasNext()) continue;
            builder.append(", ", new Object[0]);
        }
        return builder;
    }

    protected QueryBuilder getSelectQuery() {
        TableDetails tableDetails = CPHelper.findTableDetails(this.context, this.dataObjectClass);
        QueryBuilder select = new QueryBuilder();
        QueryBuilder where = this.getWhereClause();
        select.append("SELECT ", new Object[0]);
        Iterator<String> columnIterator = Arrays.asList(this.getProjection(tableDetails)).iterator();
        while (columnIterator.hasNext()) {
            select.append(columnIterator.next(), new Object[0]);
            if (!columnIterator.hasNext()) continue;
            select.append(", ", new Object[0]);
        }
        select.append(" FROM ", new Object[0]);
        select.append(tableDetails.getTableName(), new Object[0]);
        select.append(" WHERE ", new Object[0]);
        select.append(where);
        return select;
    }

    protected boolean isSingleColumnProjection() {
        return this.includedColumns.size() == 1;
    }

    @Override
    public QueryBuilder getWhereClause() {
        return this.filterCriteria.getWhereClause();
    }

    @Override
    public void addClause(DataFilterClause clause, DataFilterClause.DataFilterConjunction conjunction) {
        this.filterCriteria.addClause(clause, conjunction);
    }

    public String toString() {
        return this.getWhereClause().toString();
    }
}

