/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model.query;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class QueryBuilder {
    private final StringBuilder queryBuffer = new StringBuilder();
    private final List<Object> argsStore = new LinkedList<Object>();

    public void append(String query, Object ... args) {
        this.queryBuffer.append(query);
        for (Object arg : args) {
            this.argsStore.add(String.valueOf(arg));
        }
    }

    public void append(QueryBuilder queryBuilder) {
        this.queryBuffer.append(queryBuilder.getQueryString());
        this.argsStore.addAll(queryBuilder.getQueryArgs());
    }

    public String getQueryString() {
        StringBuilder queryString = new StringBuilder();
        queryString.append((CharSequence)this.queryBuffer);
        return queryString.toString();
    }

    private Collection<Object> getQueryArgs() {
        LinkedList<Object> queryArgs = new LinkedList<Object>();
        queryArgs.addAll(this.argsStore);
        return Collections.unmodifiableCollection(queryArgs);
    }

    public String[] getQueryArgsAsArray() {
        return this.getQueryArgs().toArray(new String[0]);
    }

    public String toString() {
        return this.getQueryString();
    }
}

