/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model.query;

import android.content.Context;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import za.co.cporm.model.query.DataFilterClause;
import za.co.cporm.model.query.DataFilterCriterion;
import za.co.cporm.model.query.QueryBuilder;

public class DataFilterCriteria
implements DataFilterClause {
    private final Context context;
    Map<DataFilterClause, DataFilterClause.DataFilterConjunction> filterClauses;

    public DataFilterCriteria(Context context) {
        this.context = context;
        this.filterClauses = new LinkedHashMap<DataFilterClause, DataFilterClause.DataFilterConjunction>();
    }

    public void addClause(DataFilterClause clause) {
        this.addClause(clause, null);
    }

    @Override
    public void addClause(DataFilterClause clause, DataFilterClause.DataFilterConjunction conjunction) {
        if (conjunction == null) {
            conjunction = DataFilterClause.DataFilterConjunction.AND;
        }
        this.filterClauses.put(clause, conjunction);
    }

    public void addCriterion(String column, DataFilterCriterion.DataFilterOperator operator, Object filterValue) {
        this.addClause(new DataFilterCriterion(this.context, column, operator, filterValue));
    }

    @Override
    public QueryBuilder getWhereClause() {
        QueryBuilder builder = new QueryBuilder();
        if (!this.filterClauses.isEmpty()) {
            boolean isFirst = true;
            Iterator<DataFilterClause> clauseIterator = this.filterClauses.keySet().iterator();
            builder.append("(", new Object[0]);
            while (clauseIterator.hasNext()) {
                DataFilterClause clause = clauseIterator.next();
                if (!isFirst) {
                    builder.append(this.filterClauses.get(clause).toString(), new Object[0]);
                    builder.append(" ", new Object[0]);
                } else {
                    isFirst = false;
                }
                builder.append(clause.getWhereClause());
                if (!clauseIterator.hasNext()) continue;
                builder.append(" ", new Object[0]);
            }
            builder.append(")", new Object[0]);
        }
        return builder;
    }

    public static class Builder<T extends DataFilterClause>
    implements DataFilterClause {
        private final Context context;
        private final T originator;
        private final DataFilterClause.DataFilterConjunction conjunction;
        private final DataFilterCriteria criteria;

        protected Builder(Context context, T originator, DataFilterClause.DataFilterConjunction conjunction) {
            this.context = context;
            this.originator = originator;
            this.conjunction = conjunction;
            this.criteria = new DataFilterCriteria(context);
        }

        public DataFilterCriterion.Builder<Builder<T>> and() {
            return new DataFilterCriterion.Builder<Builder<T>>(this.context, this, DataFilterClause.DataFilterConjunction.AND);
        }

        public DataFilterCriterion.Builder<Builder<T>> or() {
            return new DataFilterCriterion.Builder<Builder<T>>(this.context, this, DataFilterClause.DataFilterConjunction.OR);
        }

        public Builder<Builder<T>> obAnd() {
            return new Builder<Builder<T>>(this.context, this, DataFilterClause.DataFilterConjunction.AND);
        }

        public Builder<Builder<T>> obOr() {
            return new Builder<Builder<T>>(this.context, this, DataFilterClause.DataFilterConjunction.OR);
        }

        public T closeBracket() {
            this.originator.addClause(this.criteria, this.conjunction);
            return this.originator;
        }

        @Override
        public QueryBuilder getWhereClause() {
            throw new UnsupportedOperationException("Get where clause cannot be called on a builder");
        }

        @Override
        public void addClause(DataFilterClause clause, DataFilterClause.DataFilterConjunction conjunction) {
            this.criteria.addClause(clause, conjunction);
        }
    }
}

