/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.commons.io;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import za.co.absa.commons.io.TempDirectory$;

@ScalaSignature(bytes="\u0006\u0001y4Aa\u0005\u000b\u0001?!Aa\u0005\u0001B\u0001B\u0003%q\u0005\u0003\u00053\u0001\t\u0005\t\u0015!\u0003(\u0011!\u0019\u0004A!A!\u0002\u0013!\u0004\"B\u001c\u0001\t\u0013A\u0004b\u0002 \u0001\u0005\u0004%\ta\u0010\u0005\u0007\u0015\u0002\u0001\u000b\u0011\u0002!\t\u0011-\u0003\u0001R1A\u0005\n1CQa\u0015\u0001\u0005\u0002QCQA\u0016\u0001\u0005\u0002]CQa\u0017\u0001\u0005\u0002qCQa\u0019\u0001\u0005\u0002\u0011<Q!\u001a\u000b\t\u0002\u00194Qa\u0005\u000b\t\u0002\u001dDQaN\u0007\u0005\u0002!DQ![\u0007\u0005\u0002)DqA\\\u0007\u0012\u0002\u0013\u0005q\u000eC\u0004{\u001bE\u0005I\u0011A8\t\u000fml\u0011\u0013!C\u0001y\niA+Z7q\t&\u0014Xm\u0019;pefT!!\u0006\f\u0002\u0005%|'BA\f\u0019\u0003\u001d\u0019w.\\7p]NT!!\u0007\u000e\u0002\t\u0005\u00147/\u0019\u0006\u00037q\t!aY8\u000b\u0003u\t!A_1\u0004\u0001M\u0011\u0001\u0001\t\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0007\u0003:L(+\u001a4\u0002\rA\u0014XMZ5y!\tAsF\u0004\u0002*[A\u0011!FI\u0007\u0002W)\u0011AFH\u0001\u0007yI|w\u000e\u001e \n\u00059\u0012\u0013A\u0002)sK\u0012,g-\u0003\u00021c\t11\u000b\u001e:j]\u001eT!A\f\u0012\u0002\rM,hMZ5y\u0003!\u0001\u0018\r\u001e5P]2L\bCA\u00116\u0013\t1$EA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\u0011I4\bP\u001f\u0011\u0005i\u0002Q\"\u0001\u000b\t\u000b\u0019\"\u0001\u0019A\u0014\t\u000bI\"\u0001\u0019A\u0014\t\u000bM\"\u0001\u0019\u0001\u001b\u0002\tA\fG\u000f[\u000b\u0002\u0001B\u0011\u0011\tS\u0007\u0002\u0005*\u00111\tR\u0001\u0005M&dWM\u0003\u0002F\r\u0006\u0019a.[8\u000b\u0003\u001d\u000bAA[1wC&\u0011\u0011J\u0011\u0002\u0005!\u0006$\b.A\u0003qCRD\u0007%\u0001\u0003i_>\\W#A'\u0011\u00059\u000bV\"A(\u000b\u0005A3\u0015\u0001\u00027b]\u001eL!AU(\u0003\rQC'/Z1e\u00031!W\r\\3uK>sW\t_5u)\u0005)V\"\u0001\u0001\u0002\r\u0011,G.\u001a;f)\u0005A\u0006CA\u0011Z\u0013\tQ&E\u0001\u0003V]&$\u0018!\u0002;p+JKU#A/\u0011\u0005y\u000bW\"A0\u000b\u0005\u00014\u0015a\u00018fi&\u0011!m\u0018\u0002\u0004+JK\u0015\u0001C1t'R\u0014\u0018N\\4\u0016\u0003\u001d\nQ\u0002V3na\u0012K'/Z2u_JL\bC\u0001\u001e\u000e'\ti\u0001\u0005F\u0001g\u0003\u0015\t\u0007\u000f\u001d7z)\u0011I4\u000e\\7\t\u000f\u0019z\u0001\u0013!a\u0001O!9!g\u0004I\u0001\u0002\u00049\u0003bB\u001a\u0010!\u0003\u0005\r\u0001N\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\t\u0001O\u000b\u0002(c.\n!\u000f\u0005\u0002tq6\tAO\u0003\u0002vm\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003o\n\n!\"\u00198o_R\fG/[8o\u0013\tIHOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fq\"\u00199qYf$C-\u001a4bk2$HEM\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\tQP\u000b\u00025c\u0002")
public class TempDirectory {
    private Thread hook;
    private final Path path;
    private volatile boolean bitmap$0;

    public static boolean apply$default$3() {
        return TempDirectory$.MODULE$.apply$default$3();
    }

    public static String apply$default$2() {
        return TempDirectory$.MODULE$.apply$default$2();
    }

    public static String apply$default$1() {
        return TempDirectory$.MODULE$.apply$default$1();
    }

    public static TempDirectory apply(String string, String string2, boolean bl) {
        return TempDirectory$.MODULE$.apply(string, string2, bl);
    }

    public Path path() {
        return this.path;
    }

    private Thread hook$lzycompute() {
        TempDirectory tempDirectory = this;
        synchronized (tempDirectory) {
            if (!this.bitmap$0) {
                this.hook = new Thread(this){
                    private final /* synthetic */ TempDirectory $outer;

                    public void run() {
                        this.$outer.delete();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
                this.bitmap$0 = true;
            }
        }
        return this.hook;
    }

    private Thread hook() {
        return !this.bitmap$0 ? this.hook$lzycompute() : this.hook;
    }

    public synchronized TempDirectory deleteOnExit() {
        Runtime.getRuntime().removeShutdownHook(this.hook());
        Runtime.getRuntime().addShutdownHook(this.hook());
        return this;
    }

    public void delete() {
        TempDirectory tempDirectory = this;
        synchronized (tempDirectory) {
            Object object = Files.exists(this.path(), new LinkOption[0]) ? Files.walkFileTree(this.path(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(null){

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    FileUtils.deleteQuietly((File)file.toFile());
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    FileUtils.deleteQuietly((File)dir.toFile());
                    return FileVisitResult.CONTINUE;
                }
            }) : BoxedUnit.UNIT;
        }
    }

    public URI toURI() {
        return this.path().toFile().toURI();
    }

    public String asString() {
        return ((Object)this.path()).toString().replace("\\", "/");
    }

    public TempDirectory(String prefix, String suffix, boolean pathOnly) {
        this.path = Files.createTempFile(prefix, suffix, new FileAttribute[0]);
        Files.deleteIfExists(this.path());
        Object object = !pathOnly ? Files.createDirectory(this.path(), new FileAttribute[0]) : BoxedUnit.UNIT;
    }
}

