/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.abris.avro.read.confluent;

import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.security.InvalidParameterException;
import org.apache.avro.Schema;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import za.co.absa.abris.avro.parsing.utils.AvroSchemaUtils$;
import za.co.absa.abris.avro.registry.IdCoordinate;
import za.co.absa.abris.avro.registry.LatestVersion;
import za.co.absa.abris.avro.registry.NumVersion;
import za.co.absa.abris.avro.registry.SchemaCoordinate;
import za.co.absa.abris.avro.registry.SchemaSubject;
import za.co.absa.abris.avro.registry.SchemaVersion;
import za.co.absa.abris.avro.registry.SubjectCoordinate;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001\u0002\b\u0010\u0001yA\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\u0006\u007f\u0001!\t\u0001\u0011\u0005\u0006\t\u0002!\t!\u0012\u0005\u0006'\u0002!\t\u0001\u0016\u0005\u00065\u0002!\ta\u0017\u0005\u0006M\u0002!\ta\u001a\u0005\u0006[\u0002!\tA\u001c\u0005\u0006[\u0002!\t! \u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0011\u001d\ty\u0001\u0001C\u0005\u0003#Aq!!\u0007\u0001\t\u0003\tY\u0002C\u0004\u00022\u0001!\t!a\r\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B\ti1k\u00195f[\u0006l\u0015M\\1hKJT!\u0001E\t\u0002\u0013\r|gN\u001a7vK:$(B\u0001\n\u0014\u0003\u0011\u0011X-\u00193\u000b\u0005Q)\u0012\u0001B1we>T!AF\f\u0002\u000b\u0005\u0014'/[:\u000b\u0005aI\u0012\u0001B1cg\u0006T!AG\u000e\u0002\u0005\r|'\"\u0001\u000f\u0002\u0005i\f7\u0001A\n\u0004\u0001})\u0003C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#AB!osJ+g\r\u0005\u0002'_5\tqE\u0003\u0002)S\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002+W\u0005)1\u000f]1sW*\u0011A&L\u0001\u0007CB\f7\r[3\u000b\u00039\n1a\u001c:h\u0013\t\u0001tEA\u0004M_\u001e<\u0017N\\4\u0002)M\u001c\u0007.Z7b%\u0016<\u0017n\u001d;ss\u000ec\u0017.\u001a8u!\t\u0019T(D\u00015\u0015\t)d'\u0001\u0004dY&,g\u000e\u001e\u0006\u0003oa\nab]2iK6\f'/Z4jgR\u0014\u0018P\u0003\u0002:u\u0005)1.\u00194lC*\u0011\u0001c\u000f\u0006\u0002y\u0005\u0011\u0011n\\\u0005\u0003}Q\u0012AcU2iK6\f'+Z4jgR\u0014\u0018p\u00117jK:$\u0018A\u0002\u001fj]&$h\b\u0006\u0002B\u0007B\u0011!\tA\u0007\u0002\u001f!)\u0011G\u0001a\u0001e\u0005Iq-\u001a;TG\",W.\u0019\u000b\u0003\r.\u0003\"aR%\u000e\u0003!S!\u0001F\u0016\n\u0005)C%AB*dQ\u0016l\u0017\rC\u0003M\u0007\u0001\u0007Q*\u0001\u0006d_>\u0014H-\u001b8bi\u0016\u0004\"AT)\u000e\u0003=S!\u0001U\n\u0002\u0011I,w-[:uefL!AU(\u0003!M\u001b\u0007.Z7b\u0007>|'\u000fZ5oCR,\u0017!D4fiN\u001b\u0007.Z7b\u0005fLE\r\u0006\u0002G+\")a\u000b\u0002a\u0001/\u0006A1o\u00195f[\u0006LE\r\u0005\u0002!1&\u0011\u0011,\t\u0002\u0004\u0013:$\u0018\u0001H4fiN\u001b\u0007.Z7b\u0005f\u001cVO\u00196fGR\fe\u000e\u001a,feNLwN\u001c\u000b\u0004\rr\u000b\u0007\"B/\u0006\u0001\u0004q\u0016aB:vE*,7\r\u001e\t\u0003\u001d~K!\u0001Y(\u0003\u001bM\u001b\u0007.Z7b'V\u0014'.Z2u\u0011\u0015\u0011W\u00011\u0001d\u0003\u001d1XM]:j_:\u0004\"A\u00143\n\u0005\u0015|%!D*dQ\u0016l\u0017MV3sg&|g.\u0001\u0013hKR\u001c6\r[3nC6+G/\u00193bi\u0006\u0014\u0015pU;cU\u0016\u001cG/\u00118e-\u0016\u00148/[8o)\rA7\u000e\u001c\t\u0003g%L!A\u001b\u001b\u0003\u001dM\u001b\u0007.Z7b\u001b\u0016$\u0018\rZ1uC\")QL\u0002a\u0001=\")!M\u0002a\u0001G\u0006A!/Z4jgR,'\u000fF\u0002X_BDQ!X\u0004A\u0002yCQ!]\u0004A\u0002I\fAb]2iK6\f7\u000b\u001e:j]\u001e\u0004\"a\u001d>\u000f\u0005QD\bCA;\"\u001b\u00051(BA<\u001e\u0003\u0019a$o\\8u}%\u0011\u00110I\u0001\u0007!J,G-\u001a4\n\u0005md(AB*ue&twM\u0003\u0002zCQ\u0019qK`@\t\u000buC\u0001\u0019\u00010\t\r\u0005\u0005\u0001\u00021\u0001G\u0003\u0019\u00198\r[3nC\u00061Q\r_5tiN$B!a\u0002\u0002\u000eA\u0019\u0001%!\u0003\n\u0007\u0005-\u0011EA\u0004C_>dW-\u00198\t\u000buK\u0001\u0019\u00010\u0002\u0019%\u001c8i\\7qCRL'\r\\3\u0015\r\u0005\u001d\u00111CA\f\u0011\u0019\t)B\u0003a\u0001\r\u0006Ia.Z<TG\",W.\u0019\u0005\u0006;*\u0001\rAX\u0001\u001aO\u0016$\u0018\t\u001c7TG\",W.Y:XSRDW*\u001a;bI\u0006$\u0018\r\u0006\u0003\u0002\u001e\u0005=\u0002#BA\u0010\u0003SAg\u0002BA\u0011\u0003Kq1!^A\u0012\u0013\u0005\u0011\u0013bAA\u0014C\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0016\u0003[\u0011A\u0001T5ti*\u0019\u0011qE\u0011\t\u000bu[\u0001\u0019\u00010\u0002)\u0019Lg\u000eZ#rk&4\u0018\r\\3oiN\u001b\u0007.Z7b)\u0019\t)$a\u000f\u0002>A!\u0001%a\u000eX\u0013\r\tI$\t\u0002\u0007\u001fB$\u0018n\u001c8\t\r\u0005\u0005A\u00021\u0001G\u0011\u0015iF\u00021\u0001_\u0003}9W\r^%g\u000bbL7\u000f^:Pe\u0016c7/\u001a*fO&\u001cH/\u001a:TG\",W.\u0019\u000b\u0006/\u0006\r\u0013Q\t\u0005\u0007\u0003\u0003i\u0001\u0019\u0001$\t\u000buk\u0001\u0019\u00010")
public class SchemaManager
implements Logging {
    private final SchemaRegistryClient schemaRegistryClient;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Schema getSchema(SchemaCoordinate coordinate) {
        Schema schema;
        SchemaCoordinate schemaCoordinate = coordinate;
        if (schemaCoordinate instanceof IdCoordinate) {
            IdCoordinate idCoordinate = (IdCoordinate)schemaCoordinate;
            int id = idCoordinate.schemaId();
            schema = this.getSchemaById(id);
        } else if (schemaCoordinate instanceof SubjectCoordinate) {
            SubjectCoordinate subjectCoordinate = (SubjectCoordinate)schemaCoordinate;
            SchemaSubject subject = subjectCoordinate.subject();
            SchemaVersion version = subjectCoordinate.version();
            schema = this.getSchemaBySubjectAndVersion(subject, version);
        } else {
            throw new MatchError((Object)schemaCoordinate);
        }
        return schema;
    }

    public Schema getSchemaById(int schemaId) {
        return this.schemaRegistryClient.getById(schemaId);
    }

    public Schema getSchemaBySubjectAndVersion(SchemaSubject subject, SchemaVersion version) {
        SchemaMetadata metadata = this.getSchemaMetadataBySubjectAndVersion(subject, version);
        return AvroSchemaUtils$.MODULE$.parse(metadata.getSchema());
    }

    public SchemaMetadata getSchemaMetadataBySubjectAndVersion(SchemaSubject subject, SchemaVersion version) {
        SchemaMetadata schemaMetadata;
        SchemaVersion schemaVersion = version;
        if (schemaVersion instanceof NumVersion) {
            NumVersion numVersion = (NumVersion)schemaVersion;
            int versionInt = numVersion.num();
            schemaMetadata = this.schemaRegistryClient.getSchemaMetadata(subject.asString(), versionInt);
        } else if (schemaVersion instanceof LatestVersion) {
            schemaMetadata = this.schemaRegistryClient.getLatestSchemaMetadata(subject.asString());
        } else {
            throw new MatchError((Object)schemaVersion);
        }
        return schemaMetadata;
    }

    public int register(SchemaSubject subject, String schemaString) {
        return this.register(subject, AvroSchemaUtils$.MODULE$.parse(schemaString));
    }

    public int register(SchemaSubject subject, Schema schema) {
        if (this.exists(subject) && !this.isCompatible(schema, subject)) {
            throw new InvalidParameterException(new StringBuilder(153).append("Schema could not be registered for subject '").append(subject).append("'. ").append("Make sure that the Schema Registry is available, the parameters are correct and the schemas are compatible").toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("AvroSchemaUtils.registerIfCompatibleSchema: Registering schema for subject: ").append(subject).toString());
        return this.schemaRegistryClient.register(subject.asString(), schema);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean exists(SchemaSubject subject) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.schemaRegistryClient.getLatestSchemaMetadata(subject.asString()));
        if (try_ instanceof Success) {
            return true;
        }
        if (try_ instanceof Failure) {
            RestClientException restClientException;
            bl = true;
            failure = (Failure)try_;
            Throwable e = failure.exception();
            if (e instanceof RestClientException && (restClientException = (RestClientException)e).getStatus() == 404) {
                return false;
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        Throwable e = failure.exception();
        throw e;
    }

    private boolean isCompatible(Schema newSchema, SchemaSubject subject) {
        return this.schemaRegistryClient.testCompatibility(subject.asString(), newSchema);
    }

    /*
     * Unable to fully structure code
     */
    public List<SchemaMetadata> getAllSchemasWithMetadata(SchemaSubject subject) {
        block4: {
            block3: {
                var4_2 = false;
                var5_3 = null;
                var6_4 = Try$.MODULE$.apply((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getAllSchemasWithMetadata$1(za.co.absa.abris.avro.read.confluent.SchemaManager za.co.absa.abris.avro.registry.SchemaSubject ), ()Ljava/util/List;)((SchemaManager)this, (SchemaSubject)subject));
                if (!(var6_4 instanceof Success)) break block3;
                var7_5 = (Success)var6_4;
                l = (java.util.List)var7_5.value();
                var2_7 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(l).asScala()).toList();
                break block4;
            }
            if (!(var6_4 instanceof Failure)) ** GOTO lbl-1000
            var4_2 = true;
            var5_3 = (Failure)var6_4;
            e = var5_3.exception();
            if (e instanceof RestClientException && (var10_9 = (RestClientException)e).getStatus() == 404) {
                var2_7 = List$.MODULE$.empty();
            } else lbl-1000:
            // 2 sources

            {
                if (var4_2) {
                    e = var5_3.exception();
                    throw e;
                }
                throw new MatchError((Object)var6_4);
            }
        }
        versions = var2_7;
        return (List)versions.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getAllSchemasWithMetadata$2(za.co.absa.abris.avro.read.confluent.SchemaManager za.co.absa.abris.avro.registry.SchemaSubject java.lang.Integer ), (Ljava/lang/Integer;)Lio/confluent/kafka/schemaregistry/client/SchemaMetadata;)((SchemaManager)this, (SchemaSubject)subject), List$.MODULE$.canBuildFrom());
    }

    public Option<Object> findEquivalentSchema(Schema schema, SchemaSubject subject) {
        Option maybeIdenticalSchemaMetadata = this.getAllSchemasWithMetadata(subject).find((Function1 & Serializable & scala.Serializable)sm -> BoxesRunTime.boxToBoolean((boolean)SchemaManager.$anonfun$findEquivalentSchema$1(schema, sm)));
        return maybeIdenticalSchemaMetadata.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.getId()));
    }

    public int getIfExistsOrElseRegisterSchema(Schema schema, SchemaSubject subject) {
        Option<Object> maybeSchemaId = this.findEquivalentSchema(schema, subject);
        return BoxesRunTime.unboxToInt((Object)maybeSchemaId.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.register(subject, schema)));
    }

    public static final /* synthetic */ java.util.List $anonfun$getAllSchemasWithMetadata$1(SchemaManager $this, SchemaSubject subject$3) {
        return $this.schemaRegistryClient.getAllVersions(subject$3.asString());
    }

    public static final /* synthetic */ SchemaMetadata $anonfun$getAllSchemasWithMetadata$2(SchemaManager $this, SchemaSubject subject$3, Integer x$1) {
        return $this.schemaRegistryClient.getSchemaMetadata(subject$3.asString(), Predef$.MODULE$.Integer2int(x$1));
    }

    public static final /* synthetic */ boolean $anonfun$findEquivalentSchema$1(Schema schema$1, SchemaMetadata sm) {
        return AvroSchemaUtils$.MODULE$.parse(sm.getSchema()).equals((Object)schema$1);
    }

    public SchemaManager(SchemaRegistryClient schemaRegistryClient) {
        this.schemaRegistryClient = schemaRegistryClient;
        Logging.$init$((Logging)this);
    }
}

