/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.abris.avro.parsing.utils;

import java.io.InputStream;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.sql.types.StructField;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;

public final class AvroSchemaUtils$ {
    public static AvroSchemaUtils$ MODULE$;

    static {
        new AvroSchemaUtils$();
    }

    public Schema parse(String schema) {
        return new Schema.Parser().parse(schema);
    }

    public Schema load(String path) {
        return this.parse(this.loadPlain(path));
    }

    public String loadPlain(String path) {
        String string;
        if (path == null) {
            throw new IllegalArgumentException("Null path informed. Please make sure you provide a valid path to an existing Avro schema located in some file system.");
        }
        FileSystem hdfs = FileSystem.get((Configuration)new Configuration());
        try (FSDataInputStream stream = hdfs.open(new Path(path));){
            string = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(IOUtils.readLines((InputStream)stream)).asScala()).mkString("\n");
        }
        return string;
    }

    public Schema toAvroSchema(Dataset<Row> dataFrame, String columnName, String recordName, String nameSpace) {
        int fieldIndex = dataFrame.schema().fieldIndex(columnName);
        StructField field = dataFrame.schema().fields()[fieldIndex];
        return SchemaConverters$.MODULE$.toAvroType(field.dataType(), field.nullable(), recordName, nameSpace);
    }

    public String toAvroSchema$default$3() {
        return "topLevelRecord";
    }

    public String toAvroSchema$default$4() {
        return "";
    }

    public Schema wrapSchema(Schema schema, String name, String namespace) {
        return (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)name).namespace(namespace)).fields().name(schema.getName()).type(schema).noDefault().endRecord();
    }

    private AvroSchemaUtils$() {
        MODULE$ = this;
    }
}

