/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.abris.examples.data.generation;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import scala.Function1;
import scala.Serializable;
import scala.collection.immutable.Map;
import za.co.absa.abris.avro.parsing.utils.AvroSchemaUtils$;
import za.co.absa.abris.avro.write.ScalaCustomDatumWriter;

public final class AvroDataUtils$ {
    public static AvroDataUtils$ MODULE$;

    static {
        new AvroDataUtils$();
    }

    public GenericRecord mapToGenericRecordDirectly(Map<String, Object> data, String schema) {
        GenericRecordBuilder avroRecordBuilder = this.getRecordBuilder(schema);
        data.iterator().foreach((Function1 & java.io.Serializable & Serializable)entry -> avroRecordBuilder.set((String)entry._1(), entry._2()));
        return avroRecordBuilder.build();
    }

    public GenericRecord mapToGenericRecord(Map<String, Object> data, String schema) {
        return this.passRecordThroughAvroApi(this.mapToGenericRecordDirectly(data, schema));
    }

    private GenericRecordBuilder getRecordBuilder(String schema) {
        Schema parsedSchema = AvroSchemaUtils$.MODULE$.parse(schema);
        return new GenericRecordBuilder(parsedSchema);
    }

    private GenericRecord passRecordThroughAvroApi(GenericRecord avroRecord) {
        byte[] recordBytes = this.recordToBytes(avroRecord);
        return this.bytesToRecord(recordBytes, avroRecord.getSchema());
    }

    public byte[] recordToBytes(GenericRecord record) {
        byte[] byArray;
        ScalaCustomDatumWriter writer = new ScalaCustomDatumWriter();
        writer.setSchema(record.getSchema());
        try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
            BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)outStream, null);
            writer.write(record, (Encoder)encoder);
            encoder.flush();
            byArray = outStream.toByteArray();
        }
        return byArray;
    }

    public GenericRecord bytesToRecord(byte[] avroBytes, Schema schema) {
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(avroBytes, 0, avroBytes.length, null);
        GenericDatumReader reader = new GenericDatumReader(schema);
        return (GenericRecord)reader.read((Object)reader, (Decoder)decoder);
    }

    private AvroDataUtils$() {
        MODULE$ = this;
    }
}

