/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.abris.avro.serde;

import java.io.Serializable;
import java.security.InvalidParameterException;
import org.apache.avro.Schema;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import za.co.absa.abris.avro.format.ScalaAvroRecord;
import za.co.absa.abris.avro.format.SparkAvroConversions$;
import za.co.absa.abris.avro.parsing.utils.AvroSchemaUtils$;
import za.co.absa.abris.avro.read.ScalaDatumReader;
import za.co.absa.abris.avro.read.confluent.ScalaConfluentKafkaAvroDeserializer;
import za.co.absa.abris.avro.serde.AvroReaderFactory$;
import za.co.absa.abris.avro.serde.AvroToRowConverter;
import za.co.absa.abris.avro.serde.AvroToRowEncoderFactory$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc!\u0002\t\u0012\u0001Mi\u0002\"\u0002\u0013\u0001\t\u00031\u0003\"B\u0015\u0001\t#Q\u0003\"\u0002*\u0001\t#\u0019\u0006\"\u0002*\u0001\t#Q\u0006\"\u0002*\u0001\t#\u0019\u0007\"B\u0015\u0001\t#\t\b\"B<\u0001\t#A\b\"B?\u0001\t#q\bBB<\u0001\t#\tI\u0001\u0003\u0004x\u0001\u0011E\u0011q\u0002\u0005\u0007o\u0002!\t\"!\u0006\t\ru\u0004A\u0011CA\u000f\u0011\u00199\b\u0001\"\u0005\u0002*!9\u0011q\u0006\u0001\u0005\u0012\u0005E\u0002BB<\u0001\t#\tYDA\u0006BmJ|G)Z2pI\u0016\u0014(B\u0001\n\u0014\u0003\u0015\u0019XM\u001d3f\u0015\t!R#\u0001\u0003bmJ|'B\u0001\f\u0018\u0003\u0015\t'M]5t\u0015\tA\u0012$\u0001\u0003bEN\f'B\u0001\u000e\u001c\u0003\t\u0019wNC\u0001\u001d\u0003\tQ\u0018m\u0005\u0002\u0001=A\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002OA\u0011\u0001\u0006A\u0007\u0002#\u00051bM]8n\u0007>tg\r\\;f]R\feO]8U_J{w\u000f\u0006\u0003,uqb\u0005c\u0001\u00176o5\tQF\u0003\u0002/_\u0005\u00191/\u001d7\u000b\u0005A\n\u0014!B:qCJ\\'B\u0001\u001a4\u0003\u0019\t\u0007/Y2iK*\tA'A\u0002pe\u001eL!AN\u0017\u0003\u000f\u0011\u000bG/Y:fiB\u0011A\u0006O\u0005\u0003s5\u00121AU8x\u0011\u0015Y$\u00011\u0001,\u0003%!\u0017\r^1ge\u0006lW\rC\u0003>\u0005\u0001\u0007a(\u0001\u0006tG\",W.\u0019)bi\"\u00042aH B\u0013\t\u0001\u0005E\u0001\u0004PaRLwN\u001c\t\u0003\u0005&s!aQ$\u0011\u0005\u0011\u0003S\"A#\u000b\u0005\u0019+\u0013A\u0002\u001fs_>$h(\u0003\u0002IA\u00051\u0001K]3eK\u001aL!AS&\u0003\rM#(/\u001b8h\u0015\tA\u0005\u0005C\u0003N\u0005\u0001\u0007a*\u0001\ntG\",W.\u0019*fO&\u001cHO]=D_:4\u0007cA\u0010@\u001fB!!\tU!B\u0013\t\t6JA\u0002NCB\faD\u001a:p[\u000e{gN\u001a7vK:$\u0018I\u001e:p)>\u0014vn^,ji\"\\U-_:\u0015\u000b-\"VkV-\t\u000bm\u001a\u0001\u0019A\u0016\t\u000bY\u001b\u0001\u0019A!\u0002\u0015-,\u0017pQ8m\u001d\u0006lW\rC\u0003Y\u0007\u0001\u0007\u0011)\u0001\u0007wC2,XmQ8m\u001d\u0006lW\rC\u0003N\u0007\u0001\u0007q\nF\u0004,7rkv\f\u00192\t\u000bm\"\u0001\u0019A\u0016\t\u000bY#\u0001\u0019A!\t\u000by#\u0001\u0019A!\u0002\u001b-,\u0017pU2iK6\f\u0007+\u0019;i\u0011\u0015AF\u00011\u0001B\u0011\u0015\tG\u00011\u0001B\u0003=1\u0018\r\\;f'\u000eDW-\\1QCRD\u0007\"B'\u0005\u0001\u0004yEcB\u0016eK\u001alg\u000e\u001d\u0005\u0006w\u0015\u0001\ra\u000b\u0005\u0006-\u0016\u0001\r!\u0011\u0005\u0006O\u0016\u0001\r\u0001[\u0001\rW\u0016L8i\u001c7TG\",W.\u0019\t\u0003S.l\u0011A\u001b\u0006\u0003)EJ!\u0001\u001c6\u0003\rM\u001b\u0007.Z7b\u0011\u0015AV\u00011\u0001B\u0011\u0015yW\u00011\u0001i\u000391\u0018\r\\;f\u0007>d7k\u00195f[\u0006DQ!T\u0003A\u0002=#Ra\u000b:tiVDQa\u000f\u0004A\u0002-BQ!\u0010\u0004A\u0002yBQ!\u0014\u0004A\u00029CQA\u001e\u0004A\u0002\u0005\u000b\u0011\u0003Z3ti&t\u0017\r^5p]\u000e{G.^7o\u000351'o\\7BmJ|Gk\u001c*poR!1&\u001f>}\u0011\u0015Yt\u00011\u0001,\u0011\u0015Yx\u00011\u0001i\u0003\u0019\u00198\r[3nC\")ao\u0002a\u0001\u0003\u0006ybM]8n\u0003Z\u0014x\u000eV8S_^\u0014V\r^1j]&twm\u0015;sk\u000e$XO]3\u0015\u0015-z\u0018\u0011AA\u0002\u0003\u000b\t9\u0001C\u0003<\u0011\u0001\u00071\u0006C\u0003W\u0011\u0001\u0007\u0011\tC\u0003h\u0011\u0001\u0007\u0001\u000eC\u0003Y\u0011\u0001\u0007\u0011\tC\u0003p\u0011\u0001\u0007\u0001\u000eF\u0003,\u0003\u0017\ti\u0001C\u0003<\u0013\u0001\u00071\u0006C\u0003|\u0013\u0001\u0007\u0001\u000eF\u0003,\u0003#\t\u0019\u0002C\u0003<\u0015\u0001\u00071\u0006C\u0003>\u0015\u0001\u0007\u0011\tF\u0004,\u0003/\tI\"a\u0007\t\u000bmZ\u0001\u0019A\u0016\t\u000buZ\u0001\u0019A!\t\u000bY\\\u0001\u0019A!\u0015\u0017-\ny\"!\t\u0002$\u0005\u0015\u0012q\u0005\u0005\u0006w1\u0001\ra\u000b\u0005\u0006-2\u0001\r!\u0011\u0005\u0006=2\u0001\r!\u0011\u0005\u000612\u0001\r!\u0011\u0005\u0006C2\u0001\r!\u0011\u000b\u0006W\u0005-\u0012Q\u0006\u0005\u0006w5\u0001\ra\u000b\u0005\u0006\u001b6\u0001\raT\u0001(MJ|W.\u0011<s_R{'k\\<XSRD7*Z=t%\u0016$\u0018-\u001b8j]\u001e\u001cFO];diV\u0014X\rF\u0005,\u0003g\t)$a\u000e\u0002:!)1H\u0004a\u0001W!)aK\u0004a\u0001\u0003\")\u0001L\u0004a\u0001\u0003\")QJ\u0004a\u0001\u001fR91&!\u0010\u0002@\u0005\u0005\u0003\"B\u001e\u0010\u0001\u0004Y\u0003\"B'\u0010\u0001\u0004y\u0005\"\u0002<\u0010\u0001\u0004\t\u0005")
public class AvroDecoder {
    public Dataset<Row> fromConfluentAvroToRow(Dataset<Row> dataframe, Option<String> schemaPath, Option<Map<String, String>> schemaRegistryConf) {
        if (schemaPath.isEmpty() && schemaRegistryConf.isEmpty()) {
            throw new InvalidParameterException("Neither path to schema in file system nor Schema Registry configurations was provided.");
        }
        ExpressionEncoder<Row> rowEncoder = schemaRegistryConf.isDefined() ? AvroToRowEncoderFactory$.MODULE$.createRowEncoder((Map<String, String>)((Map)schemaRegistryConf.get())) : AvroToRowEncoderFactory$.MODULE$.createRowEncoder((String)schemaPath.get());
        return dataframe.as(Encoders$.MODULE$.BINARY()).mapPartitions((Function1 & Serializable & scala.Serializable)partition -> {
            ScalaConfluentKafkaAvroDeserializer avroReader = AvroReaderFactory$.MODULE$.createConfiguredConfluentAvroReader(schemaPath, schemaRegistryConf);
            AvroToRowConverter avroToRowConverter = new AvroToRowConverter((Option<ScalaDatumReader<ScalaAvroRecord>>)None$.MODULE$);
            return partition.map((Function1 & Serializable & scala.Serializable)avroRecord -> avroToRowConverter.convert(avroReader.deserialize((byte[])avroRecord), ClassTag$.MODULE$.Nothing()));
        }, rowEncoder);
    }

    public Dataset<Row> fromConfluentAvroToRowWithKeys(Dataset<Row> dataframe, String keyColName, String valueColName, Map<String, String> schemaRegistryConf) {
        if (schemaRegistryConf.isEmpty()) {
            throw new InvalidParameterException("Schema Registry configurations is required.");
        }
        Schema valueSchema = AvroSchemaUtils$.MODULE$.loadForValue(schemaRegistryConf);
        Schema keySchema = AvroSchemaUtils$.MODULE$.loadForKey(schemaRegistryConf);
        return this.fromConfluentAvroToRowWithKeys(dataframe, keyColName, keySchema, valueColName, valueSchema, schemaRegistryConf);
    }

    public Dataset<Row> fromConfluentAvroToRowWithKeys(Dataset<Row> dataframe, String keyColName, String keySchemaPath, String valueColName, String valueSchemaPath, Map<String, String> schemaRegistryConf) {
        Schema keySchema = AvroSchemaUtils$.MODULE$.load(keySchemaPath);
        Schema valueSchema = AvroSchemaUtils$.MODULE$.load(valueSchemaPath);
        return this.fromConfluentAvroToRowWithKeys(dataframe, keyColName, keySchema, valueColName, valueSchema, schemaRegistryConf);
    }

    public Dataset<Row> fromConfluentAvroToRowWithKeys(Dataset<Row> dataframe, String keyColName, Schema keyColSchema, String valueColName, Schema valueColSchema, Map<String, String> schemaRegistryConf) {
        if (schemaRegistryConf.isEmpty()) {
            throw new InvalidParameterException("Schema Registry configurations is required.");
        }
        StructType originalSchema = dataframe.schema();
        int keyColIndex = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])originalSchema.fields())).toList().indexWhere((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AvroDecoder.$anonfun$fromConfluentAvroToRowWithKeys$1(keyColName, x$1)));
        int valueColIndex = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])originalSchema.fields())).toList().indexWhere((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AvroDecoder.$anonfun$fromConfluentAvroToRowWithKeys$2(valueColName, x$2)));
        originalSchema.fields()[keyColIndex] = new StructField(keyColName, (DataType)SparkAvroConversions$.MODULE$.toSqlType(keyColSchema), false, StructField$.MODULE$.$lessinit$greater$default$4());
        originalSchema.fields()[valueColIndex] = new StructField(valueColName, (DataType)SparkAvroConversions$.MODULE$.toSqlType(valueColSchema), false, StructField$.MODULE$.$lessinit$greater$default$4());
        ExpressionEncoder<Row> rowEncoder = AvroToRowEncoderFactory$.MODULE$.createRowEncoder(originalSchema);
        String keyColPlainSchema = keyColSchema.toString();
        String valueColPlainSchema = valueColSchema.toString();
        return dataframe.mapPartitions((Function1 & Serializable & scala.Serializable)partition -> {
            ScalaConfluentKafkaAvroDeserializer keyAvroReader = AvroReaderFactory$.MODULE$.createConfiguredConfluentAvroReader(AvroSchemaUtils$.MODULE$.parse(keyColPlainSchema), schemaRegistryConf);
            ScalaConfluentKafkaAvroDeserializer valueAvroReader = AvroReaderFactory$.MODULE$.createConfiguredConfluentAvroReader(AvroSchemaUtils$.MODULE$.parse(valueColPlainSchema), schemaRegistryConf);
            AvroToRowConverter avroToRowConverter = new AvroToRowConverter((Option<ScalaDatumReader<ScalaAvroRecord>>)None$.MODULE$);
            return partition.map((Function1 & Serializable & scala.Serializable)avroRecord -> {
                Row keySparkType = avroToRowConverter.convert(keyAvroReader.deserialize((byte[])avroRecord.get(keyColIndex)), ClassTag$.MODULE$.Nothing());
                Row valueSparkType = avroToRowConverter.convert(valueAvroReader.deserialize((byte[])avroRecord.get(valueColIndex)), ClassTag$.MODULE$.Nothing());
                Object[] array = new Object[avroRecord.size()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), avroRecord.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    array$1[i] = avroRecord.get(i);
                });
                array[keyColIndex$1] = keySparkType;
                array[valueColIndex$1] = valueSparkType;
                return Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)array));
            });
        }, rowEncoder);
    }

    public Dataset<Row> fromConfluentAvroToRow(Dataset<Row> dataframe, Option<String> schemaPath, Option<Map<String, String>> schemaRegistryConf, String destinationColumn) {
        if (schemaPath.isEmpty() && schemaRegistryConf.isEmpty()) {
            throw new InvalidParameterException("Neither path to schema in file system nor Schema Registry configurations was provided.");
        }
        Schema dataSchema = schemaRegistryConf.isDefined() ? AvroSchemaUtils$.MODULE$.loadForValue((Map<String, String>)((Map)schemaRegistryConf.get())) : AvroSchemaUtils$.MODULE$.load((String)schemaPath.get());
        StructType originalSchema = dataframe.schema();
        int destinationIndex = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])originalSchema.fields())).toList().indexWhere((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AvroDecoder.$anonfun$fromConfluentAvroToRow$3(destinationColumn, x$3)));
        originalSchema.fields()[destinationIndex] = new StructField(destinationColumn, (DataType)SparkAvroConversions$.MODULE$.toSqlType(dataSchema), false, StructField$.MODULE$.$lessinit$greater$default$4());
        ExpressionEncoder<Row> rowEncoder = AvroToRowEncoderFactory$.MODULE$.createRowEncoder(originalSchema);
        return dataframe.mapPartitions((Function1 & Serializable & scala.Serializable)partition -> {
            ScalaConfluentKafkaAvroDeserializer avroReader = AvroReaderFactory$.MODULE$.createConfiguredConfluentAvroReader(schemaPath, schemaRegistryConf);
            AvroToRowConverter avroToRowConverter = new AvroToRowConverter((Option<ScalaDatumReader<ScalaAvroRecord>>)None$.MODULE$);
            return partition.map((Function1 & Serializable & scala.Serializable)avroRecord -> {
                Row sparkType = avroToRowConverter.convert(avroReader.deserialize((byte[])avroRecord.get(destinationIndex)), ClassTag$.MODULE$.Nothing());
                Object[] array = new Object[avroRecord.size()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), avroRecord.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    array$2[i] = avroRecord.get(i);
                });
                array[destinationIndex$1] = sparkType;
                return Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)array));
            });
        }, rowEncoder);
    }

    public Dataset<Row> fromAvroToRow(Dataset<Row> dataframe, Schema schema, String destinationColumn) {
        StructType originalSchema = dataframe.schema();
        int destinationIndex = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])originalSchema.fields())).toList().indexWhere((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AvroDecoder.$anonfun$fromAvroToRow$1(destinationColumn, x$4)));
        originalSchema.fields()[destinationIndex] = new StructField(destinationColumn, (DataType)SparkAvroConversions$.MODULE$.toSqlType(schema), false, StructField$.MODULE$.$lessinit$greater$default$4());
        ExpressionEncoder<Row> rowEncoder = AvroToRowEncoderFactory$.MODULE$.createRowEncoder(originalSchema);
        String plainSchema = schema.toString();
        return dataframe.mapPartitions((Function1 & Serializable & scala.Serializable)partition -> {
            AvroToRowConverter avroToRowConverter = new AvroToRowConverter((Option<ScalaDatumReader<ScalaAvroRecord>>)new Some(AvroReaderFactory$.MODULE$.createAvroReader(AvroSchemaUtils$.MODULE$.parse(plainSchema))));
            return partition.map((Function1 & Serializable & scala.Serializable)avroRecord -> {
                Row sparkType = avroToRowConverter.convert((byte[])avroRecord.get(destinationIndex), ClassTag$.MODULE$.Nothing());
                Object[] array = new Object[avroRecord.size()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), avroRecord.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    array$3[i] = avroRecord.get(i);
                });
                array[destinationIndex$2] = sparkType;
                return Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)array));
            });
        }, rowEncoder);
    }

    public Dataset<Row> fromAvroToRowRetainingStructure(Dataset<Row> dataframe, String keyColName, Schema keyColSchema, String valueColName, Schema valueColSchema) {
        StructType originalSchema = dataframe.schema();
        int keyColIndex = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])originalSchema.fields())).toList().indexWhere((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AvroDecoder.$anonfun$fromAvroToRowRetainingStructure$1(keyColName, x$5)));
        int valueColIndex = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])originalSchema.fields())).toList().indexWhere((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)AvroDecoder.$anonfun$fromAvroToRowRetainingStructure$2(valueColName, x$6)));
        originalSchema.fields()[keyColIndex] = new StructField(keyColName, (DataType)SparkAvroConversions$.MODULE$.toSqlType(keyColSchema), false, StructField$.MODULE$.$lessinit$greater$default$4());
        originalSchema.fields()[valueColIndex] = new StructField(valueColName, (DataType)SparkAvroConversions$.MODULE$.toSqlType(valueColSchema), false, StructField$.MODULE$.$lessinit$greater$default$4());
        ExpressionEncoder<Row> rowEncoder = AvroToRowEncoderFactory$.MODULE$.createRowEncoder(originalSchema);
        String keyColPlainSchema = keyColSchema.toString();
        String valueColPlainSchema = valueColSchema.toString();
        return dataframe.mapPartitions((Function1 & Serializable & scala.Serializable)partition -> {
            AvroToRowConverter keyColConverter = new AvroToRowConverter((Option<ScalaDatumReader<ScalaAvroRecord>>)new Some(AvroReaderFactory$.MODULE$.createAvroReader(AvroSchemaUtils$.MODULE$.parse(keyColPlainSchema))));
            AvroToRowConverter valueColConverter = new AvroToRowConverter((Option<ScalaDatumReader<ScalaAvroRecord>>)new Some(AvroReaderFactory$.MODULE$.createAvroReader(AvroSchemaUtils$.MODULE$.parse(valueColPlainSchema))));
            return partition.map((Function1 & Serializable & scala.Serializable)avroRecords -> {
                byte[] keyRecord = (byte[])avroRecords.get(avroRecords.fieldIndex(keyColName));
                byte[] valueRecord = (byte[])avroRecords.get(avroRecords.fieldIndex(valueColName));
                Row keySparkType = keyColConverter.convert((byte[])avroRecords.get(keyColIndex), ClassTag$.MODULE$.Nothing());
                Row valueSparkType = valueColConverter.convert((byte[])avroRecords.get(valueColIndex), ClassTag$.MODULE$.Nothing());
                Object[] columns = new Object[avroRecords.size()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), avroRecords.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    columns$1[i] = avroRecords.get(i);
                });
                columns[keyColIndex$2] = keySparkType;
                columns[valueColIndex$2] = valueSparkType;
                return Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)columns));
            });
        }, rowEncoder);
    }

    public Dataset<Row> fromAvroToRow(Dataset<Row> dataframe, Schema schema) {
        ExpressionEncoder<Row> rowEncoder = AvroToRowEncoderFactory$.MODULE$.createRowEncoder(schema);
        String plainSchema = schema.toString();
        return dataframe.as(Encoders$.MODULE$.BINARY()).mapPartitions((Function1 & Serializable & scala.Serializable)partition -> {
            AvroToRowConverter avroToRowConverter = new AvroToRowConverter((Option<ScalaDatumReader<ScalaAvroRecord>>)new Some(AvroReaderFactory$.MODULE$.createAvroReader(AvroSchemaUtils$.MODULE$.parse(plainSchema))));
            return partition.map((Function1 & Serializable & scala.Serializable)avroRecord -> avroToRowConverter.convert((byte[])avroRecord, ClassTag$.MODULE$.Nothing()));
        }, rowEncoder);
    }

    public Dataset<Row> fromAvroToRow(Dataset<Row> dataframe, String schemaPath) {
        return this.fromAvroToRow(dataframe, AvroSchemaUtils$.MODULE$.load(schemaPath));
    }

    public Dataset<Row> fromAvroToRow(Dataset<Row> dataframe, String schemaPath, String destinationColumn) {
        return this.fromAvroToRow(dataframe, AvroSchemaUtils$.MODULE$.load(schemaPath), destinationColumn);
    }

    public Dataset<Row> fromAvroToRowRetainingStructure(Dataset<Row> dataframe, String keyColName, String keySchemaPath, String valueColName, String valueSchemaPath) {
        return this.fromAvroToRowRetainingStructure(dataframe, keyColName, AvroSchemaUtils$.MODULE$.load(keySchemaPath), valueColName, AvroSchemaUtils$.MODULE$.load(valueSchemaPath));
    }

    public Dataset<Row> fromAvroToRow(Dataset<Row> dataframe, Map<String, String> schemaRegistryConf) {
        Schema schema = AvroSchemaUtils$.MODULE$.loadForValue(schemaRegistryConf);
        ExpressionEncoder<Row> rowEncoder = AvroToRowEncoderFactory$.MODULE$.createRowEncoder(schema);
        String plainSchema = schema.toString();
        return dataframe.as(Encoders$.MODULE$.BINARY()).mapPartitions((Function1 & Serializable & scala.Serializable)partition -> {
            AvroToRowConverter avroDecoder = new AvroToRowConverter((Option<ScalaDatumReader<ScalaAvroRecord>>)new Some(AvroReaderFactory$.MODULE$.createAvroReader(AvroSchemaUtils$.MODULE$.parse(plainSchema))));
            return partition.map((Function1 & Serializable & scala.Serializable)avroRecord -> avroDecoder.convert((byte[])avroRecord, ClassTag$.MODULE$.Nothing()));
        }, rowEncoder);
    }

    public Dataset<Row> fromAvroToRowWithKeysRetainingStructure(Dataset<Row> dataframe, String keyColName, String valueColName, Map<String, String> schemaRegistryConf) {
        Schema valueSchema = AvroSchemaUtils$.MODULE$.loadForValue(schemaRegistryConf);
        Schema keySchema = AvroSchemaUtils$.MODULE$.loadForKey(schemaRegistryConf);
        return this.fromAvroToRowRetainingStructure(dataframe, keyColName, keySchema, valueColName, valueSchema);
    }

    public Dataset<Row> fromAvroToRow(Dataset<Row> dataframe, Map<String, String> schemaRegistryConf, String destinationColumn) {
        Schema schema = AvroSchemaUtils$.MODULE$.loadForValue(schemaRegistryConf);
        StructType originalSchema = dataframe.schema();
        int destinationIndex = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])originalSchema.fields())).toList().indexWhere((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AvroDecoder.$anonfun$fromAvroToRow$9(destinationColumn, x$7)));
        originalSchema.fields()[destinationIndex] = new StructField(destinationColumn, (DataType)SparkAvroConversions$.MODULE$.toSqlType(schema), false, StructField$.MODULE$.$lessinit$greater$default$4());
        ExpressionEncoder<Row> rowEncoder = AvroToRowEncoderFactory$.MODULE$.createRowEncoder(originalSchema);
        String plainSchema = schema.toString();
        return dataframe.mapPartitions((Function1 & Serializable & scala.Serializable)partition -> {
            AvroToRowConverter avroToRowConverter = new AvroToRowConverter((Option<ScalaDatumReader<ScalaAvroRecord>>)new Some(AvroReaderFactory$.MODULE$.createAvroReader(AvroSchemaUtils$.MODULE$.parse(plainSchema))));
            return partition.map((Function1 & Serializable & scala.Serializable)avroRecord -> {
                Row sparkType = avroToRowConverter.convert((byte[])avroRecord.get(destinationIndex), ClassTag$.MODULE$.Nothing());
                Object[] array = new Object[avroRecord.size()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), avroRecord.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    array$4[i] = avroRecord.get(i);
                });
                array[destinationIndex$3] = sparkType;
                return Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)array));
            });
        }, rowEncoder);
    }

    public static final /* synthetic */ boolean $anonfun$fromConfluentAvroToRowWithKeys$1(String keyColName$1, StructField x$1) {
        String string = x$1.name().toLowerCase();
        String string2 = keyColName$1.toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$fromConfluentAvroToRowWithKeys$2(String valueColName$1, StructField x$2) {
        String string = x$2.name().toLowerCase();
        String string2 = valueColName$1.toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$fromConfluentAvroToRow$3(String destinationColumn$1, StructField x$3) {
        String string = x$3.name().toLowerCase();
        String string2 = destinationColumn$1.toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$fromAvroToRow$1(String destinationColumn$2, StructField x$4) {
        String string = x$4.name().toLowerCase();
        String string2 = destinationColumn$2.toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$fromAvroToRowRetainingStructure$1(String keyColName$2, StructField x$5) {
        String string = x$5.name().toLowerCase();
        String string2 = keyColName$2.toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$fromAvroToRowRetainingStructure$2(String valueColName$2, StructField x$6) {
        String string = x$6.name().toLowerCase();
        String string2 = valueColName$2.toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$fromAvroToRow$9(String destinationColumn$3, StructField x$7) {
        String string = x$7.name().toLowerCase();
        String string2 = destinationColumn$3.toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }
}

