/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.abris.avro.read.confluent;

import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.kafka.common.errors.SerializationException;
import scala.Function0;
import scala.Option;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import za.co.absa.abris.avro.format.ScalaAvroRecord;
import za.co.absa.abris.avro.read.ScalaDatumReader;
import za.co.absa.abris.avro.read.confluent.ConfluentConstants$;
import za.co.absa.abris.avro.read.confluent.SchemaManager$;

@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001\u0002\t\u0012\u0001\u0001B\u0001b\n\u0001\u0003\u0006\u0004%\t\u0001\u000b\u0005\to\u0001\u0011\t\u0011)A\u0005S!A\u0001\b\u0001BC\u0002\u0013\u0005\u0011\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003;\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u001dY\u0005A1A\u0005\n1Caa\u0015\u0001!\u0002\u0013i\u0005b\u0002+\u0001\u0005\u0004%I!\u0016\u0005\u0007W\u0002\u0001\u000b\u0011\u0002,\t\u000b1\u0004A\u0011A7\t\u000bU\u0004A\u0011\u0001<\t\u000f\u0005-\u0001\u0001\"\u0003\u0002\u000e!9\u0011Q\u0003\u0001\u0005\n\u0005]\u0001bBA\u0016\u0001\u0011%\u0011Q\u0006\u0005\b\u0003o\u0001A\u0011BA\u001d\u0005\r\u001a6-\u00197b\u0007>tg\r\\;f]R\\\u0015MZ6b\u0003Z\u0014x\u000eR3tKJL\u0017\r\\5{KJT!AE\n\u0002\u0013\r|gN\u001a7vK:$(B\u0001\u000b\u0016\u0003\u0011\u0011X-\u00193\u000b\u0005Y9\u0012\u0001B1we>T!\u0001G\r\u0002\u000b\u0005\u0014'/[:\u000b\u0005iY\u0012\u0001B1cg\u0006T!\u0001H\u000f\u0002\u0005\r|'\"\u0001\u0010\u0002\u0005i\f7\u0001A\n\u0003\u0001\u0005\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0017!\u0002;pa&\u001cW#A\u0015\u0011\u0007\tRC&\u0003\u0002,G\t1q\n\u001d;j_:\u0004\"!\f\u001b\u000f\u00059\u0012\u0004CA\u0018$\u001b\u0005\u0001$BA\u0019 \u0003\u0019a$o\\8u}%\u00111gI\u0001\u0007!J,G-\u001a4\n\u0005U2$AB*ue&twM\u0003\u00024G\u00051Ao\u001c9jG\u0002\nAB]3bI\u0016\u00148k\u00195f[\u0006,\u0012A\u000f\t\u0004E)Z\u0004C\u0001\u001fC\u001b\u0005i$B\u0001\f?\u0015\ty\u0004)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0003\u0006\u0019qN]4\n\u0005\rk$AB*dQ\u0016l\u0017-A\u0007sK\u0006$WM]*dQ\u0016l\u0017\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u001dK%\n\u0005\u0002I\u00015\t\u0011\u0003C\u0003(\u000b\u0001\u0007\u0011\u0006C\u00039\u000b\u0001\u0007!(\u0001\beK\u000e|G-\u001a:GC\u000e$xN]=\u0016\u00035\u0003\"AT)\u000e\u0003=S!\u0001U\u001f\u0002\u0005%|\u0017B\u0001*P\u00059!UmY8eKJ4\u0015m\u0019;pef\fq\u0002Z3d_\u0012,'OR1di>\u0014\u0018\u0010I\u0001\u000fS\u0012\u001c6\r[3nCJ+\u0017\rZ3s+\u00051\u0006\u0003B,]=\u0006l\u0011\u0001\u0017\u0006\u00033j\u000bq!\\;uC\ndWM\u0003\u0002\\G\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005uC&aA'baB\u0011!eX\u0005\u0003A\u000e\u00121!\u00138u!\r\u00117-Z\u0007\u0002'%\u0011Am\u0005\u0002\u0011'\u000e\fG.\u0019#biVl'+Z1eKJ\u0004\"AZ5\u000e\u0003\u001dT!\u0001[\u000b\u0002\r\u0019|'/\\1u\u0013\tQwMA\bTG\u0006d\u0017-\u0011<s_J+7m\u001c:e\u0003=IGmU2iK6\f'+Z1eKJ\u0004\u0013aF2p]\u001aLw-\u001e:f'\u000eDW-\\1SK\u001eL7\u000f\u001e:z)\tq\u0017\u000f\u0005\u0002#_&\u0011\u0001o\t\u0002\u0005+:LG\u000fC\u0003s\u0015\u0001\u00071/A\u0004d_:4\u0017nZ:\u0011\t5\"H\u0006L\u0005\u0003;Z\n1\u0002Z3tKJL\u0017\r\\5{KR\u0011q/ \t\u0003qnl\u0011!\u001f\u0006\u0003uv\nqaZ3oKJL7-\u0003\u0002}s\niq)\u001a8fe&\u001c'+Z2pe\u0012DQA`\u0006A\u0002}\fq\u0001]1zY>\fG\rE\u0003#\u0003\u0003\t)!C\u0002\u0002\u0004\r\u0012Q!\u0011:sCf\u00042AIA\u0004\u0013\r\tIa\t\u0002\u0005\u0005f$X-A\bhKR<&/\u001b;feN\u001b\u0007.Z7b)\u0015Y\u0014qBA\t\u0011\u00159C\u00021\u0001*\u0011\u0019\t\u0019\u0002\u0004a\u0001=\u0006\u0011\u0011\u000eZ\u0001\u000eO\u0016$()\u001f;f\u0005V4g-\u001a:\u0015\t\u0005e\u0011\u0011\u0006\t\u0005\u00037\t)#\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003\rq\u0017n\u001c\u0006\u0003\u0003G\tAA[1wC&!\u0011qEA\u000f\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0006}6\u0001\ra`\u0001\u000fO\u0016$H)\u0019;v[J+\u0017\rZ3s)\u001d\t\u0017qFA\u001a\u0003kAa!!\r\u000f\u0001\u0004Y\u0014\u0001D<sSR,'oU2iK6\f\u0007\"\u0002\u001d\u000f\u0001\u0004Q\u0004BBA\n\u001d\u0001\u0007a,A\tde\u0016\fG/\u001a#biVl'+Z1eKJ$R!YA\u001e\u0003{Aa!!\r\u0010\u0001\u0004Y\u0004\"\u0002\u001d\u0010\u0001\u0004Q\u0004")
public class ScalaConfluentKafkaAvroDeserializer {
    private final Option<String> topic;
    private final Option<Schema> readerSchema;
    private final DecoderFactory decoderFactory;
    private final Map<Object, ScalaDatumReader<ScalaAvroRecord>> idSchemaReader;

    public Option<String> topic() {
        return this.topic;
    }

    public Option<Schema> readerSchema() {
        return this.readerSchema;
    }

    private DecoderFactory decoderFactory() {
        return this.decoderFactory;
    }

    private Map<Object, ScalaDatumReader<ScalaAvroRecord>> idSchemaReader() {
        return this.idSchemaReader;
    }

    public void configureSchemaRegistry(scala.collection.immutable.Map<String, String> configs) {
        block0: {
            if (!configs.nonEmpty()) break block0;
            SchemaManager$.MODULE$.configureSchemaRegistry(configs);
        }
    }

    public GenericRecord deserialize(byte[] payload) {
        GenericRecord genericRecord;
        if (payload == null) {
            return null;
        }
        int schemaId = -1;
        try {
            ByteBuffer buffer = this.getByteBuffer(payload);
            schemaId = buffer.getInt();
            Schema writerSchema = this.getWriterSchema(this.topic(), schemaId);
            int length = buffer.limit() - 1 - ConfluentConstants$.MODULE$.SCHEMA_ID_SIZE_BYTES();
            int start = buffer.position() + buffer.arrayOffset();
            ScalaDatumReader<ScalaAvroRecord> reader = this.getDatumReader(writerSchema, this.readerSchema(), schemaId);
            genericRecord = (GenericRecord)reader.read(null, (Decoder)this.decoderFactory().binaryDecoder(buffer.array(), start, length, null));
        }
        catch (RestClientException e) {
            throw new SerializationException(new StringBuilder(36).append("Error retrieving Avro schema for id ").append(schemaId).toString(), (Throwable)e);
        }
        catch (Throwable throwable) {
            throw new SerializationException(new StringBuilder(40).append("Error deserializing Avro message for id ").append(schemaId).toString(), throwable);
        }
        return genericRecord;
    }

    private Schema getWriterSchema(Option<String> topic, int id) {
        return topic.isDefined() && SchemaManager$.MODULE$.isSchemaRegistryConfigured() ? (Schema)SchemaManager$.MODULE$.getById(id).get() : (Schema)this.readerSchema().get();
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuffer getByteBuffer(byte[] payload) {
        void var2_2;
        ByteBuffer buffer = ByteBuffer.wrap(payload);
        if (buffer.get() != ConfluentConstants$.MODULE$.MAGIC_BYTE()) {
            throw new SerializationException("Unknown magic byte!");
        }
        return var2_2;
    }

    private ScalaDatumReader<ScalaAvroRecord> getDatumReader(Schema writerSchema, Option<Schema> readerSchema, int id) {
        return (ScalaDatumReader)((Object)this.idSchemaReader().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)id), (Function0 & Serializable & scala.Serializable)() -> this.createDatumReader(writerSchema, readerSchema)));
    }

    private ScalaDatumReader<ScalaAvroRecord> createDatumReader(Schema writerSchema, Option<Schema> readerSchema) {
        return new ScalaDatumReader<ScalaAvroRecord>(writerSchema, readerSchema.isDefined() ? (Schema)readerSchema.get() : writerSchema);
    }

    public ScalaConfluentKafkaAvroDeserializer(Option<String> topic, Option<Schema> readerSchema) {
        this.topic = topic;
        this.readerSchema = readerSchema;
        if (topic.isEmpty() && readerSchema.isEmpty()) {
            throw new IllegalArgumentException("Neither topic nor reader Schema were informed. If you want a specific schema to be used for reading pass it as the readerSchema value. Otherwise, if you'd like the schema to be retrieved from SchemaRegistry, pass in the topic being consume and inform the SchemaRegistry URLs by calling  'configure' in this object using SchemaManager.PARAM_SCHEMA_REGISTRY_URL as the key in the map.");
        }
        this.decoderFactory = DecoderFactory.get();
        this.idSchemaReader = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

