/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.abris.avro.format;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import za.co.absa.abris.avro.format.SparkAvroConversions;
import za.co.absa.abris.avro.parsing.utils.AvroSchemaUtils$;
import za.co.absa.abris.avro.read.confluent.ConfluentConstants$;
import za.co.absa.abris.avro.write.AvroWriterHolder;

public final class SparkAvroConversions$ {
    public static SparkAvroConversions$ MODULE$;
    private final scala.collection.mutable.HashMap<SparkAvroConversions.ConverterKey, Function1<Object, Object>> converterCache;

    static {
        new SparkAvroConversions$();
    }

    private scala.collection.mutable.HashMap<SparkAvroConversions.ConverterKey, Function1<Object, Object>> converterCache() {
        return this.converterCache;
    }

    private AvroWriterHolder avroWriterHolder() {
        return new AvroWriterHolder();
    }

    private void attachSchemaId(int id, ByteArrayOutputStream outStream) {
        outStream.write(ConfluentConstants$.MODULE$.MAGIC_BYTE());
        outStream.write(ByteBuffer.allocate(ConfluentConstants$.MODULE$.SCHEMA_ID_SIZE_BYTES()).putInt(id).array());
    }

    public byte[] toByteArray(IndexedRecord record, Schema schema, Option<Object> schemaId) {
        byte[] byArray;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        if (schemaId.isDefined()) {
            this.attachSchemaId(BoxesRunTime.unboxToInt((Object)schemaId.get()), outStream);
        }
        Encoder encoder = this.avroWriterHolder().getEncoder(outStream);
        try {
            this.avroWriterHolder().getWriter(schema).write((Object)record, encoder);
            encoder.flush();
            outStream.flush();
            byArray = outStream.toByteArray();
        }
        finally {
            outStream.close();
        }
        return byArray;
    }

    public Option<Object> toByteArray$default$3() {
        return None$.MODULE$;
    }

    public Schema toAvroSchema(StructType structType, String schemaName, String schemaNamespace) {
        return SchemaConverters$.MODULE$.toAvroType((DataType)structType, false, schemaName, schemaNamespace);
    }

    public byte[] rowToBinaryAvro(Row row, StructType sparkSchema, Schema avroSchema, Option<Object> schemaId) {
        GenericRecord record = this.rowToGenericRecord(row, sparkSchema, avroSchema);
        return this.toByteArray((IndexedRecord)record, avroSchema, schemaId);
    }

    public Option<Object> rowToBinaryAvro$default$4() {
        return None$.MODULE$;
    }

    public StructType toSqlType(String schema) {
        return this.toSqlType(AvroSchemaUtils$.MODULE$.parse(schema));
    }

    public StructType toSqlType(Schema schema) {
        return (StructType)SchemaConverters$.MODULE$.toSqlType(schema).dataType();
    }

    private GenericRecord rowToGenericRecord(Row row, StructType sparkSchema, Schema avroSchema) {
        Function1<Object, Object> converter = this.getConverter((DataType)sparkSchema, avroSchema);
        return (GenericRecord)converter.apply((Object)row);
    }

    private Function1<Object, Object> getConverter(DataType dataType, Schema avroSchema) {
        SparkAvroConversions.ConverterKey key = new SparkAvroConversions.ConverterKey(dataType, avroSchema.getName(), avroSchema.getNamespace());
        return (Function1)this.converterCache().getOrElseUpdate((Object)key, (Function0 & Serializable & scala.Serializable)() -> MODULE$.createConverterToAvro(dataType, avroSchema));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Function1<Object, Object> createConverterToAvro(DataType dataType, Schema schema) {
        DataType dataType2 = dataType;
        if (BinaryType$.MODULE$.equals(dataType2)) {
            return (Function1 & Serializable & scala.Serializable)item -> {
                ByteBuffer byteBuffer;
                Object object = item;
                if (object == null) {
                    byteBuffer = null;
                } else if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    byteBuffer = ByteBuffer.wrap(byArray);
                } else {
                    throw new MatchError(object);
                }
                return byteBuffer;
            };
        }
        boolean bl = ByteType$.MODULE$.equals(dataType2) ? true : (ShortType$.MODULE$.equals(dataType2) ? true : (IntegerType$.MODULE$.equals(dataType2) ? true : (LongType$.MODULE$.equals(dataType2) ? true : (FloatType$.MODULE$.equals(dataType2) ? true : (DoubleType$.MODULE$.equals(dataType2) ? true : (StringType$.MODULE$.equals(dataType2) ? true : BooleanType$.MODULE$.equals(dataType2)))))));
        if (bl) {
            return (Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x);
        }
        if (dataType2 instanceof DecimalType) {
            return (Function1 & Serializable & scala.Serializable)item -> item == null ? null : item.toString();
        }
        if (TimestampType$.MODULE$.equals(dataType2)) {
            return (Function1 & Serializable & scala.Serializable)item -> item == null ? null : BoxesRunTime.boxToLong((long)((Timestamp)item).getTime());
        }
        if (DateType$.MODULE$.equals(dataType2)) {
            return (Function1 & Serializable & scala.Serializable)item -> item == null ? null : BoxesRunTime.boxToLong((long)((Date)item).getTime());
        }
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            Function1<Object, Object> elementConverter = this.createConverterToAvro(elementType, schema);
            return (Function1 & Serializable & scala.Serializable)item -> {
                Object[] objectArray;
                if (item == null) {
                    objectArray = null;
                } else {
                    Seq sourceArray = (Seq)item;
                    int sourceArraySize = sourceArray.size();
                    Object[] targetArray = new Object[sourceArraySize];
                    for (int idx = 0; idx < sourceArraySize; ++idx) {
                        targetArray[idx] = elementConverter.apply(sourceArray.apply(idx));
                    }
                    objectArray = targetArray;
                }
                return objectArray;
            };
        }
        if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType dataType3 = mapType.keyType();
            DataType valueType = mapType.valueType();
            if (StringType$.MODULE$.equals(dataType3)) {
                Function1<Object, Object> valueConverter = this.createConverterToAvro(valueType, schema);
                return (Function1 & Serializable & scala.Serializable)item -> {
                    Object v0;
                    if (item == null) {
                        v0 = null;
                    } else {
                        void var2_2;
                        HashMap javaMap = new HashMap();
                        ((Map)item).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                            Tuple2 tuple2 = x0$1;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            String key = (String)tuple2._1();
                            Object value = tuple2._2();
                            Object object = javaMap.put(key, valueConverter.apply(value));
                            return object;
                        });
                        v0 = var2_2;
                    }
                    return v0;
                };
            }
        }
        if (!(dataType2 instanceof StructType)) throw new MatchError((Object)dataType2);
        StructType structType = (StructType)dataType2;
        IndexedSeq fieldConverters = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), schema.getFields().size()).map((Function1 & Serializable & scala.Serializable)i -> SparkAvroConversions$.MODULE$.createConverterToAvro(structType.fields()[BoxesRunTime.unboxToInt((Object)i)].dataType(), ((Schema.Field)schema.getFields().get(BoxesRunTime.unboxToInt((Object)i))).schema()), IndexedSeq$.MODULE$.canBuildFrom());
        return (Function1 & Serializable & scala.Serializable)item -> {
            GenericData.Record record;
            if (item == null) {
                record = null;
            } else {
                GenericData.Record record2 = new GenericData.Record(schema);
                Iterator convertersIterator = fieldConverters.iterator();
                Iterator fieldNamesIterator = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((StructType)dataType).fieldNames())).iterator();
                Iterator rowIterator = ((Row)item).toSeq().iterator();
                while (convertersIterator.hasNext()) {
                    Function1 converter = (Function1)convertersIterator.next();
                    record2.put((String)fieldNamesIterator.next(), converter.apply(rowIterator.next()));
                }
                record = record2;
            }
            return record;
        };
    }

    private SparkAvroConversions$() {
        MODULE$ = this;
        this.converterCache = new scala.collection.mutable.HashMap();
    }
}

