/*
 * Decompiled with CFR 0.152.
 */
package xyz.tozymc.configuration.serialization;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.tozymc.configuration.exception.TcConfigSerializationException;
import xyz.tozymc.configuration.serialization.ReflectionCache;
import xyz.tozymc.configuration.serialization.TcConfigSerializer;
import xyz.tozymc.configuration.serialization.annotation.AutoSerialization;

public final class TcConfigSerializations {
    private static final Map<Class<?>, TcConfigSerializer<?>> registeredSerializers = new HashMap();
    private static final ReflectionCache reflectionCache = new ReflectionCache();

    private TcConfigSerializations() {
    }

    public static synchronized void clearCache() {
        reflectionCache.clear();
    }

    public static synchronized void registerSerializer(@NotNull TcConfigSerializer<?> serializer) {
        Class<?> clazz;
        if (registeredSerializers.containsValue(serializer)) {
            throw new IllegalStateException("Serializer for " + serializer.getClass().getName() + " is registered");
        }
        try {
            clazz = TcConfigSerializations.getSerializableObjectType(serializer);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Serializable object type not found", e);
        }
        registeredSerializers.put(clazz, serializer);
    }

    public static synchronized void registerSerializers(TcConfigSerializer<?> ... serializers) {
        Arrays.stream(serializers).forEach(TcConfigSerializations::registerSerializer);
    }

    public static synchronized void unregisterSerializer(@NotNull TcConfigSerializer<?> serializer) {
        if (!registeredSerializers.containsValue(serializer)) {
            throw new IllegalStateException("Serializer " + serializer.getClass().getName() + " is not registered");
        }
        Class clazz = registeredSerializers.entrySet().stream().filter(entry -> Objects.equals(entry.getValue(), serializer)).findFirst().map(Map.Entry::getKey).get();
        registeredSerializers.remove(clazz);
    }

    public static synchronized void unregisterSerializers(TcConfigSerializer<?> ... serializers) {
        Arrays.stream(serializers).forEach(TcConfigSerializations::unregisterSerializer);
    }

    @NotNull
    private static Class<?> getSerializableObjectType(@NotNull TcConfigSerializer<?> serializer) throws ClassNotFoundException {
        String typeName = serializer.getClass().getGenericInterfaces()[0].getTypeName();
        return Class.forName(typeName.substring(typeName.indexOf(60) + 1, typeName.indexOf(62)));
    }

    @NotNull
    public static Map<String, ?> serializeObject(@NotNull Object object) {
        Class<?> type = object.getClass();
        Map<String, ?> serialized = TcConfigSerializations.serializeObjectBySerializer(object);
        if (serialized != null) {
            return serialized;
        }
        if (!type.isAnnotationPresent(AutoSerialization.class)) {
            throw new TcConfigSerializationException("Couldn't find any serializer for " + type.getName());
        }
        return TcConfigSerializations.serializeAnnotatedObject(type, object);
    }

    @Nullable
    private static <T> Map<String, ?> serializeObjectBySerializer(@NotNull T object) {
        TcConfigSerializer<?> serializer = registeredSerializers.get(object.getClass());
        if (serializer == null) {
            return null;
        }
        return serializer.serialize(object);
    }

    @NotNull
    private static Map<String, ?> serializeAnnotatedObject(@NotNull Class<?> type, Object object) {
        return reflectionCache.getAnnotatedFields(type).stream().collect(Collectors.toMap(ReflectionCache.AnnotatedField::key, f -> f.value(object), (a, b) -> a, LinkedHashMap::new));
    }

    @NotNull
    public static <T> T deserializeObject(@NotNull Class<T> type, Map<String, ?> serialized) {
        T deserialized = TcConfigSerializations.deserializeObjectBySerializer(type, serialized);
        if (deserialized != null) {
            return deserialized;
        }
        if (!type.isAnnotationPresent(AutoSerialization.class)) {
            throw new TcConfigSerializationException("Couldn't find any serializer for " + type.getName());
        }
        return TcConfigSerializations.deserializeAnnotatedObject(type, serialized);
    }

    @Nullable
    private static <T> T deserializeObjectBySerializer(@NotNull Class<T> type, Map<String, ?> serialized) {
        TcConfigSerializer<?> serializer = registeredSerializers.get(type);
        if (serializer == null) {
            return null;
        }
        return (T)serializer.deserialize(serialized);
    }

    private static <T> T deserializeAnnotatedObject(@NotNull Class<T> type, Map<String, ?> serialized) {
        return type.cast(reflectionCache.getAnnotatedConstructor(type).newInstance(serialized));
    }
}

