/*
 * Decompiled with CFR 0.152.
 */
package xyz.tozymc.configuration.file;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import xyz.tozymc.configuration.TcConfig;
import xyz.tozymc.configuration.file.FileConfigSection;
import xyz.tozymc.configuration.file.option.FileConfigOptions;
import xyz.tozymc.configuration.file.option.ReloadableType;

public abstract class FileConfig
extends FileConfigSection
implements TcConfig {
    private final Path path;
    protected FileConfigOptions options;
    private FileTime lastModifiedTime;

    protected FileConfig(@NotNull Path path) {
        this.path = path;
        this.options = new FileConfigOptions(this);
        this.updateLastModifiedTimeIfNeeded();
    }

    protected abstract Map<String, ?> readToMap() throws IOException;

    protected abstract String writeToString();

    public void reload() {
        Map<String, ?> values;
        this.updateLastModifiedTimeIfNeeded();
        try {
            values = this.readToMap();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error when loading configuration", e);
        }
        this.reloadSection(values);
    }

    public void save() {
        String data = this.writeToString();
        try {
            Files.write(this.path, data.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error when save configuration", e);
        }
        this.updateLastModifiedTimeIfNeeded();
    }

    private void updateLastModifiedTimeIfNeeded() {
        if (this.options.reloadType().equals((Object)ReloadableType.INTELLIGENT)) {
            this.updateLastModifiedTime();
        }
    }

    private FileTime updateLastModifiedTime() {
        FileTime peek = this.lastModifiedTime;
        try {
            this.lastModifiedTime = Files.getLastModifiedTime(this.path, new LinkOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error when update last configuration modified time", e);
        }
        return peek;
    }

    private boolean shouldReload() {
        FileTime peek = this.updateLastModifiedTime();
        return peek.compareTo(this.lastModifiedTime) != 0;
    }

    protected void reloadIfNeeded() {
        ReloadableType reloadableType = this.options.reloadType();
        if (reloadableType.equals((Object)ReloadableType.MANUALLY)) {
            return;
        }
        if (reloadableType.equals((Object)ReloadableType.AUTOMATICALLY)) {
            this.reload();
            return;
        }
        if (this.shouldReload()) {
            this.reload();
        }
    }

    @Override
    @NotNull
    public FileConfigOptions getOptions() {
        return this.options;
    }

    @NotNull
    public Path getPath() {
        return this.path;
    }
}

