/*
 * Decompiled with CFR 0.152.
 */
package xyz.tozymc.spigot.api.command.util;

import org.jetbrains.annotations.Contract;
import xyz.tozymc.spigot.api.command.Command;
import xyz.tozymc.spigot.api.util.Arrays;
import xyz.tozymc.spigot.api.util.bukkit.Colors;

public final class CommonMessage {
    private static String[] noPermissions = new String[]{"&cYou don't have permission to do that."};
    private static String[] noPermission = new String[]{"&cYou don't have permission {permission} to do that."};
    private static String[] notConsole = new String[]{"&cRequire console to execute this command."};
    private static String[] notPlayer = new String[]{"&cYou must be player to execute this command!"};
    private static String[] syntaxUsage = new String[]{"&cUsage: &f{syntax} &7- {description}"};

    private CommonMessage() {
    }

    @Contract(pure=true)
    public static String[] getNoPermissions() {
        return noPermissions;
    }

    public static void setNoPermissions(String ... noPermissions) {
        Colors.color(noPermissions);
        CommonMessage.noPermissions = noPermissions;
    }

    @Contract(pure=true)
    public static String[] getNoPermission() {
        return noPermission;
    }

    public static void setNoPermission(String ... noPermission) {
        Colors.color(noPermission);
        CommonMessage.noPermission = noPermission;
    }

    public static String[] getNoPermission(String permission) {
        String[] texts = (String[])noPermission.clone();
        Arrays.setAll(texts, i -> texts[i].replaceAll("\\{permission}", permission));
        Colors.color(texts);
        return texts;
    }

    @Contract(pure=true)
    public static String[] getNotConsole() {
        return notConsole;
    }

    public static void setNotConsole(String ... notConsole) {
        Colors.color(notConsole);
        CommonMessage.notConsole = notConsole;
    }

    @Contract(pure=true)
    public static String[] getNotPlayer() {
        return notPlayer;
    }

    public static void setNotPlayer(String ... notPlayer) {
        Colors.color(notPlayer);
        CommonMessage.notPlayer = notPlayer;
    }

    @Contract(pure=true)
    public static String[] getSyntaxUsage() {
        return syntaxUsage;
    }

    public static void setSyntaxUsage(String ... syntaxUsage) {
        Colors.color(syntaxUsage);
        CommonMessage.syntaxUsage = syntaxUsage;
    }

    public static String[] getSyntaxUsage(Command command) {
        String[] texts = syntaxUsage;
        Arrays.setAll(texts, i -> texts[i].replaceAll("\\{syntax}", command.getSyntax()));
        Arrays.setAll(texts, i -> texts[i].replaceAll("\\{description}", command.getDescription()));
        Colors.color(texts);
        return texts;
    }

    static {
        Colors.color(noPermissions);
        Colors.color(noPermission);
        Colors.color(notConsole);
        Colors.color(notPlayer);
        Colors.color(syntaxUsage);
    }
}

