/*
 * Decompiled with CFR 0.152.
 */
package xyz.tozymc.spigot.api.command.result;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import xyz.tozymc.spigot.api.util.Lists;

public class TabResult {
    public static final TabResult EMPTY_RESULT = new TabResult("", new ArrayList<String>());
    private final String token;
    private final Iterable<String> completer;

    private TabResult(@NotNull String token, @NotNull Iterable<String> completer) {
        this.token = token;
        this.completer = completer;
    }

    @NotNull
    @Contract(value="_, _ -> new", pure=true)
    public static TabResult of(@NotNull String token, @NotNull Iterable<String> completer) {
        return new TabResult(token, completer);
    }

    @NotNull
    @Contract(value="_, _ -> new", pure=true)
    public static TabResult of(@NotNull String token, String ... completer) {
        return TabResult.of(token, Lists.newArrayList(completer));
    }

    @NotNull
    @Contract(pure=true)
    public static TabResult empty() {
        return EMPTY_RESULT;
    }

    public List<String> getResult() {
        if (this.equals(EMPTY_RESULT)) {
            return new ArrayList<String>();
        }
        return (List)StringUtil.copyPartialMatches((String)this.token, this.completer, new ArrayList());
    }

    public String getToken() {
        return this.token;
    }

    public Iterable<String> getCompleter() {
        return this.completer;
    }
}

