/*
 * Decompiled with CFR 0.152.
 */
package xyz.tozymc.spigot.api.command.result;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandResult {
    public static final CommandResult NO_PERMISSIONS = new CommandResult(Type.NO_PERMISSION, new String[0]);
    public static final CommandResult SUCCESS = new CommandResult(Type.SUCCESS, new String[0]);
    public static final CommandResult FAILURE = new CommandResult(Type.FAILURE, new String[0]);
    public static final CommandResult WRONG_SYNTAX = new CommandResult(Type.WRONG_SYNTAX, new String[0]);
    private final Type type;
    private final String[] params;

    @Contract(pure=true)
    private CommandResult(@NotNull Type type, String ... params) {
        this.type = type;
        this.params = params;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static CommandResult from(Type type, String ... params) {
        return new CommandResult(type, params);
    }

    @NotNull
    @Contract(pure=true)
    public static CommandResult unknown() {
        return FAILURE;
    }

    @NotNull
    public Type getType() {
        return this.type;
    }

    @Nullable
    public String[] getParams() {
        return this.params;
    }

    public static enum Type {
        FAILURE(false),
        NO_PERMISSION(false),
        SUCCESS(true),
        WRONG_SYNTAX(false);

        private final boolean result;

        private Type(boolean result) {
            this.result = result;
        }

        public boolean asBoolean() {
            return this.result;
        }
    }
}

