/*
 * Decompiled with CFR 0.152.
 */
package xyz.tozymc.spigot.api.util.bukkit.permission;

import java.util.StringJoiner;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import xyz.tozymc.spigot.api.util.Arrays;

public class PermissionWrapper {
    private final String permission;

    @Contract(pure=true)
    private PermissionWrapper(@NotNull String permission) {
        this.permission = permission;
    }

    @NotNull
    public static PermissionWrapper of(@NotNull PermissionWrapper parent, @NotNull String permission) {
        return PermissionWrapper.of(parent.permission, permission);
    }

    @NotNull
    public static PermissionWrapper of(String ... nodes) {
        StringJoiner joiner = new StringJoiner(".");
        return PermissionWrapper.of(Arrays.joinToString(joiner, nodes));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static PermissionWrapper of(@NotNull String permission) {
        return new PermissionWrapper(permission);
    }

    public boolean playerHas(@NotNull Player player) {
        return this.check((Permissible)player);
    }

    public boolean has(@NotNull CommandSender sender) {
        return this.check((Permissible)sender);
    }

    public boolean notHas(@NotNull CommandSender sender) {
        return !this.has(sender);
    }

    public boolean entityHas(@NotNull Entity entity) {
        return this.check((Permissible)entity);
    }

    private boolean check(Permissible permissible) {
        if (permissible instanceof ConsoleCommandSender) {
            return true;
        }
        if (permissible.isOp()) {
            return true;
        }
        return permissible.hasPermission("*") || permissible.hasPermission(this.permission);
    }

    @NotNull
    public String getPermission() {
        return this.permission;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof PermissionWrapper)) {
            return false;
        }
        PermissionWrapper other = (PermissionWrapper)o;
        return other.permission.equals(this.permission);
    }

    public int hashCode() {
        int PRIME = 59;
        return PRIME + this.permission.hashCode();
    }

    public String toString() {
        return "PermissionWrapper(permission=" + this.permission + ")";
    }
}

