/*
 * Decompiled with CFR 0.152.
 */
package xyz.tozymc.spigot.api.command;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.tozymc.spigot.api.command.Command;
import xyz.tozymc.spigot.api.command.handler.CommandHandler;
import xyz.tozymc.spigot.api.command.handler.TabHandler;
import xyz.tozymc.spigot.api.command.wrapper.SimpleCommandMapWrapper;

public final class CommandController {
    private final JavaPlugin plugin;
    private final CommandHandler commandHandler;
    private final TabHandler tabHandler;
    private final String fallbackPrefix;
    private final Map<String, Command> rootCommands = new HashMap<String, Command>();
    private final Map<Command, List<Command>> commands = new HashMap<Command, List<Command>>();
    private final SimpleCommandMapWrapper commandMapWrapper;

    public CommandController(@NotNull JavaPlugin plugin) {
        this(plugin, (CommandHandler)null);
    }

    public CommandController(@NotNull JavaPlugin plugin, @NotNull String fallbackPrefix) {
        this(plugin, null, fallbackPrefix);
    }

    public CommandController(@NotNull JavaPlugin plugin, @Nullable CommandHandler commandHandler) {
        this(plugin, commandHandler, plugin.getDescription().getName());
    }

    public CommandController(@NotNull JavaPlugin plugin, @Nullable CommandHandler commandHandler, @NotNull String fallbackPrefix) {
        this.plugin = plugin;
        this.commandHandler = commandHandler == null ? new CommandHandler(this) : commandHandler;
        this.tabHandler = new TabHandler(this);
        this.fallbackPrefix = fallbackPrefix;
        this.commandMapWrapper = new SimpleCommandMapWrapper(this);
    }

    @NotNull
    public Command addCommand(@NotNull Command command) {
        if (command.getRoot() == null) {
            Preconditions.checkState((boolean)this.registerPluginCommand(command), (String)"Command %s is registered.", (Object)command.toString());
            return command;
        }
        Command root = command.getRoot();
        Preconditions.checkState((root.getRoot() == null ? 1 : 0) != 0, (Object)"Not support child command register as root command.");
        Preconditions.checkState((boolean)this.rootCommands.containsKey(root.getName()), (String)"Root command %s must be registered first.", (Object)root.toString());
        return this.addChildCommand(command.getRoot(), command);
    }

    private boolean registerPluginCommand(@NotNull Command command) {
        this.rootCommands.put(command.getName(), command);
        return this.commandMapWrapper.registerPluginCommand(command);
    }

    @NotNull
    @Contract(value="_, _ -> param2")
    private Command addChildCommand(@NotNull Command parent, @NotNull Command child) {
        List subCommands = this.commands.getOrDefault(parent, new ArrayList());
        subCommands.add(child);
        this.commands.put(parent, subCommands);
        return child;
    }

    @NotNull
    @Contract(value="_ -> param1")
    public Command removeCommand(@NotNull Command command) {
        if (command.getRoot() != null) {
            Preconditions.checkState((boolean)this.removeChildCommand(command), (String)"Child command %s is unregistered.", (Object)command.toString());
            return command;
        }
        Preconditions.checkState((boolean)this.unregisterPluginCommand(command), (String)"Command %s is unregistered.", (Object)command.toString());
        this.removeAllChildrenCommand(command);
        return command;
    }

    private boolean unregisterPluginCommand(@NotNull Command command) {
        this.rootCommands.remove(command.getName());
        return this.commandMapWrapper.unregisterPluginCommand(command);
    }

    private boolean removeChildCommand(@NotNull Command command) {
        return this.commands.get(command.getRoot()).remove(command);
    }

    private void removeAllChildrenCommand(Command root) {
        this.commands.remove(root);
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public String[] deleteFirstArg(@NotNull String[] args) {
        return Arrays.copyOfRange(args, 1, args.length);
    }

    public boolean isFinalCommand(Command parent, String[] args) {
        return xyz.tozymc.spigot.api.util.Arrays.isEmpty(args) || !this.commands.containsKey(parent);
    }

    @NotNull
    public Optional<Command> getCommand(Command root, String name) {
        return this.commands.get(root).stream().filter(command -> command.getName().equalsIgnoreCase(name)).findFirst();
    }

    @Nullable
    public Command getRootCommand(@NotNull String name) {
        return this.rootCommands.getOrDefault(name, null);
    }

    @Contract(pure=true)
    @NotNull
    public String getFallbackPrefix() {
        return this.fallbackPrefix;
    }

    @Contract(pure=true)
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Contract(pure=true)
    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    @Contract(pure=true)
    public TabHandler getTabHandler() {
        return this.tabHandler;
    }

    @NotNull
    public List<Command> getAllCommands() {
        ArrayList<Command> commandList = new ArrayList<Command>(this.rootCommands.values());
        commandList.addAll(this.commands.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        return commandList;
    }

    @Contract(pure=true)
    @NotNull
    public Map<Command, List<Command>> getCommands() {
        return this.commands;
    }
}

