/*
 * Decompiled with CFR 0.152.
 */
package xyz.tozymc.spigot.api.command;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.tozymc.spigot.api.command.Command;
import xyz.tozymc.spigot.api.util.Lists;

public abstract class AbstractCommand
implements Command {
    protected final Command parent;
    protected final String name;
    private final List<String> aliases;

    public AbstractCommand(@Nullable Command parent, @NotNull String name, @NotNull List<String> aliases) {
        this.parent = parent;
        this.name = name;
        this.aliases = Lists.addAll(aliases, name);
    }

    public AbstractCommand(@Nullable Command parent, @NotNull String name, String ... aliases) {
        this(parent, name, Lists.newArrayList(aliases));
    }

    public AbstractCommand(@NotNull Command parent, @NotNull String name) {
        this(parent, name, new ArrayList<String>());
    }

    public AbstractCommand(@NotNull String name) {
        this(null, name, new ArrayList<String>());
    }

    public AbstractCommand(@NotNull String name, String ... aliases) {
        this((Command)null, name, aliases);
    }

    public AbstractCommand(@NotNull String name, @NotNull List<String> aliases) {
        this(null, name, aliases);
    }

    @Override
    @Nullable
    public Command getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<String> getAliases() {
        return this.aliases;
    }
}

