/*
 * Decompiled with CFR 0.152.
 */
package xyz.tozymc.spigot.api.command;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.tozymc.spigot.api.command.Command;
import xyz.tozymc.spigot.api.command.handler.CommandHandler;
import xyz.tozymc.spigot.api.command.handler.TabHandler;

public final class CommandController {
    private final JavaPlugin plugin;
    private final CommandHandler commandHandler;
    private final TabHandler tabHandler;
    private final Map<String, Command> rootCommands = new HashMap<String, Command>();
    private final Map<Command, List<Command>> commands = new HashMap<Command, List<Command>>();

    @Contract(pure=true)
    public CommandController(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
        this.commandHandler = new CommandHandler(this);
        this.tabHandler = new TabHandler(this);
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public String[] deleteFirstArg(@NotNull String[] args) {
        return Arrays.copyOfRange(args, 1, args.length);
    }

    public boolean isFinalCommand(Command parent, String[] args) {
        return xyz.tozymc.spigot.api.util.Arrays.isEmpty(args) || !this.commands.containsKey(parent);
    }

    @NotNull
    public Optional<Command> getCommand(Command root, String name) {
        return this.commands.get(root).stream().filter(command -> command.getName().equalsIgnoreCase(name)).findFirst();
    }

    @Nullable
    public Command getRootCommand(@NotNull String name) {
        return this.rootCommands.getOrDefault(name, null);
    }

    @NotNull
    @Contract(value="_ -> param1")
    private Command registerPluginCommand(@NotNull Command command) {
        String name = command.getName();
        this.rootCommands.put(name, command);
        PluginCommand pluginCmd = (PluginCommand)Preconditions.checkNotNull((Object)this.plugin.getCommand(name), (String)"Command %s need register in plugin.yml", (Object)name);
        pluginCmd.setExecutor((CommandExecutor)this.commandHandler);
        pluginCmd.setAliases(command.getAliases()).setDescription(command.getDescription());
        pluginCmd.setTabCompleter((TabCompleter)this.tabHandler);
        return command;
    }

    @NotNull
    private Command addSubCommand(@NotNull Command parent, @NotNull Command child) {
        List subCommands = this.commands.getOrDefault(parent, new ArrayList());
        subCommands.add(child);
        this.commands.put(parent, subCommands);
        return child;
    }

    @NotNull
    public Command addCommand(@NotNull Command command) {
        if (command.getParent() == null) {
            return this.registerPluginCommand(command);
        }
        Preconditions.checkState((command.getParent().getParent() == null ? 1 : 0) != 0, (Object)"Not support child command registered as root command.");
        return this.addSubCommand(command.getParent(), command);
    }

    @NotNull
    public List<Command> getAllCommands() {
        ArrayList<Command> commands = new ArrayList<Command>(this.rootCommands.values());
        commands.addAll(this.commands.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        return commands;
    }

    @Contract(pure=true)
    @NotNull
    public Map<Command, List<Command>> getCommands() {
        return this.commands;
    }
}

