/*
 * Decompiled with CFR 0.152.
 */
package xyz.quaver.io;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import androidx.annotation.RequiresApi;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.quaver.io.util.DocumentUtilKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010!\u001a\u00020\"R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\nR\u0011\u0010\u0015\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\nR\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\"\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0010\u0010 \u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lxyz/quaver/io/Cache;", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "(Landroid/content/Context;Landroid/net/Uri;)V", "canRead", "", "getCanRead", "()Z", "canWrite", "getCanWrite", "documentID", "", "exists", "getExists", "flags", "", "Ljava/lang/Integer;", "isDirectory", "isFile", "<set-?>", "", "lastModified", "getLastModified", "()J", "length", "getLength", "name", "getName", "()Ljava/lang/String;", "type", "invalidate", "", "xyz.quaver.io.documentfilex"})
@RequiresApi(value=19)
public final class Cache {
    @NotNull
    private final Context context;
    @NotNull
    private final Uri uri;
    @Nullable
    private String type;
    @Nullable
    private Integer flags;
    @Nullable
    private String documentID;
    @Nullable
    private String name;
    private long lastModified;
    private long length;

    public Cache(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.context = context;
        this.uri = uri;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    public final long getLastModified() {
        return this.lastModified;
    }

    public final long getLength() {
        return this.length;
    }

    public final boolean getCanRead() {
        return DocumentUtilKt.hasPermission(this.uri, this.context) && DocumentUtilKt.canRead(this.type);
    }

    public final boolean getCanWrite() {
        return DocumentUtilKt.hasPermission(this.uri, this.context) && DocumentUtilKt.canWrite(this.type, this.flags);
    }

    public final boolean isDirectory() {
        return Intrinsics.areEqual((Object)this.type, (Object)"vnd.android.document/directory");
    }

    public final boolean isFile() {
        return !this.isDirectory();
    }

    public final boolean getExists() {
        return this.documentID != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invalidate() {
        Cursor cursor = this.context.getContentResolver().query(this.uri, null, null, null, null);
        if (cursor != null) {
            Closeable closeable = (Closeable)cursor;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Cursor it = (Cursor)closeable;
                boolean bl3 = false;
                if (it.moveToFirst()) {
                    this.type = it.getString(it.getColumnIndex("mime_type"));
                    this.flags = it.getInt(it.getColumnIndex("flags"));
                    this.name = it.getString(it.getColumnIndex("_display_name"));
                    this.lastModified = it.getLong(it.getColumnIndex("last_modified"));
                    this.length = it.getLong(it.getColumnIndex("_size"));
                    this.documentID = it.getString(it.getColumnIndex("document_id"));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }
}

