/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.mybatis.core.handler;

import cn.hutool.core.collection.CollUtil;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.apache.ibatis.type.TypeHandler;
import xyz.migoo.framework.common.util.string.StrUtils;

@MappedJdbcTypes(value={JdbcType.VARCHAR})
@MappedTypes(value={List.class})
public class IntegerListTypeHandler
implements TypeHandler<List<Integer>> {
    private static final String COMMA = ",";

    public void setParameter(PreparedStatement ps, int i, List<Integer> strings, JdbcType jdbcType) throws SQLException {
        ps.setString(i, CollUtil.join(strings, (CharSequence)COMMA));
    }

    public List<Integer> getResult(ResultSet rs, String columnName) throws SQLException {
        String value = rs.getString(columnName);
        return this.getResult(value);
    }

    public List<Integer> getResult(ResultSet rs, int columnIndex) throws SQLException {
        String value = rs.getString(columnIndex);
        return this.getResult(value);
    }

    public List<Integer> getResult(CallableStatement cs, int columnIndex) throws SQLException {
        String value = cs.getString(columnIndex);
        return this.getResult(value);
    }

    private List<Integer> getResult(String value) {
        if (value == null) {
            return null;
        }
        return StrUtils.splitToInt((String)value, (CharSequence)COMMA);
    }
}

