/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.druid.config;

import com.alibaba.druid.spring.boot.autoconfigure.properties.DruidStatProperties;
import jakarta.servlet.Filter;
import java.util.Objects;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import xyz.migoo.framework.druid.core.filter.DruidAdRemoveFilter;

@Configuration
@EnableTransactionManagement(proxyTargetClass=true)
@EnableConfigurationProperties(value={DruidStatProperties.class})
public class MiGooDataSourceAutoConfiguration {
    @Bean
    @ConditionalOnProperty(name={"spring.datasource.druid.web-stat-filter.enabled"}, havingValue="true")
    public FilterRegistrationBean<DruidAdRemoveFilter> druidAdRemoveFilterFilter(DruidStatProperties properties) {
        DruidStatProperties.StatViewServlet config = properties.getStatViewServlet();
        String pattern = Objects.nonNull(config.getUrlPattern()) ? config.getUrlPattern() : "/druid/*";
        String commonJsPattern = pattern.replaceAll("\\*", "js/common.js");
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new DruidAdRemoveFilter());
        registrationBean.addUrlPatterns(new String[]{commonJsPattern});
        return registrationBean;
    }
}

