/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.mybatis.config;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import xyz.migoo.framework.common.util.collection.SetUtils;
import xyz.migoo.framework.mybatis.core.util.JdbcUtils;
import xyz.migoo.framework.mybatis.enums.SqlConstants;

public class IdTypeEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(IdTypeEnvironmentPostProcessor.class);
    private static final String ID_TYPE_KEY = "mybatis-plus.global-config.db-config.id-type";
    private static final String DATASOURCE_DYNAMIC_KEY = "spring.datasource.dynamic";
    private static final String QUARTZ_JOB_STORE_DRIVER_KEY = "spring.quartz.properties.org.quartz.jobStore.driverDelegateClass";
    private static final Set<DbType> INPUT_ID_TYPES = SetUtils.asSet((Object[])new DbType[]{DbType.ORACLE, DbType.ORACLE_12C, DbType.POSTGRE_SQL, DbType.KINGBASE_ES, DbType.DB2, DbType.H2});

    public static DbType getDbType(ConfigurableEnvironment environment) {
        String primary = environment.getProperty("spring.datasource.dynamic.primary");
        if (StrUtil.isEmpty((CharSequence)primary)) {
            return null;
        }
        String url = environment.getProperty("spring.datasource.dynamic.datasource." + primary + ".url");
        if (StrUtil.isEmpty((CharSequence)url)) {
            return null;
        }
        return JdbcUtils.getDbType(url);
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        DbType dbType = IdTypeEnvironmentPostProcessor.getDbType(environment);
        if (dbType == null) {
            return;
        }
        this.setJobStoreDriverIfPresent(environment, dbType);
        SqlConstants.init(dbType);
        IdType idType = this.getIdType(environment);
        if (idType != IdType.NONE) {
            return;
        }
        if (INPUT_ID_TYPES.contains(dbType)) {
            this.setIdType(environment, IdType.INPUT);
            return;
        }
        this.setIdType(environment, IdType.AUTO);
    }

    public IdType getIdType(ConfigurableEnvironment environment) {
        return (IdType)environment.getProperty(ID_TYPE_KEY, IdType.class);
    }

    public void setIdType(ConfigurableEnvironment environment, IdType idType) {
        environment.getSystemProperties().put(ID_TYPE_KEY, idType);
        log.info("[setIdType][\u4fee\u6539 MyBatis Plus \u7684 idType \u4e3a({})]", (Object)idType);
    }

    public void setJobStoreDriverIfPresent(ConfigurableEnvironment environment, DbType dbType) {
        String driverClass = environment.getProperty(QUARTZ_JOB_STORE_DRIVER_KEY);
        if (StrUtil.isNotEmpty((CharSequence)driverClass)) {
            return;
        }
        switch (dbType) {
            case POSTGRE_SQL: {
                driverClass = "org.quartz.impl.jdbcjobstore.PostgreSQLDelegate";
                break;
            }
            case ORACLE: 
            case ORACLE_12C: {
                driverClass = "org.quartz.impl.jdbcjobstore.oracle.OracleDelegate";
                break;
            }
            case SQL_SERVER: 
            case SQL_SERVER2005: {
                driverClass = "org.quartz.impl.jdbcjobstore.MSSQLDelegate";
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)driverClass)) {
            environment.getSystemProperties().put(QUARTZ_JOB_STORE_DRIVER_KEY, driverClass);
        }
    }
}

