/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.mybatis.core.handler;

import cn.hutool.core.lang.Assert;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.AES;
import cn.hutool.extra.spring.SpringUtil;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class EncryptTypeHandler
extends BaseTypeHandler<String> {
    private static final String ENCRYPTOR_PROPERTY_NAME = "mybatis-plus.encryptor.password";
    private static AES aes;

    public void setNonNullParameter(PreparedStatement ps, int i, String parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, EncryptTypeHandler.encrypt(parameter));
    }

    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String value = rs.getString(columnName);
        return EncryptTypeHandler.decrypt(value);
    }

    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String value = rs.getString(columnIndex);
        return EncryptTypeHandler.decrypt(value);
    }

    public String getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String value = cs.getString(columnIndex);
        return EncryptTypeHandler.decrypt(value);
    }

    private static String decrypt(String value) {
        if (value == null) {
            return null;
        }
        return EncryptTypeHandler.getEncryptor().decryptStr(value);
    }

    public static String encrypt(String rawValue) {
        if (rawValue == null) {
            return null;
        }
        return EncryptTypeHandler.getEncryptor().encryptBase64(rawValue);
    }

    private static AES getEncryptor() {
        if (aes != null) {
            return aes;
        }
        String password = SpringUtil.getProperty((String)ENCRYPTOR_PROPERTY_NAME);
        Assert.notEmpty((CharSequence)password, (String)"\u914d\u7f6e\u9879({}) \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{ENCRYPTOR_PROPERTY_NAME});
        aes = SecureUtil.aes((byte[])password.getBytes());
        return aes;
    }
}

