/*
 * Decompiled with CFR 0.152.
 */
package xyz.junerver.anjicaptcha.network;

import android.content.Context;
import android.util.Log;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lxyz/junerver/anjicaptcha/network/CommonInterceptor;", "Lokhttp3/Interceptor;", "cx", "Landroid/content/Context;", "(Landroid/content/Context;)V", "utf8", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "getParamContent", "", "body", "Lokhttp3/RequestBody;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "library_release"})
public final class CommonInterceptor
implements Interceptor {
    @NotNull
    private final Context cx;
    private final Charset utf8;

    public CommonInterceptor(@NotNull Context cx) {
        Intrinsics.checkNotNullParameter((Object)cx, (String)"cx");
        this.cx = cx;
        this.utf8 = Charset.forName("UTF-8");
    }

    @Nullable
    public Response intercept(@Nullable Interceptor.Chain chain) {
        MediaType contentType;
        BufferedSource source;
        ResponseBody responseBody;
        Interceptor.Chain chain2 = chain;
        Request request = chain2 != null ? chain2.request() : null;
        JsonParser jsonParser = new JsonParser();
        Request request2 = request;
        Object object = request2 != null ? request2.body() : null;
        Intrinsics.checkNotNull((Object)object);
        JsonElement originalJsonElement = jsonParser.parse(this.getParamContent((RequestBody)object));
        Log.e((String)"\u8bf7\u6c42\u53c2\u6570", (String)originalJsonElement.toString());
        RequestBody requestBody = request.body();
        Intrinsics.checkNotNull((Object)requestBody);
        RequestBody newRequestBody = RequestBody.create((MediaType)requestBody.contentType(), (String)originalJsonElement.toString());
        Request newRequest = request.newBuilder().header("Accept-Language", "zh-cn,zh").method(request.method(), newRequestBody).build();
        Response response = chain.proceed(newRequest);
        ResponseBody responseBody2 = responseBody = response.body();
        Long contentLength = responseBody2 != null ? Long.valueOf(responseBody2.contentLength()) : null;
        ResponseBody responseBody3 = responseBody;
        BufferedSource bufferedSource = source = responseBody3 != null ? responseBody3.source() : null;
        if (bufferedSource != null) {
            bufferedSource.request(Long.MAX_VALUE);
        }
        BufferedSource bufferedSource2 = source;
        Buffer buffer = bufferedSource2 != null ? bufferedSource2.buffer() : null;
        Charset charset = this.utf8;
        ResponseBody responseBody4 = responseBody;
        Object object2 = contentType = responseBody4 != null ? responseBody4.contentType() : null;
        if (contentType != null) {
            charset = contentType.charset(this.utf8);
        }
        Long l = contentLength;
        long l2 = 0L;
        if (l != null && l == l2) {
            return response;
        }
        JSONObject jsonObject = null;
        try {
            String string;
            Buffer buffer2 = buffer;
            if (buffer2 != null && (buffer2 = buffer2.clone()) != null) {
                Charset charset2 = charset;
                Intrinsics.checkNotNull((Object)charset2);
                string = buffer2.readString(charset2);
            } else {
                string = null;
            }
            jsonObject = new JSONObject(string);
        }
        catch (JSONException e) {
            return response;
        }
        String code = null;
        String msg = null;
        try {
            String string = jsonObject.getString("repCode");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.getString(\"repCode\")");
            code = string;
            String string2 = jsonObject.getString("repMsg");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jsonObject.getString(\"repMsg\")");
            msg = string2;
        }
        catch (Exception e) {
            return response;
        }
        return response;
    }

    private final String getParamContent(RequestBody body) throws IOException {
        Buffer buffer = new Buffer();
        body.writeTo((BufferedSink)buffer);
        String string = buffer.readUtf8();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.readUtf8()");
        return string;
    }
}

