/*
 * Decompiled with CFR 0.152.
 */
package xyz.haff.testcontainers.customizer;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import xyz.haff.testcontainers.annotation.MongoContainerTest;
import xyz.haff.testcontainers.annotation.RabbitContainerTest;
import xyz.haff.testcontainers.annotation.RedisContainerTest;
import xyz.haff.testcontainers.annotation.RedisStackContainerTest;
import xyz.haff.testcontainers.customizer.MongoContainerTestContextCustomizer;
import xyz.haff.testcontainers.customizer.RabbitContainerContextCustomizer;
import xyz.haff.testcontainers.customizer.RedisContainerContextCustomizer;
import xyz.haff.testcontainers.customizer.RedisStackContainerContextCustomizer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a8\u0006\n"}, d2={"Lxyz/haff/testcontainers/customizer/TestcontainersContextCustomizerFactory;", "Lorg/springframework/test/context/ContextCustomizerFactory;", "()V", "createContextCustomizer", "Lorg/springframework/test/context/ContextCustomizer;", "testClass", "Ljava/lang/Class;", "configAttributes", "", "Lorg/springframework/test/context/ContextConfigurationAttributes;", "spring-testcontainers-annotations"})
public final class TestcontainersContextCustomizerFactory
implements ContextCustomizerFactory {
    @Nullable
    public ContextCustomizer createContextCustomizer(@NotNull Class<?> testClass, @NotNull List<ContextConfigurationAttributes> configAttributes) {
        ContextCustomizer contextCustomizer;
        Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
        Intrinsics.checkNotNullParameter(configAttributes, (String)"configAttributes");
        if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)testClass, MongoContainerTest.class)) {
            Annotation annotation = AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)testClass, MongoContainerTest.class);
            Intrinsics.checkNotNull((Object)annotation);
            MongoContainerTest annotation2 = (MongoContainerTest)annotation;
            contextCustomizer = new MongoContainerTestContextCustomizer(annotation2);
        } else if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)testClass, RedisContainerTest.class)) {
            Annotation annotation = AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)testClass, RedisContainerTest.class);
            Intrinsics.checkNotNull((Object)annotation);
            RedisContainerTest annotation3 = (RedisContainerTest)annotation;
            contextCustomizer = new RedisContainerContextCustomizer(annotation3);
        } else if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)testClass, RedisStackContainerTest.class)) {
            Annotation annotation = AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)testClass, RedisStackContainerTest.class);
            Intrinsics.checkNotNull((Object)annotation);
            RedisStackContainerTest annotation4 = (RedisStackContainerTest)annotation;
            contextCustomizer = new RedisStackContainerContextCustomizer(annotation4);
        } else if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)testClass, RabbitContainerTest.class)) {
            Annotation annotation = AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)testClass, RabbitContainerTest.class);
            Intrinsics.checkNotNull((Object)annotation);
            RabbitContainerTest annotation5 = (RabbitContainerTest)annotation;
            contextCustomizer = new RabbitContainerContextCustomizer(annotation5);
        } else {
            contextCustomizer = null;
        }
        return contextCustomizer;
    }
}

