/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.EventLog;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.FeePayerSignaturesObj;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.Signature;

@Schema(description="Transaction receipt")
public class TransactionReceipt {
    @SerializedName(value="blockHash")
    private String blockHash = null;
    @SerializedName(value="blockNumber")
    private String blockNumber = null;
    @SerializedName(value="codeFormat")
    private String codeFormat = null;
    @SerializedName(value="contractAddress")
    private String contractAddress = null;
    @SerializedName(value="feePayer")
    private String feePayer = null;
    @SerializedName(value="feePayerSignatures")
    private List<FeePayerSignaturesObj> feePayerSignatures = null;
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="gas")
    private String gas = null;
    @SerializedName(value="gasPrice")
    private String gasPrice = null;
    @SerializedName(value="gasUsed")
    private String gasUsed = null;
    @SerializedName(value="hash")
    private String hash = null;
    @SerializedName(value="humanReadable")
    private Boolean humanReadable = null;
    @SerializedName(value="input")
    private String input = null;
    @SerializedName(value="logs")
    private List<EventLog> logs = null;
    @SerializedName(value="logsBloom")
    private String logsBloom = null;
    @SerializedName(value="nonce")
    private String nonce = null;
    @SerializedName(value="senderTxHash")
    private String senderTxHash = null;
    @SerializedName(value="signatures")
    private List<Signature> signatures = null;
    @SerializedName(value="status")
    private String status = null;
    @SerializedName(value="transactionHash")
    private String transactionHash = null;
    @SerializedName(value="transactionIndex")
    private String transactionIndex = null;
    @SerializedName(value="type")
    private String type = null;
    @SerializedName(value="typeInt")
    private Long typeInt = null;
    @SerializedName(value="value")
    private String value = null;
    @SerializedName(value="to")
    private String to = null;

    public TransactionReceipt blockHash(String blockHash) {
        this.blockHash = blockHash;
        return this;
    }

    @Schema(example="14636817936293177030146074812664816396601416579180189128988660352908311691532", description="Hash value of the block with the transaction.")
    public String getBlockHash() {
        return this.blockHash;
    }

    public void setBlockHash(String blockHash) {
        this.blockHash = blockHash;
    }

    public TransactionReceipt blockNumber(String blockNumber) {
        this.blockNumber = blockNumber;
        return this;
    }

    @Schema(example="11866", description="Number of the block with the transaction.")
    public String getBlockNumber() {
        return this.blockNumber;
    }

    public void setBlockNumber(String blockNumber) {
        this.blockNumber = blockNumber;
    }

    public TransactionReceipt codeFormat(String codeFormat) {
        this.codeFormat = codeFormat;
        return this;
    }

    @Schema(example="0", description="Code format of the smart contract")
    public String getCodeFormat() {
        return this.codeFormat;
    }

    public void setCodeFormat(String codeFormat) {
        this.codeFormat = codeFormat;
    }

    public TransactionReceipt contractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
        return this;
    }

    @Schema(example="60090594560844967929797646158504130362737523169", description="Contract address. Has `null` if it's not contract deployment.")
    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public TransactionReceipt feePayer(String feePayer) {
        this.feePayer = feePayer;
        return this;
    }

    @Schema(example="763432954551381522585311052201016684070466679514", description="Account address to pay transaction fee on behalf.")
    public String getFeePayer() {
        return this.feePayer;
    }

    public void setFeePayer(String feePayer) {
        this.feePayer = feePayer;
    }

    public TransactionReceipt feePayerSignatures(List<FeePayerSignaturesObj> feePayerSignatures) {
        this.feePayerSignatures = feePayerSignatures;
        return this;
    }

    public TransactionReceipt addFeePayerSignaturesItem(FeePayerSignaturesObj feePayerSignaturesItem) {
        if (this.feePayerSignatures == null) {
            this.feePayerSignatures = new ArrayList<FeePayerSignaturesObj>();
        }
        this.feePayerSignatures.add(feePayerSignaturesItem);
        return this;
    }

    @Schema(description="")
    public List<FeePayerSignaturesObj> getFeePayerSignatures() {
        return this.feePayerSignatures;
    }

    public void setFeePayerSignatures(List<FeePayerSignaturesObj> feePayerSignatures) {
        this.feePayerSignatures = feePayerSignatures;
    }

    public TransactionReceipt from(String from) {
        this.from = from;
        return this;
    }

    @Schema(example="552116857867048503369738286550637974226289086222", description="Klaytn account address that sent the transaction")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public TransactionReceipt gas(String gas) {
        this.gas = gas;
        return this;
    }

    @Schema(example="9000000", description="Maximum gas fee set to be used for sending the transaction.")
    public String getGas() {
        return this.gas;
    }

    public void setGas(String gas) {
        this.gas = gas;
    }

    public TransactionReceipt gasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
        return this;
    }

    @Schema(example="25000000000", description="Maximum gas fee set to be used for sending the transaction.")
    public String getGasPrice() {
        return this.gasPrice;
    }

    public void setGasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
    }

    public TransactionReceipt gasUsed(String gasUsed) {
        this.gasUsed = gasUsed;
        return this;
    }

    @Schema(example="155111", description="Gas fee used for sending the transaction.")
    public String getGasUsed() {
        return this.gasUsed;
    }

    public void setGasUsed(String gasUsed) {
        this.gasUsed = gasUsed;
    }

    public TransactionReceipt hash(String hash) {
        this.hash = hash;
        return this;
    }

    @Schema(example="27626110876607162090549052339639871133320126093533539830613183745319131652898", description="Transaction data hash.")
    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public TransactionReceipt humanReadable(Boolean humanReadable) {
        this.humanReadable = humanReadable;
        return this;
    }

    @Schema(example="false", description="Shows whether the account address is`humanReadable`.")
    public Boolean isHumanReadable() {
        return this.humanReadable;
    }

    public void setHumanReadable(Boolean humanReadable) {
        this.humanReadable = humanReadable;
    }

    public TransactionReceipt input(String input) {
        this.input = input;
        return this;
    }

    @Schema(example="580287299737565567628489557492757204895646568890939015285620570035592757743967908856804894971088843461568898669160635235446199246690516837470169525891165228652969731216232050820434315981933343744553267043883135573432644831710846853327980409390587281885072709725103816957555307217627011728105699968287369313146606286351821168367418818449795969393003480596798768558853555279198415544561108598415883792066756170378207593660264527269102015395636982372818098189751816675320091461991339299650193684409392215302466468436921918400285386647246540178208929890057351547269243098731141856688778727709574582242688514258297406650844727495490893494391090367377053488497542467057543102803919697151796430781111073302219081893058337917046903338603705945694764711308218662953", description="Data that is sent along with the transaction and is used for execution.")
    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public TransactionReceipt logs(List<EventLog> logs) {
        this.logs = logs;
        return this;
    }

    public TransactionReceipt addLogsItem(EventLog logsItem) {
        if (this.logs == null) {
            this.logs = new ArrayList<EventLog>();
        }
        this.logs.add(logsItem);
        return this;
    }

    @Schema(description="")
    public List<EventLog> getLogs() {
        return this.logs;
    }

    public void setLogs(List<EventLog> logs) {
        this.logs = logs;
    }

    public TransactionReceipt logsBloom(String logsBloom) {
        this.logsBloom = logsBloom;
        return this;
    }

    @Schema(example="0", description="Bloom filter to search the log more quickly.")
    public String getLogsBloom() {
        return this.logsBloom;
    }

    public void setLogsBloom(String logsBloom) {
        this.logsBloom = logsBloom;
    }

    public TransactionReceipt nonce(String nonce) {
        this.nonce = nonce;
        return this;
    }

    @Schema(example="0", description="Number of transactions sent by the sender of the current transaction.")
    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public TransactionReceipt senderTxHash(String senderTxHash) {
        this.senderTxHash = senderTxHash;
        return this;
    }

    @Schema(example="786481204499702966100809465355223532598441495072191952226252067521607287775", description="Transaction hash value without Fee Delegation account address and signature")
    public String getSenderTxHash() {
        return this.senderTxHash;
    }

    public void setSenderTxHash(String senderTxHash) {
        this.senderTxHash = senderTxHash;
    }

    public TransactionReceipt signatures(List<Signature> signatures) {
        this.signatures = signatures;
        return this;
    }

    public TransactionReceipt addSignaturesItem(Signature signaturesItem) {
        if (this.signatures == null) {
            this.signatures = new ArrayList<Signature>();
        }
        this.signatures.add(signaturesItem);
        return this;
    }

    @Schema(description="")
    public List<Signature> getSignatures() {
        return this.signatures;
    }

    public void setSignatures(List<Signature> signatures) {
        this.signatures = signatures;
    }

    public TransactionReceipt status(String status) {
        this.status = status;
        return this;
    }

    @Schema(example="Committed", description="Status of the transaction. If the transaction is still in the txpool, it returns `Pending`. A successful transaction returns `Committed`, and failed transaction returns `CommitError`.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public TransactionReceipt transactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
        return this;
    }

    @Schema(example="27626110876607162090549052339639871133320126093533539830613183745319131652898", description="Transaction hash")
    public String getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public TransactionReceipt transactionIndex(String transactionIndex) {
        this.transactionIndex = transactionIndex;
        return this;
    }

    @Schema(example="0", description="Order of the transaction within the block that contains it")
    public String getTransactionIndex() {
        return this.transactionIndex;
    }

    public void setTransactionIndex(String transactionIndex) {
        this.transactionIndex = transactionIndex;
    }

    public TransactionReceipt type(String type) {
        this.type = type;
        return this;
    }

    @Schema(example="TxTypeFeeDelegatedSmartContractDeploy", description="Characters that represents the transaction type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public TransactionReceipt typeInt(Long typeInt) {
        this.typeInt = typeInt;
        return this;
    }

    @Schema(example="41", description="Integer that represents the transaction type")
    public Long getTypeInt() {
        return this.typeInt;
    }

    public void setTypeInt(Long typeInt) {
        this.typeInt = typeInt;
    }

    public TransactionReceipt value(String value) {
        this.value = value;
        return this;
    }

    @Schema(example="0", description="KLAY converted into PEB")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public TransactionReceipt to(String to) {
        this.to = to;
        return this;
    }

    @Schema(example="5756256894954735614023181930295859341153128076", required=true, description="Klaytn account address or Contract address to receive KLAY")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionReceipt transactionReceipt = (TransactionReceipt)o;
        return Objects.equals(this.blockHash, transactionReceipt.blockHash) && Objects.equals(this.blockNumber, transactionReceipt.blockNumber) && Objects.equals(this.codeFormat, transactionReceipt.codeFormat) && Objects.equals(this.contractAddress, transactionReceipt.contractAddress) && Objects.equals(this.feePayer, transactionReceipt.feePayer) && Objects.equals(this.feePayerSignatures, transactionReceipt.feePayerSignatures) && Objects.equals(this.from, transactionReceipt.from) && Objects.equals(this.gas, transactionReceipt.gas) && Objects.equals(this.gasPrice, transactionReceipt.gasPrice) && Objects.equals(this.gasUsed, transactionReceipt.gasUsed) && Objects.equals(this.hash, transactionReceipt.hash) && Objects.equals(this.humanReadable, transactionReceipt.humanReadable) && Objects.equals(this.input, transactionReceipt.input) && Objects.equals(this.logs, transactionReceipt.logs) && Objects.equals(this.logsBloom, transactionReceipt.logsBloom) && Objects.equals(this.nonce, transactionReceipt.nonce) && Objects.equals(this.senderTxHash, transactionReceipt.senderTxHash) && Objects.equals(this.signatures, transactionReceipt.signatures) && Objects.equals(this.status, transactionReceipt.status) && Objects.equals(this.transactionHash, transactionReceipt.transactionHash) && Objects.equals(this.transactionIndex, transactionReceipt.transactionIndex) && Objects.equals(this.type, transactionReceipt.type) && Objects.equals(this.typeInt, transactionReceipt.typeInt) && Objects.equals(this.value, transactionReceipt.value) && Objects.equals(this.to, transactionReceipt.to);
    }

    public int hashCode() {
        return Objects.hash(this.blockHash, this.blockNumber, this.codeFormat, this.contractAddress, this.feePayer, this.feePayerSignatures, this.from, this.gas, this.gasPrice, this.gasUsed, this.hash, this.humanReadable, this.input, this.logs, this.logsBloom, this.nonce, this.senderTxHash, this.signatures, this.status, this.transactionHash, this.transactionIndex, this.type, this.typeInt, this.value, this.to);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionReceipt {\n");
        sb.append("    blockHash: ").append(this.toIndentedString(this.blockHash)).append("\n");
        sb.append("    blockNumber: ").append(this.toIndentedString(this.blockNumber)).append("\n");
        sb.append("    codeFormat: ").append(this.toIndentedString(this.codeFormat)).append("\n");
        sb.append("    contractAddress: ").append(this.toIndentedString(this.contractAddress)).append("\n");
        sb.append("    feePayer: ").append(this.toIndentedString(this.feePayer)).append("\n");
        sb.append("    feePayerSignatures: ").append(this.toIndentedString(this.feePayerSignatures)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    gas: ").append(this.toIndentedString(this.gas)).append("\n");
        sb.append("    gasPrice: ").append(this.toIndentedString(this.gasPrice)).append("\n");
        sb.append("    gasUsed: ").append(this.toIndentedString(this.gasUsed)).append("\n");
        sb.append("    hash: ").append(this.toIndentedString(this.hash)).append("\n");
        sb.append("    humanReadable: ").append(this.toIndentedString(this.humanReadable)).append("\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("    logs: ").append(this.toIndentedString(this.logs)).append("\n");
        sb.append("    logsBloom: ").append(this.toIndentedString(this.logsBloom)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    senderTxHash: ").append(this.toIndentedString(this.senderTxHash)).append("\n");
        sb.append("    signatures: ").append(this.toIndentedString(this.signatures)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    transactionHash: ").append(this.toIndentedString(this.transactionHash)).append("\n");
        sb.append("    transactionIndex: ").append(this.toIndentedString(this.transactionIndex)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    typeInt: ").append(this.toIndentedString(this.typeInt)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

