/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Legacy transaction request schema.")
public class LegacyTransactionRequest {
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="value")
    private String value = null;
    @SerializedName(value="input")
    private String input = null;
    @SerializedName(value="nonce")
    private Long nonce = null;
    @SerializedName(value="gas")
    private Long gas = 100000L;
    @SerializedName(value="submit")
    private Boolean submit = null;
    @SerializedName(value="to")
    private String to = null;

    public LegacyTransactionRequest from(String from) {
        this.from = from;
        return this;
    }

    @Schema(example="552714228230442729489415054454372803633806727088", required=true, description="KLAY sender's Klaytn account address")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public LegacyTransactionRequest value(String value) {
        this.value = value;
        return this;
    }

    @Schema(example="0", description="KLAY converted into PEB")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public LegacyTransactionRequest input(String input) {
        this.input = input;
        return this;
    }

    @Schema(example="1356724339460790347155208131747480809853566811741822039125651530969918933560069969217959844027660620225237232058730833124318593446246154420597790585299812485169152", description="Data that is sent along with the transaction and used for the execution.")
    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public LegacyTransactionRequest nonce(Long nonce) {
        this.nonce = nonce;
        return this;
    }

    @Schema(example="0", description="Unique identifier for the transactions being sent.(By entering 0, the nonce will be automatically determined.)")
    public Long getNonce() {
        return this.nonce;
    }

    public void setNonce(Long nonce) {
        this.nonce = nonce;
    }

    public LegacyTransactionRequest gas(Long gas) {
        this.gas = gas;
        return this;
    }

    @Schema(example="0", description="Maximum gas fee to be used for sending the transaction. (By entering 0, it will be set to default value) ")
    public Long getGas() {
        return this.gas;
    }

    public void setGas(Long gas) {
        this.gas = gas;
    }

    public LegacyTransactionRequest submit(Boolean submit) {
        this.submit = submit;
        return this;
    }

    @Schema(example="true", description="Send or not send the transaction to Klaytn")
    public Boolean isSubmit() {
        return this.submit;
    }

    public void setSubmit(Boolean submit) {
        this.submit = submit;
    }

    public LegacyTransactionRequest to(String to) {
        this.to = to;
        return this;
    }

    @Schema(example="458589992856735687761939783085233253254964399530", description="KLAY receiver's Klaytn account address")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegacyTransactionRequest legacyTransactionRequest = (LegacyTransactionRequest)o;
        return Objects.equals(this.from, legacyTransactionRequest.from) && Objects.equals(this.value, legacyTransactionRequest.value) && Objects.equals(this.input, legacyTransactionRequest.input) && Objects.equals(this.nonce, legacyTransactionRequest.nonce) && Objects.equals(this.gas, legacyTransactionRequest.gas) && Objects.equals(this.submit, legacyTransactionRequest.submit) && Objects.equals(this.to, legacyTransactionRequest.to);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.value, this.input, this.nonce, this.gas, this.submit, this.to);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LegacyTransactionRequest {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    gas: ").append(this.toIndentedString(this.gas)).append("\n");
        sb.append("    submit: ").append(this.toIndentedString(this.submit)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

