/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="RLP User Fee Delegation transaction request schema")
public class FDUserProcessRLPRequest {
    @SerializedName(value="rlp")
    private String rlp = null;
    @SerializedName(value="submit")
    private Boolean submit = null;
    @SerializedName(value="feePayer")
    private String feePayer = null;
    @SerializedName(value="feeRatio")
    private Long feeRatio = null;

    public FDUserProcessRLPRequest rlp(String rlp) {
        this.rlp = rlp;
        return this;
    }

    @Schema(example="889095813917876143351268397079828703837314014574739495786074888917234422693735025858387074589758435571718921931374280515350922805567401976157267807638139124374361487044922248554271529198078974583551598848834507592653238618839610125947506510757479231676551978799166005818943927131184670633246619831738467648995007833327339035905326552664804598178009323314594791570674009545607967067033284441209801775515400561748291514678529106610962455573456469521012269533975358143271194736260906921570756776332443700557466949720979810612109045965898264834670090636670210503443760241271922009433880679753442316860619008834113749196134031932743664506401114075940680775618526024767547074288215289803134788160526684327505467573965748092744987032909502472515925549271855015607252730227251539714782473234380118283817438884848986539753062803840799258934414221698550399029720199638227710604716345061070679096320207653491700535693672304184299239736671380927838059921286769369120071826013012110007481604199958060383689939158314942879151180897335076143385306647833787889311077480579924112077065345962167372435639541882702962137510202420611861331171552365275034796298406268165130538940441827928201256291360018726105156071270062729110802587321788560302373442213370628702059718314634619029300201", required=true, description="The Klaytn RLP formats SigRLP or TxHashRLP are accepted as RLP values and only (partial) fee delegation transaction type is allowed.")
    public String getRlp() {
        return this.rlp;
    }

    public void setRlp(String rlp) {
        this.rlp = rlp;
    }

    public FDUserProcessRLPRequest submit(Boolean submit) {
        this.submit = submit;
        return this;
    }

    @Schema(example="true", description="Shows whether to send the transaction to Klaytn")
    public Boolean isSubmit() {
        return this.submit;
    }

    public void setSubmit(Boolean submit) {
        this.submit = submit;
    }

    public FDUserProcessRLPRequest feePayer(String feePayer) {
        this.feePayer = feePayer;
        return this;
    }

    @Schema(example="415487481437216765516808935831180170585317837885", required=true, description="Account address for user Fee Delegation")
    public String getFeePayer() {
        return this.feePayer;
    }

    public void setFeePayer(String feePayer) {
        this.feePayer = feePayer;
    }

    public FDUserProcessRLPRequest feeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
        return this;
    }

    @Schema(example="20", description="The ratio of the gas fee to be delegated. When it's empty or 0, the entire fee will be delegated.")
    public Long getFeeRatio() {
        return this.feeRatio;
    }

    public void setFeeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FDUserProcessRLPRequest fdUserProcessRLPRequest = (FDUserProcessRLPRequest)o;
        return Objects.equals(this.rlp, fdUserProcessRLPRequest.rlp) && Objects.equals(this.submit, fdUserProcessRLPRequest.submit) && Objects.equals(this.feePayer, fdUserProcessRLPRequest.feePayer) && Objects.equals(this.feeRatio, fdUserProcessRLPRequest.feeRatio);
    }

    public int hashCode() {
        return Objects.hash(this.rlp, this.submit, this.feePayer, this.feeRatio);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FDUserProcessRLPRequest {\n");
        sb.append("    rlp: ").append(this.toIndentedString(this.rlp)).append("\n");
        sb.append("    submit: ").append(this.toIndentedString(this.submit)).append("\n");
        sb.append("    feePayer: ").append(this.toIndentedString(this.feePayer)).append("\n");
        sb.append("    feeRatio: ").append(this.toIndentedString(this.feeRatio)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

