/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.Kip7FeePayerOptions;

public class DeployKip7ContractRequest {
    @SerializedName(value="alias")
    private String alias = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="symbol")
    private String symbol = null;
    @SerializedName(value="decimals")
    private Long decimals = null;
    @SerializedName(value="initialSupply")
    private String initialSupply = null;
    @SerializedName(value="options")
    private Kip7FeePayerOptions options = null;

    public DeployKip7ContractRequest alias(String alias) {
        this.alias = alias;
        return this;
    }

    @Schema(example="mycontract", required=true, description="The alias of the contract. When using KIP-7 API, you can use the contract alias in place of the address. The alias must only consist of lowercase letters, numbers and hyphens, and the first letter is restricted to a lowercase letter.")
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public DeployKip7ContractRequest name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="MyKIP7", required=true, description="Contract name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DeployKip7ContractRequest symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Schema(example="MSK7", required=true, description="Token symbol")
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public DeployKip7ContractRequest decimals(Long decimals) {
        this.decimals = decimals;
        return this;
    }

    @Schema(example="8", description="The number of digits that come after the decimal place when displaying token values on-screen. The default value is `0`.")
    public Long getDecimals() {
        return this.decimals;
    }

    public void setDecimals(Long decimals) {
        this.decimals = decimals;
    }

    public DeployKip7ContractRequest initialSupply(String initialSupply) {
        this.initialSupply = initialSupply;
        return this;
    }

    @Schema(example="256", required=true, description="Initial supply (in hex.)")
    public String getInitialSupply() {
        return this.initialSupply;
    }

    public void setInitialSupply(String initialSupply) {
        this.initialSupply = initialSupply;
    }

    public DeployKip7ContractRequest options(Kip7FeePayerOptions options) {
        this.options = options;
        return this;
    }

    @Schema(description="")
    public Kip7FeePayerOptions getOptions() {
        return this.options;
    }

    public void setOptions(Kip7FeePayerOptions options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeployKip7ContractRequest deployKip7ContractRequest = (DeployKip7ContractRequest)o;
        return Objects.equals(this.alias, deployKip7ContractRequest.alias) && Objects.equals(this.name, deployKip7ContractRequest.name) && Objects.equals(this.symbol, deployKip7ContractRequest.symbol) && Objects.equals(this.decimals, deployKip7ContractRequest.decimals) && Objects.equals(this.initialSupply, deployKip7ContractRequest.initialSupply) && Objects.equals(this.options, deployKip7ContractRequest.options);
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.name, this.symbol, this.decimals, this.initialSupply, this.options);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeployKip7ContractRequest {\n");
        sb.append("    alias: ").append(this.toIndentedString(this.alias)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("    decimals: ").append(this.toIndentedString(this.decimals)).append("\n");
        sb.append("    initialSupply: ").append(this.toIndentedString(this.initialSupply)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

