/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.Kip17FeePayerOptions;

public class DeployKip17ContractRequest {
    @SerializedName(value="alias")
    private String alias = null;
    @SerializedName(value="symbol")
    private String symbol = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="options")
    private Kip17FeePayerOptions options = null;

    public DeployKip17ContractRequest alias(String alias) {
        this.alias = alias;
        return this;
    }

    @Schema(example="test-contract", required=true, description="The alias of the contract. When using KIP-17 API, you can use the contract alias in place of the address. The alias must only consist of lowercase letters, numbers and hyphens, and the first letter is restricted to a lowercase letter.<p></p>")
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public DeployKip17ContractRequest symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Schema(example="TEST", required=true, description="The contract symbol. It usually consists of 3-4 uppercase letters.")
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public DeployKip17ContractRequest name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="Test NFT", required=true, description="The contract name. It can contain lowercase and uppercase letters, numbers and hyphens.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DeployKip17ContractRequest options(Kip17FeePayerOptions options) {
        this.options = options;
        return this;
    }

    @Schema(description="")
    public Kip17FeePayerOptions getOptions() {
        return this.options;
    }

    public void setOptions(Kip17FeePayerOptions options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeployKip17ContractRequest deployKip17ContractRequest = (DeployKip17ContractRequest)o;
        return Objects.equals(this.alias, deployKip17ContractRequest.alias) && Objects.equals(this.symbol, deployKip17ContractRequest.symbol) && Objects.equals(this.name, deployKip17ContractRequest.name) && Objects.equals(this.options, deployKip17ContractRequest.options);
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.symbol, this.name, this.options);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeployKip17ContractRequest {\n");
        sb.append("    alias: ").append(this.toIndentedString(this.alias)).append("\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

