/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiCallback;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiClient;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiException;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.Configuration;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.Pair;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ProgressRequestBody;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ProgressResponseBody;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.DeployKip17ContractRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.Kip17ContractInfoResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.Kip17ContractListResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.Kip17DeployResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.UpdateKip17ContractRequest;

public class Kip17ContractApi {
    private ApiClient apiClient;

    public Kip17ContractApi() {
        this(Configuration.getDefaultApiClient());
    }

    public Kip17ContractApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deployContractCall(String xChainId, DeployKip17ContractRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DeployKip17ContractRequest localVarPostBody = body;
        String localVarPath = "/v1/contract";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deployContractValidateBeforeCall(String xChainId, DeployKip17ContractRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling deployContract(Async)");
        }
        Call call = this.deployContractCall(xChainId, body, progressListener, progressRequestListener);
        return call;
    }

    public Kip17DeployResponse deployContract(String xChainId, DeployKip17ContractRequest body) throws ApiException {
        ApiResponse<Kip17DeployResponse> resp = this.deployContractWithHttpInfo(xChainId, body);
        return resp.getData();
    }

    public ApiResponse<Kip17DeployResponse> deployContractWithHttpInfo(String xChainId, DeployKip17ContractRequest body) throws ApiException {
        Call call = this.deployContractValidateBeforeCall(xChainId, body, null, null);
        Type localVarReturnType = new TypeToken<Kip17DeployResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deployContractAsync(String xChainId, DeployKip17ContractRequest body, final ApiCallback<Kip17DeployResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deployContractValidateBeforeCall(xChainId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip17DeployResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getContractCall(String xChainId, String contractAddressOrAlias, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/contract/{contract-address-or-alias}".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getContractValidateBeforeCall(String xChainId, String contractAddressOrAlias, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling getContract(Async)");
        }
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling getContract(Async)");
        }
        Call call = this.getContractCall(xChainId, contractAddressOrAlias, progressListener, progressRequestListener);
        return call;
    }

    public Kip17ContractInfoResponse getContract(String xChainId, String contractAddressOrAlias) throws ApiException {
        ApiResponse<Kip17ContractInfoResponse> resp = this.getContractWithHttpInfo(xChainId, contractAddressOrAlias);
        return resp.getData();
    }

    public ApiResponse<Kip17ContractInfoResponse> getContractWithHttpInfo(String xChainId, String contractAddressOrAlias) throws ApiException {
        Call call = this.getContractValidateBeforeCall(xChainId, contractAddressOrAlias, null, null);
        Type localVarReturnType = new TypeToken<Kip17ContractInfoResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getContractAsync(String xChainId, String contractAddressOrAlias, final ApiCallback<Kip17ContractInfoResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getContractValidateBeforeCall(xChainId, contractAddressOrAlias, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip17ContractInfoResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listContractsInDeployerPoolCall(String xChainId, String size, String cursor, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/contract";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (size != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("size", size));
        }
        if (cursor != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("cursor", cursor));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listContractsInDeployerPoolValidateBeforeCall(String xChainId, String size, String cursor, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling listContractsInDeployerPool(Async)");
        }
        Call call = this.listContractsInDeployerPoolCall(xChainId, size, cursor, progressListener, progressRequestListener);
        return call;
    }

    public Kip17ContractListResponse listContractsInDeployerPool(String xChainId, String size, String cursor) throws ApiException {
        ApiResponse<Kip17ContractListResponse> resp = this.listContractsInDeployerPoolWithHttpInfo(xChainId, size, cursor);
        return resp.getData();
    }

    public ApiResponse<Kip17ContractListResponse> listContractsInDeployerPoolWithHttpInfo(String xChainId, String size, String cursor) throws ApiException {
        Call call = this.listContractsInDeployerPoolValidateBeforeCall(xChainId, size, cursor, null, null);
        Type localVarReturnType = new TypeToken<Kip17ContractListResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listContractsInDeployerPoolAsync(String xChainId, String size, String cursor, final ApiCallback<Kip17ContractListResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listContractsInDeployerPoolValidateBeforeCall(xChainId, size, cursor, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip17ContractListResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateContractCall(String xChainId, String contractAddressOrAlias, UpdateKip17ContractRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdateKip17ContractRequest localVarPostBody = body;
        String localVarPath = "/v1/contract/{contract-address-or-alias}".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateContractValidateBeforeCall(String xChainId, String contractAddressOrAlias, UpdateKip17ContractRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling updateContract(Async)");
        }
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling updateContract(Async)");
        }
        Call call = this.updateContractCall(xChainId, contractAddressOrAlias, body, progressListener, progressRequestListener);
        return call;
    }

    public Kip17ContractInfoResponse updateContract(String xChainId, String contractAddressOrAlias, UpdateKip17ContractRequest body) throws ApiException {
        ApiResponse<Kip17ContractInfoResponse> resp = this.updateContractWithHttpInfo(xChainId, contractAddressOrAlias, body);
        return resp.getData();
    }

    public ApiResponse<Kip17ContractInfoResponse> updateContractWithHttpInfo(String xChainId, String contractAddressOrAlias, UpdateKip17ContractRequest body) throws ApiException {
        Call call = this.updateContractValidateBeforeCall(xChainId, contractAddressOrAlias, body, null, null);
        Type localVarReturnType = new TypeToken<Kip17ContractInfoResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateContractAsync(String xChainId, String contractAddressOrAlias, UpdateKip17ContractRequest body, final ApiCallback<Kip17ContractInfoResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateContractValidateBeforeCall(xChainId, contractAddressOrAlias, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip17ContractInfoResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

