/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.kas.wallet;

import com.klaytn.caver.account.Account;
import com.klaytn.caver.account.AccountKeyWeightedMultiSig;
import com.klaytn.caver.contract.SendOptions;
import com.klaytn.caver.methods.response.Quantity;
import com.klaytn.caver.rpc.RPC;
import com.klaytn.caver.transaction.type.FeeDelegatedAccountUpdate;
import com.klaytn.caver.wallet.keyring.AbstractKeyring;
import com.klaytn.caver.wallet.keyring.KeyringFactory;
import com.squareup.okhttp.Call;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.web3j.utils.Numeric;
import xyz.groundx.caver_ext_kas.kas.utils.KASUtils;
import xyz.groundx.caver_ext_kas.kas.wallet.WalletQueryOptions;
import xyz.groundx.caver_ext_kas.kas.wallet.accountkey.KeyTypeMultiSig;
import xyz.groundx.caver_ext_kas.kas.wallet.accountkey.KeyTypePublic;
import xyz.groundx.caver_ext_kas.kas.wallet.accountkey.KeyTypeRoleBased;
import xyz.groundx.caver_ext_kas.kas.wallet.migration.MigrationAccount;
import xyz.groundx.caver_ext_kas.kas.wallet.migration.MigrationAccountKey;
import xyz.groundx.caver_ext_kas.kas.wallet.migration.MultisigPrivateKeys;
import xyz.groundx.caver_ext_kas.kas.wallet.migration.RoleBasedPrivateKeys;
import xyz.groundx.caver_ext_kas.kas.wallet.migration.SinglePrivateKey;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiCallback;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiClient;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiException;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.api.AccountApi;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.api.BasicTxApi;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.api.FdtxKasApi;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.api.FdtxUserApi;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.api.FeepayerApi;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.api.KeyApi;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.api.MultisigTxApi;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.api.RegistrationApi;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.api.StatisticsApi;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.api.TxHistoryApi;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.AccountCountByAccountID;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.AccountCountByKRN;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.AccountRegistration;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.AccountRegistrationRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.AccountStatus;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.AccountSummary;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.AccountUpdateTransactionRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.Accounts;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.AccountsByPubkey;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.AnchorTransactionRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.CallArgument;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.CancelTransactionRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.ContractCallData;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.ContractCallRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.ContractCallResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.ContractDeployTransactionRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.ContractExecutionTransactionRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.CreateFeePayerAccountRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.EmptyUpdateKeyType;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.FDAccountUpdateTransactionRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.FDAnchorTransactionRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.FDCancelTransactionRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.FDContractDeployTransactionRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.FDContractExecutionTransactionRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.FDProcessRLPRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.FDTransactionResult;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.FDTransactionWithCurrencyResult;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.FDTransactionWithCurrencyResultList;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.FDUserAccountUpdateTransactionRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.FDUserAnchorTransactionRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.FDUserCancelTransactionRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.FDUserContractDeployTransactionRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.FDUserContractExecutionTransactionRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.FDUserProcessRLPRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.FDUserValueTransferTransactionRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.FDValueTransferTransactionRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.Key;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.KeyCreationRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.KeyCreationResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.KeyList;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.KeySignDataRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.KeySignDataResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.KeyStatus;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.LegacyTransactionRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.MultisigAccount;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.MultisigAccountUpdateRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.MultisigKey;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.MultisigTransactionStatus;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.MultisigTransactions;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.MultisigUpdateKey;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.MultisigUpdateKeyType;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.OneOfAccountUpdateTransactionRequestAccountKey;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.OneOfFDAccountUpdateTransactionRequestAccountKey;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.OneOfFDUserAccountUpdateTransactionRequestAccountKey;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.OneOfRoleBasedUpdateKeyTypeKeyItems;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.ProcessRLPRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.PubkeyUpdateKeyType;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.RegistrationStatusResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.RoleBasedUpdateKeyType;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.SignPendingTransactionBySigRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.Signature;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.TransactionReceipt;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.TransactionResult;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.ValueTransferTransactionRequest;

public class Wallet {
    AccountApi accountApi;
    BasicTxApi basicTransactionApi;
    FdtxKasApi feeDelegatedTransactionPaidByKasApi;
    FdtxUserApi feeDelegatedTransactionPaidByUserApi;
    MultisigTxApi multisigTransactionManagementApi;
    StatisticsApi statisticsApi;
    KeyApi keyApi;
    RegistrationApi registrationApi;
    FeepayerApi feepayerApi;
    TxHistoryApi transactionHistoryApi;
    String chainId;
    ApiClient apiClient;
    RPC rpc;
    private boolean nodeAPIInitialized;

    public Wallet(String chainId, ApiClient walletApiClient) {
        this.setChainId(chainId);
        this.setApiClient(walletApiClient);
    }

    public RegistrationStatusResponse migrateAccounts(List<MigrationAccount> accountsToBeMigrated) throws ApiException, IOException {
        if (!this.nodeAPIInitialized) {
            throw new RuntimeException("You should initialize Node API with working url(e.g. https://node-api.klaytnapi.com/v1/klaytn) first.");
        }
        for (int i = 0; i < accountsToBeMigrated.size(); ++i) {
            this.validateMigrationAccount(accountsToBeMigrated.get(i));
        }
        AccountRegistrationRequest request = new AccountRegistrationRequest();
        KeyCreationResponse keyCreationResponse = this.createKeys(accountsToBeMigrated.size());
        List<Key> createdKeys = keyCreationResponse.getItems();
        String gasPrice = (String)((Quantity)this.rpc.klay.getGasPrice().send()).getResult();
        for (int i = 0; i < createdKeys.size(); ++i) {
            MigrationAccount accountToBeMigrated = accountsToBeMigrated.get(i);
            Key newKey = createdKeys.get(i);
            FeeDelegatedAccountUpdate tx = ((FeeDelegatedAccountUpdate.Builder)((FeeDelegatedAccountUpdate.Builder)((FeeDelegatedAccountUpdate.Builder)((FeeDelegatedAccountUpdate.Builder)((FeeDelegatedAccountUpdate.Builder)((FeeDelegatedAccountUpdate.Builder)new FeeDelegatedAccountUpdate.Builder().setChainId(BigInteger.valueOf(Integer.parseInt(this.chainId)))).setFrom(accountToBeMigrated.getAddress())).setNonce(accountToBeMigrated.getNonce())).setAccount(Account.createWithAccountKeyPublic((String)accountToBeMigrated.getAddress(), (String)newKey.getPublicKey())).setGas(BigInteger.valueOf(1000000L))).setGasPrice(gasPrice)).setKlaytnCall(this.rpc.getKlay())).build();
            AbstractKeyring keyring = this.createKeyringFromMigrationAccount(accountToBeMigrated);
            tx.sign(keyring);
            AccountRegistration accountRegistration = new AccountRegistration();
            accountRegistration.setKeyId(newKey.getKeyId());
            accountRegistration.setAddress(keyring.getAddress());
            accountRegistration.setRlp(tx.getRLPEncoding());
            request.add(accountRegistration);
        }
        return this.registerAccounts(request);
    }

    public xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.Account createAccount() throws ApiException {
        return this.getAccountApi().createAccount(this.chainId);
    }

    public Call createAccountAsync(ApiCallback<xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.Account> callback) throws ApiException {
        return this.getAccountApi().createAccountAsync(this.chainId, callback);
    }

    public Accounts getAccountList() throws ApiException {
        return this.getAccountList(new WalletQueryOptions());
    }

    public Call getAccountListAsync(ApiCallback<Accounts> callback) throws ApiException {
        return this.getAccountListAsync(new WalletQueryOptions(), callback);
    }

    public Accounts getAccountList(WalletQueryOptions options) throws ApiException {
        return this.getAccountApi().retrieveAccounts(this.chainId, options.getSize(), options.getCursor(), options.getToTimestamp(), options.getFromTimestamp(), options.getStatus());
    }

    public Call getAccountListAsync(WalletQueryOptions options, ApiCallback<Accounts> callback) throws ApiException {
        return this.getAccountApi().retrieveAccountsAsync(this.chainId, options.getSize(), options.getCursor(), options.getToTimestamp(), options.getFromTimestamp(), options.getStatus(), callback);
    }

    public xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.Account getAccount(String address) throws ApiException {
        return this.getAccountApi().retrieveAccount(this.chainId, address);
    }

    public Call getAccountAsync(String address, ApiCallback<xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.Account> callback) throws ApiException {
        return this.getAccountApi().retrieveAccountAsync(this.chainId, address, callback);
    }

    public AccountStatus deleteAccount(String address) throws ApiException {
        return this.getAccountApi().deleteAccount(this.chainId, address);
    }

    public Call deleteAccountAsync(String address, ApiCallback<AccountStatus> callback) throws ApiException {
        return this.getAccountApi().deleteAccountAsync(this.chainId, address, callback);
    }

    public AccountSummary disableAccount(String address) throws ApiException {
        return this.getAccountApi().deactivateAccount(this.chainId, address);
    }

    public Call disableAccountAsync(String address, ApiCallback<AccountSummary> callback) throws ApiException {
        return this.getAccountApi().deactivateAccountAsync(this.chainId, address, callback);
    }

    public AccountSummary enableAccount(String address) throws ApiException {
        return this.getAccountApi().activateAccount(this.chainId, address);
    }

    public Call enableAccountAsync(String address, ApiCallback<AccountSummary> callback) throws ApiException {
        return this.getAccountApi().activateAccountAsync(this.chainId, address, callback);
    }

    public Signature signTransaction(String address, String transactionId) throws ApiException {
        return this.getAccountApi().signTransactionIDResponse(this.chainId, address, transactionId);
    }

    public Call signTransactionAsync(String address, String transactionId, ApiCallback<Signature> callback) throws ApiException {
        return this.getAccountApi().signTransactionIDResponseAsync(this.chainId, address, transactionId, callback);
    }

    public MultisigAccount updateToMultiSigAccount(String address, MultisigAccountUpdateRequest request) throws ApiException {
        return this.getAccountApi().multisigAccountUpdate(this.chainId, address, request);
    }

    public Call updateToMultiSigAccountAsync(String address, MultisigAccountUpdateRequest request, ApiCallback<MultisigAccount> callback) throws ApiException {
        return this.getAccountApi().multisigAccountUpdateAsync(this.chainId, address, request, callback);
    }

    public AccountsByPubkey getAccountListByPublicKey(String publicKey) throws ApiException {
        return this.getAccountApi().retrieveAccountsByPubkey(this.chainId, publicKey);
    }

    public Call getAccountListByPublicKeyAsync(String publicKey, ApiCallback<AccountsByPubkey> callback) throws ApiException {
        return this.getAccountApi().retrieveAccountsByPubkeyAsync(this.chainId, publicKey, callback);
    }

    public TransactionResult requestLegacyTransaction(LegacyTransactionRequest request) throws ApiException {
        return this.getBasicTransactionApi().legacyTransaction(this.chainId, request);
    }

    public Call requestLegacyTransactionAsync(LegacyTransactionRequest request, ApiCallback<TransactionResult> callback) throws ApiException {
        return this.getBasicTransactionApi().legacyTransactionAsync(this.chainId, request, callback);
    }

    public TransactionResult requestValueTransfer(ValueTransferTransactionRequest request) throws ApiException {
        return this.getBasicTransactionApi().valueTransferTransaction(this.chainId, request);
    }

    public Call requestValueTransferAsync(ValueTransferTransactionRequest request, ApiCallback<TransactionResult> callback) throws ApiException {
        return this.getBasicTransactionApi().valueTransferTransactionAsync(this.chainId, request, callback);
    }

    public TransactionResult requestSmartContractDeploy(ContractDeployTransactionRequest request) throws ApiException {
        return this.getBasicTransactionApi().contractDeployTransaction(this.chainId, request);
    }

    public Call requestSmartContractDeployAsync(ContractDeployTransactionRequest request, ApiCallback<TransactionResult> callback) throws ApiException {
        return this.getBasicTransactionApi().contractDeployTransactionAsync(this.chainId, request, callback);
    }

    public TransactionResult requestSmartContractExecution(ContractExecutionTransactionRequest request) throws ApiException {
        return this.getBasicTransactionApi().contractExecutionTransaction(this.chainId, request);
    }

    public Call requestSmartContractExecutionAsync(ContractExecutionTransactionRequest request, ApiCallback<TransactionResult> callback) throws ApiException {
        return this.getBasicTransactionApi().contractExecutionTransactionAsync(this.chainId, request, callback);
    }

    public TransactionResult requestCancel(CancelTransactionRequest request) throws ApiException {
        return this.getBasicTransactionApi().cancelTransaction(this.chainId, request);
    }

    public Call requestCancelAsync(CancelTransactionRequest request, ApiCallback<TransactionResult> callback) throws ApiException {
        return this.getBasicTransactionApi().cancelTransactionAsync(this.chainId, request, callback);
    }

    public TransactionResult requestChainDataAnchoring(AnchorTransactionRequest request) throws ApiException {
        return this.getBasicTransactionApi().anchorTransaction(this.chainId, request);
    }

    public Call requestChainDataAnchoringAsync(AnchorTransactionRequest request, ApiCallback<TransactionResult> callback) throws ApiException {
        return this.getBasicTransactionApi().anchorTransactionAsync(this.chainId, request, callback);
    }

    public TransactionResult requestRawTransaction(ProcessRLPRequest request) throws ApiException {
        return this.getBasicTransactionApi().processRLP(this.chainId, request);
    }

    public Call requestRawTransactionAsync(ProcessRLPRequest request, ApiCallback<TransactionResult> callback) throws ApiException {
        return this.getBasicTransactionApi().processRLPAsync(this.chainId, request, callback);
    }

    public TransactionResult requestAccountUpdate(AccountUpdateTransactionRequest request) throws ApiException {
        request.setAccountKey(this.makeUncompressedKeyFormat(request.getAccountKey()));
        return this.getBasicTransactionApi().accountUpdateTransaction(this.chainId, request);
    }

    public Call requestAccountUpdateAsync(AccountUpdateTransactionRequest request, ApiCallback<TransactionResult> callback) throws ApiException {
        request.setAccountKey(this.makeUncompressedKeyFormat(request.getAccountKey()));
        return this.getBasicTransactionApi().accountUpdateTransactionAsync(this.chainId, request, callback);
    }

    public TransactionReceipt getTransaction(String transactionHash) throws ApiException {
        return this.getBasicTransactionApi().transactionReceipt(this.chainId, transactionHash);
    }

    public Call getTransactionAsync(String transactionHash, ApiCallback<TransactionReceipt> callback) throws ApiException {
        return this.getBasicTransactionApi().transactionReceiptAsync(this.chainId, transactionHash, callback);
    }

    public FDTransactionResult requestFDValueTransferPaidByGlobalFeePayer(FDValueTransferTransactionRequest request) throws ApiException {
        return this.getFeeDelegatedTransactionPaidByKasApi().fDValueTransferTransaction(this.chainId, request);
    }

    public Call requestFDValueTransferPaidByGlobalFeePayerAsync(FDValueTransferTransactionRequest request, ApiCallback<FDTransactionResult> callback) throws ApiException {
        return this.getFeeDelegatedTransactionPaidByKasApi().fDValueTransferTransactionAsync(this.chainId, request, callback);
    }

    public FDTransactionResult requestFDSmartContractDeployPaidByGlobalFeePayer(FDContractDeployTransactionRequest request) throws ApiException {
        return this.getFeeDelegatedTransactionPaidByKasApi().fDContractDeployTransaction(this.chainId, request);
    }

    public Call requestFDSmartContractDeployPaidByGlobalFeePayerAsync(FDContractDeployTransactionRequest request, ApiCallback<FDTransactionResult> callback) throws ApiException {
        return this.getFeeDelegatedTransactionPaidByKasApi().fDContractDeployTransactionAsync(this.chainId, request, callback);
    }

    public FDTransactionResult requestFDSmartContractExecutionPaidByGlobalFeePayer(FDContractExecutionTransactionRequest request) throws ApiException {
        return this.getFeeDelegatedTransactionPaidByKasApi().fDContractExecutionTransaction(this.chainId, request);
    }

    public Call requestFDSmartContractExecutionPaidByGlobalFeePayerAsync(FDContractExecutionTransactionRequest request, ApiCallback<FDTransactionResult> callback) throws ApiException {
        return this.getFeeDelegatedTransactionPaidByKasApi().fDContractExecutionTransactionAsync(this.chainId, request, callback);
    }

    public FDTransactionResult requestFDCancelPaidByGlobalFeePayer(FDCancelTransactionRequest request) throws ApiException {
        return this.getFeeDelegatedTransactionPaidByKasApi().fDCancelTransactionResponse(this.chainId, request);
    }

    public Call requestFDCancelPaidByGlobalFeePayerAsync(FDCancelTransactionRequest request, ApiCallback<FDTransactionResult> callback) throws ApiException {
        return this.getFeeDelegatedTransactionPaidByKasApi().fDCancelTransactionResponseAsync(this.chainId, request, callback);
    }

    public FDTransactionResult requestFDChainDataAnchoringPaidByGlobalFeePayer(FDAnchorTransactionRequest request) throws ApiException {
        return this.getFeeDelegatedTransactionPaidByKasApi().fDAnchorTransaction(this.chainId, request);
    }

    public Call requestFDChainDataAnchoringPaidByGlobalFeePayerAsync(FDAnchorTransactionRequest request, ApiCallback<FDTransactionResult> callback) throws ApiException {
        return this.getFeeDelegatedTransactionPaidByKasApi().fDAnchorTransactionAsync(this.chainId, request, callback);
    }

    public FDTransactionResult requestFDRawTransactionPaidByGlobalFeePayer(FDProcessRLPRequest request) throws ApiException {
        return this.getFeeDelegatedTransactionPaidByKasApi().fDProcessRLP(this.chainId, request);
    }

    public Call requestFDRawTransactionPaidByGlobalFeePayerAsync(FDProcessRLPRequest request, ApiCallback<FDTransactionResult> callback) throws ApiException {
        return this.getFeeDelegatedTransactionPaidByKasApi().fDProcessRLPAsync(this.chainId, request, callback);
    }

    public FDTransactionResult requestFDAccountUpdatePaidByGlobalFeePayer(FDAccountUpdateTransactionRequest request) throws ApiException {
        request.setAccountKey(this.makeUncompressedKeyFormat(request.getAccountKey()));
        return this.getFeeDelegatedTransactionPaidByKasApi().fDAccountUpdateTransactionResponse(this.chainId, request);
    }

    public Call requestFDAccountUpdatePaidByGlobalFeePayerAsync(FDAccountUpdateTransactionRequest request, ApiCallback<FDTransactionResult> callback) throws ApiException {
        request.setAccountKey(this.makeUncompressedKeyFormat(request.getAccountKey()));
        return this.getFeeDelegatedTransactionPaidByKasApi().fDAccountUpdateTransactionResponseAsync(this.chainId, request, callback);
    }

    public FDTransactionResult requestFDValueTransferPaidByUser(FDUserValueTransferTransactionRequest request) throws ApiException {
        return this.getFeeDelegatedTransactionPaidByUserApi().uFDValueTransferTransaction(this.chainId, request);
    }

    public Call requestFDValueTransferPaidByUserAsync(FDUserValueTransferTransactionRequest request, ApiCallback<FDTransactionResult> callback) throws ApiException {
        return this.getFeeDelegatedTransactionPaidByUserApi().uFDValueTransferTransactionAsync(this.chainId, request, callback);
    }

    public FDTransactionResult requestFDSmartContractDeployPaidByUser(FDUserContractDeployTransactionRequest request) throws ApiException {
        return this.getFeeDelegatedTransactionPaidByUserApi().uFDContractDeployTransaction(this.chainId, request);
    }

    public Call requestFDSmartContractDeployPaidByUserAsync(FDUserContractDeployTransactionRequest request, ApiCallback<FDTransactionResult> callback) throws ApiException {
        return this.getFeeDelegatedTransactionPaidByUserApi().uFDContractDeployTransactionAsync(this.chainId, request, callback);
    }

    public FDTransactionResult requestFDSmartContractExecutionPaidByUser(FDUserContractExecutionTransactionRequest request) throws ApiException {
        return this.getFeeDelegatedTransactionPaidByUserApi().uFDContractExecutionTransaction(this.chainId, request);
    }

    public Call requestFDSmartContractExecutionPaidByUserAsync(FDUserContractExecutionTransactionRequest request, ApiCallback<FDTransactionResult> callback) throws ApiException {
        return this.getFeeDelegatedTransactionPaidByUserApi().uFDContractExecutionTransactionAsync(this.chainId, request, callback);
    }

    public FDTransactionResult requestFDCancelPaidByUser(FDUserCancelTransactionRequest request) throws ApiException {
        return this.getFeeDelegatedTransactionPaidByUserApi().uFDUserCancelTransaction(this.chainId, request);
    }

    public Call requestFDCancelPaidByUserAsync(FDUserCancelTransactionRequest request, ApiCallback<FDTransactionResult> callback) throws ApiException {
        return this.getFeeDelegatedTransactionPaidByUserApi().uFDUserCancelTransactionAsync(this.chainId, request, callback);
    }

    public FDTransactionResult requestFDChainDataAnchoringPaidByUser(FDUserAnchorTransactionRequest request) throws ApiException {
        return this.getFeeDelegatedTransactionPaidByUserApi().uFDAnchorTransaction(this.chainId, request);
    }

    public Call requestFDChainDataAnchoringPaidByUserAsync(FDUserAnchorTransactionRequest request, ApiCallback<FDTransactionResult> callback) throws ApiException {
        return this.getFeeDelegatedTransactionPaidByUserApi().uFDAnchorTransactionAsync(this.chainId, request, callback);
    }

    public FDTransactionResult requestFDRawTransactionPaidByUser(FDUserProcessRLPRequest request) throws ApiException {
        return this.getFeeDelegatedTransactionPaidByUserApi().uFDProcessRLP(this.chainId, request);
    }

    public Call requestFDRawTransactionPaidByUserAsync(FDUserProcessRLPRequest request, ApiCallback<FDTransactionResult> callback) throws ApiException {
        return this.getFeeDelegatedTransactionPaidByUserApi().uFDProcessRLPAsync(this.chainId, request, callback);
    }

    public FDTransactionResult requestFDAccountUpdatePaidByUser(FDUserAccountUpdateTransactionRequest request) throws ApiException {
        request.setAccountKey(this.makeUncompressedKeyFormat(request.getAccountKey()));
        return this.getFeeDelegatedTransactionPaidByUserApi().uFDAccountUpdateTransaction(this.chainId, request);
    }

    public Call requestFDAccountUpdatePaidByUserAsync(FDUserAccountUpdateTransactionRequest request, ApiCallback<FDTransactionResult> callback) throws ApiException {
        request.setAccountKey(this.makeUncompressedKeyFormat(request.getAccountKey()));
        return this.getFeeDelegatedTransactionPaidByUserApi().uFDAccountUpdateTransactionAsync(this.chainId, request, callback);
    }

    public MultisigTransactions getMultiSigTransactionList(String address) throws ApiException {
        return this.getMultiSigTransactionList(address, new WalletQueryOptions());
    }

    public Call getMultiSigTransactionListAsync(String address, ApiCallback<MultisigTransactions> callback) throws ApiException {
        return this.getMultiSigTransactionListAsync(address, new WalletQueryOptions(), callback);
    }

    public MultisigTransactions getMultiSigTransactionList(String address, WalletQueryOptions options) throws ApiException {
        return this.getMultisigTransactionManagementApi().retrieveMultisigTransactions(this.chainId, address, options.getSize(), options.getCursor(), options.getToTimestamp(), options.getFromTimestamp());
    }

    public Call getMultiSigTransactionListAsync(String address, WalletQueryOptions options, ApiCallback<MultisigTransactions> callback) throws ApiException {
        return this.getMultisigTransactionManagementApi().retrieveMultisigTransactionsAsync(this.chainId, address, options.getSize(), options.getCursor(), options.getToTimestamp(), options.getFromTimestamp(), callback);
    }

    public MultisigTransactionStatus signMultiSigTransaction(String address, String transactionId) throws ApiException {
        return this.getMultisigTransactionManagementApi().signPendingTransaction(this.chainId, address, transactionId);
    }

    public Call signMultiSigTransactionAsync(String address, String transactionId, ApiCallback<MultisigTransactionStatus> callback) throws ApiException {
        return this.getMultisigTransactionManagementApi().signPendingTransactionAsync(this.chainId, address, transactionId, callback);
    }

    public MultisigTransactionStatus appendSignatures(String transactionId, SignPendingTransactionBySigRequest request) throws ApiException {
        return this.getMultisigTransactionManagementApi().signPendingTransactionBySig(this.chainId, transactionId, request);
    }

    public Call appendSignaturesAsync(String transactionId, SignPendingTransactionBySigRequest request, ApiCallback<MultisigTransactionStatus> callback) throws ApiException {
        return this.getMultisigTransactionManagementApi().signPendingTransactionBySigAsync(this.chainId, transactionId, request, callback);
    }

    public AccountCountByAccountID getAccountCount() throws ApiException {
        return this.getStatisticsApi().getAccountCountByAccountID(this.getChainId());
    }

    public Call getAccountCountAsync(ApiCallback<AccountCountByAccountID> callback) throws ApiException {
        return this.getStatisticsApi().getAccountCountByAccountIDAsync(this.getChainId(), callback);
    }

    public AccountCountByKRN getAccountCountByKRN() throws ApiException {
        return this.getStatisticsApi().getAccountCountByKRN(this.getChainId());
    }

    public Call getAccountCountByKRNAsync(ApiCallback<AccountCountByKRN> callback) throws ApiException {
        return this.getStatisticsApi().getAccountCountByKRNAsync(this.getChainId(), callback);
    }

    public KeyCreationResponse createKeys(int numberOfKeys) throws ApiException {
        KeyCreationRequest request = new KeyCreationRequest();
        request.setSize(Long.valueOf(numberOfKeys));
        return this.getKeyApi().keyCreation(this.chainId, request);
    }

    public Call createKeysAsync(int numberOfKeys, ApiCallback<KeyCreationResponse> callback) throws ApiException {
        KeyCreationRequest request = new KeyCreationRequest();
        request.setSize(Long.valueOf(numberOfKeys));
        return this.getKeyApi().keyCreationAsync(this.chainId, request, callback);
    }

    public Key getKey(String keyId) throws ApiException {
        return this.getKeyApi().getKey(this.chainId, keyId);
    }

    public Call getKeyAsync(String keyId, ApiCallback<Key> callback) throws ApiException {
        return this.getKeyApi().getKeyAsync(this.chainId, keyId, callback);
    }

    public KeySignDataResponse signMessage(String keyId, String data) throws ApiException {
        KeySignDataRequest request = new KeySignDataRequest();
        request.setData(data);
        return this.getKeyApi().keySignData(this.chainId, keyId, request);
    }

    public Call signMessageAsync(String keyId, String data, ApiCallback<KeySignDataResponse> callback) throws ApiException {
        KeySignDataRequest request = new KeySignDataRequest();
        request.setData(data);
        return this.getKeyApi().keySignDataAsync(this.chainId, keyId, request, callback);
    }

    public RegistrationStatusResponse registerAccounts(AccountRegistrationRequest request) throws ApiException {
        return this.registerAccounts((List<AccountRegistration>)request);
    }

    public RegistrationStatusResponse registerAccounts(List<AccountRegistration> request) throws ApiException {
        return this.getRegistrationApi().registerAccount(this.chainId, request);
    }

    public Call registerAccountsAsync(AccountRegistrationRequest request, ApiCallback<RegistrationStatusResponse> callback) throws ApiException {
        return this.registerAccountsAsync((List<AccountRegistration>)request, callback);
    }

    public Call registerAccountsAsync(List<AccountRegistration> request, ApiCallback<RegistrationStatusResponse> callback) throws ApiException {
        return this.getRegistrationApi().registerAccountAsync(this.chainId, request, callback);
    }

    public ContractCallResponse callContract(String contractAddress, String methodName) throws ApiException {
        return this.callContract(contractAddress, methodName, null, new SendOptions());
    }

    public ContractCallResponse callContract(String contractAddress, String methodName, List<CallArgument> callArguments) throws ApiException {
        return this.callContract(contractAddress, methodName, callArguments, new SendOptions());
    }

    public ContractCallResponse callContract(String contractAddress, String methodName, SendOptions sendOptions) throws ApiException {
        return this.callContract(contractAddress, methodName, null, sendOptions);
    }

    public ContractCallResponse callContract(String contractAddress, String methodName, List<CallArgument> callArguments, SendOptions sendOptions) throws ApiException {
        ContractCallRequest request = new ContractCallRequest();
        request.setTo(contractAddress);
        ContractCallData contractCallData = new ContractCallData();
        contractCallData.setMethodName(methodName);
        contractCallData.setArguments(callArguments);
        request.setData(contractCallData);
        if (sendOptions.getFrom() != null) {
            request.setFrom(sendOptions.getFrom());
        }
        if (sendOptions.getGas() != null) {
            request.setGas(Numeric.toBigInt((String)sendOptions.getGas()).longValue());
        }
        request.setValue(sendOptions.getValue());
        return this.getBasicTransactionApi().contractCall(this.chainId, request);
    }

    public Call callContractAsync(String contractAddress, String methodName, ApiCallback<ContractCallResponse> callback) throws ApiException {
        return this.callContractAsync(contractAddress, methodName, null, new SendOptions(), callback);
    }

    public Call callContractAsync(String contractAddress, String methodName, List<CallArgument> callArguments, ApiCallback<ContractCallResponse> callback) throws ApiException {
        return this.callContractAsync(contractAddress, methodName, callArguments, new SendOptions(), callback);
    }

    public Call callContractAsync(String contractAddress, String methodName, SendOptions sendOptions, ApiCallback<ContractCallResponse> callback) throws ApiException {
        return this.callContractAsync(contractAddress, methodName, null, sendOptions, callback);
    }

    public Call callContractAsync(String contractAddress, String methodName, List<CallArgument> callArguments, SendOptions sendOptions, ApiCallback<ContractCallResponse> callback) throws ApiException {
        ContractCallRequest request = new ContractCallRequest();
        request.setTo(contractAddress);
        ContractCallData contractCallData = new ContractCallData();
        contractCallData.setMethodName(methodName);
        contractCallData.setArguments(callArguments);
        request.setData(contractCallData);
        if (sendOptions.getFrom() != null) {
            request.setFrom(sendOptions.getFrom());
        }
        if (sendOptions.getGas() != null) {
            request.setGas(Numeric.toBigInt((String)sendOptions.getGas()).longValue());
        }
        request.setValue(sendOptions.getValue());
        return this.getBasicTransactionApi().contractCallAsync(this.chainId, request, callback);
    }

    public xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.Account createFeePayer() throws ApiException {
        return this.createFeePayer(false);
    }

    public xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.Account createFeePayer(boolean withoutAccountUpdate) throws ApiException {
        CreateFeePayerAccountRequest body = new CreateFeePayerAccountRequest();
        body.setWithoutAccountUpdate(withoutAccountUpdate);
        return this.getFeepayerApi().creatFeePayerAccount(this.chainId, body);
    }

    public Call createFeePayerAsync(ApiCallback<xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.Account> callback) throws ApiException {
        return this.createFeePayerAsync(false, callback);
    }

    public Call createFeePayerAsync(boolean withoutAccountUpdate, ApiCallback<xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.Account> callback) throws ApiException {
        CreateFeePayerAccountRequest body = new CreateFeePayerAccountRequest();
        body.setWithoutAccountUpdate(withoutAccountUpdate);
        return this.getFeepayerApi().creatFeePayerAccountAsync(this.chainId, body, callback);
    }

    public AccountStatus deleteFeePayer(String address) throws ApiException {
        return this.getFeepayerApi().deleteFeePayerAccount(this.chainId, address);
    }

    public Call deleteFeePayerAsync(String address, ApiCallback<AccountStatus> callback) throws ApiException {
        return this.getFeepayerApi().deleteFeePayerAccountAsync(this.chainId, address, callback);
    }

    public xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.Account getFeePayer(String address) throws ApiException {
        return this.getFeepayerApi().retrieveFeePayerAccount(this.chainId, address);
    }

    public Call getFeePayerAsync(String address, ApiCallback<xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.Account> callback) throws ApiException {
        return this.getFeepayerApi().retrieveFeePayerAccountAsync(this.chainId, address, callback);
    }

    public Accounts getFeePayerList() throws ApiException {
        return this.getFeePayerList(new WalletQueryOptions());
    }

    public Accounts getFeePayerList(WalletQueryOptions options) throws ApiException {
        String fromTimeStamp = Optional.ofNullable(options.getFromTimestamp()).map(value -> Long.toString(value)).orElseGet(() -> null);
        String toTimeStamp = Optional.ofNullable(options.getToTimestamp()).map(value -> Long.toString(value)).orElseGet(() -> null);
        return this.getFeepayerApi().retrieveFeePayerAccounts(this.chainId, options.getSize(), options.getCursor(), fromTimeStamp, toTimeStamp);
    }

    public Call getFeePayerListAsync(ApiCallback<Accounts> callback) throws ApiException {
        return this.getFeePayerListAsync(new WalletQueryOptions(), callback);
    }

    public Call getFeePayerListAsync(WalletQueryOptions options, ApiCallback<Accounts> callback) throws ApiException {
        String fromTimeStamp = Optional.ofNullable(options.getFromTimestamp()).map(value -> Long.toString(value)).orElseGet(() -> null);
        String toTimeStamp = Optional.ofNullable(options.getToTimestamp()).map(value -> Long.toString(value)).orElseGet(() -> null);
        return this.getFeepayerApi().retrieveFeePayerAccountsAsync(this.chainId, options.getSize(), options.getCursor(), fromTimeStamp, toTimeStamp, callback);
    }

    public KeyStatus deleteKey(String keyId) throws ApiException {
        return this.getKeyApi().keyDeletion(this.chainId, keyId);
    }

    public Call deleteKeyAsync(String keyId, ApiCallback<KeyStatus> callback) throws ApiException {
        return this.getKeyApi().keyDeletionAsync(this.chainId, keyId, callback);
    }

    public KeyList getKeyListByKRN(String krn) throws ApiException {
        return this.getKeyListByKRN(krn, new WalletQueryOptions());
    }

    public Call getKeyListByKRNAsync(String krn, ApiCallback<KeyList> callback) throws ApiException {
        return this.getKeyListByKRNAsync(krn, new WalletQueryOptions(), callback);
    }

    public KeyList getKeyListByKRN(String krn, WalletQueryOptions options) throws ApiException {
        String size = options.getSize() != null ? Long.toString(options.getSize()) : null;
        return this.keyApi.retrieveKeys(this.chainId, krn, options.getCursor(), size);
    }

    public Call getKeyListByKRNAsync(String krn, WalletQueryOptions options, ApiCallback<KeyList> callback) throws ApiException {
        String size = options.getSize() != null ? Long.toString(options.getSize()) : null;
        return this.keyApi.retrieveKeysAsync(this.chainId, krn, options.getCursor(), size, callback);
    }

    public FDTransactionWithCurrencyResultList getFDTransactionList() throws ApiException {
        return this.getFDTransactionList(null);
    }

    public Call getFDTransactionListAsync(ApiCallback<FDTransactionWithCurrencyResultList> callback) throws ApiException {
        return this.getFDTransactionListAsync(null, callback);
    }

    public FDTransactionWithCurrencyResultList getFDTransactionList(String from) throws ApiException {
        if (!this.chainId.equals("8217")) {
            throw new RuntimeException("This API is only supported on the Cypress network. Please change network to use this.");
        }
        return this.transactionHistoryApi.getV2HistoryFdTx(this.chainId, from);
    }

    public Call getFDTransactionListAsync(String from, ApiCallback<FDTransactionWithCurrencyResultList> callback) throws ApiException {
        if (!this.chainId.equals("8217")) {
            throw new RuntimeException("This API is only supported on the Cypress network. Please change network to use this.");
        }
        return this.transactionHistoryApi.getV2HistoryFdTxAsync(this.chainId, from, callback);
    }

    public FDTransactionWithCurrencyResult getFDTransaction(String txHash) throws ApiException {
        if (!this.chainId.equals("8217")) {
            throw new RuntimeException("This API is only supported on the Cypress network. Please change network to use this.");
        }
        return this.transactionHistoryApi.getV2HistoryFdTxTransactionHash(txHash, this.chainId);
    }

    public Call getFDTransactionAsync(String txHash, ApiCallback<FDTransactionWithCurrencyResult> callback) throws ApiException {
        if (!this.chainId.equals("8217")) {
            throw new RuntimeException("This API is only supported on the Cypress network. Please change network to use this.");
        }
        return this.transactionHistoryApi.getV2HistoryFdTxTransactionHashAsync(txHash, this.chainId, callback);
    }

    public AccountApi getAccountApi() {
        return this.accountApi;
    }

    public BasicTxApi getBasicTransactionApi() {
        return this.basicTransactionApi;
    }

    public FdtxKasApi getFeeDelegatedTransactionPaidByKasApi() {
        return this.feeDelegatedTransactionPaidByKasApi;
    }

    public FdtxUserApi getFeeDelegatedTransactionPaidByUserApi() {
        return this.feeDelegatedTransactionPaidByUserApi;
    }

    public MultisigTxApi getMultisigTransactionManagementApi() {
        return this.multisigTransactionManagementApi;
    }

    public StatisticsApi getStatisticsApi() {
        return this.statisticsApi;
    }

    public KeyApi getKeyApi() {
        return this.keyApi;
    }

    public RegistrationApi getRegistrationApi() {
        return this.registrationApi;
    }

    public FeepayerApi getFeepayerApi() {
        return this.feepayerApi;
    }

    public TxHistoryApi getTransactionHistoryApi() {
        return this.transactionHistoryApi;
    }

    public String getChainId() {
        return this.chainId;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setAccountApi(AccountApi accountApi) {
        this.accountApi = accountApi;
    }

    public void setBasicTransactionApi(BasicTxApi basicTransactionApi) {
        this.basicTransactionApi = basicTransactionApi;
    }

    public void setFeeDelegatedTransactionPaidByKasApi(FdtxKasApi feeDelegatedTransactionPaidByKasApi) {
        this.feeDelegatedTransactionPaidByKasApi = feeDelegatedTransactionPaidByKasApi;
    }

    public void setFeeDelegatedTransactionPaidByUserApi(FdtxUserApi feeDelegatedTransactionPaidByUserApi) {
        this.feeDelegatedTransactionPaidByUserApi = feeDelegatedTransactionPaidByUserApi;
    }

    public void setMultisigTransactionManagementApi(MultisigTxApi multisigTransactionManagementApi) {
        this.multisigTransactionManagementApi = multisigTransactionManagementApi;
    }

    public void setStatisticsApi(StatisticsApi statisticsApi) {
        this.statisticsApi = statisticsApi;
    }

    public void setKeyApi(KeyApi keyApi) {
        this.keyApi = keyApi;
    }

    public void setRegistrationApi(RegistrationApi registrationApi) {
        this.registrationApi = registrationApi;
    }

    public void setFeepayerApi(FeepayerApi feepayerApi) {
        this.feepayerApi = feepayerApi;
    }

    public void setTransactionHistoryApi(TxHistoryApi transactionHistoryApi) {
        this.transactionHistoryApi = transactionHistoryApi;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.setAccountApi(new AccountApi(apiClient));
        this.setBasicTransactionApi(new BasicTxApi(apiClient));
        this.setFeeDelegatedTransactionPaidByKasApi(new FdtxKasApi(apiClient));
        this.setFeeDelegatedTransactionPaidByUserApi(new FdtxUserApi(apiClient));
        this.setMultisigTransactionManagementApi(new MultisigTxApi(apiClient));
        this.setStatisticsApi(new StatisticsApi(apiClient));
        this.setKeyApi(new KeyApi(apiClient));
        this.setRegistrationApi(new RegistrationApi(apiClient));
        this.setFeepayerApi(new FeepayerApi(apiClient));
        this.setTransactionHistoryApi(new TxHistoryApi(apiClient));
    }

    public void setRPC(RPC rpc) {
        this.rpc = rpc;
    }

    public void setNodeAPIInitialized(boolean nodeAPIInitialized) {
        this.nodeAPIInitialized = nodeAPIInitialized;
    }

    private List<MultisigKey> convertMultiSigKey(AccountKeyWeightedMultiSig weightedMultiSig) {
        return weightedMultiSig.getWeightedPublicKeys().stream().map(weightedPublicKey -> {
            MultisigKey multisigKey = new MultisigKey();
            multisigKey.setPublicKey(weightedPublicKey.getPublicKey());
            multisigKey.setWeight(weightedPublicKey.getWeight().longValue());
            return multisigKey;
        }).collect(Collectors.toList());
    }

    OneOfAccountUpdateTransactionRequestAccountKey makeUncompressedKeyFormat(OneOfAccountUpdateTransactionRequestAccountKey updateKey) {
        if (updateKey instanceof EmptyUpdateKeyType) {
            return updateKey;
        }
        if (updateKey instanceof PubkeyUpdateKeyType) {
            ((KeyTypePublic)updateKey).setKey(KASUtils.addUncompressedKeyPrefix(((KeyTypePublic)updateKey).getKey()));
        } else if (updateKey instanceof MultisigUpdateKeyType) {
            MultisigUpdateKey keys = ((KeyTypeMultiSig)updateKey).getKey();
            keys.getWeightedKeys().stream().forEach(weightKey -> weightKey.setPublicKey(KASUtils.addUncompressedKeyPrefix(weightKey.getPublicKey())));
        } else if (updateKey instanceof RoleBasedUpdateKeyType) {
            List<OneOfRoleBasedUpdateKeyTypeKeyItems> roleKeyList = ((KeyTypeRoleBased)updateKey).getKey();
            roleKeyList.stream().forEach(roleKey -> this.makeUncompressedKeyFormat((OneOfAccountUpdateTransactionRequestAccountKey)((Object)roleKey)));
        } else {
            throw new IllegalArgumentException("Not supported update Key type.");
        }
        return updateKey;
    }

    OneOfFDAccountUpdateTransactionRequestAccountKey makeUncompressedKeyFormat(OneOfFDAccountUpdateTransactionRequestAccountKey updateKey) {
        if (updateKey instanceof EmptyUpdateKeyType) {
            return updateKey;
        }
        if (updateKey instanceof PubkeyUpdateKeyType) {
            ((KeyTypePublic)updateKey).setKey(KASUtils.addUncompressedKeyPrefix(((KeyTypePublic)updateKey).getKey()));
        } else if (updateKey instanceof MultisigUpdateKeyType) {
            MultisigUpdateKey keys = ((KeyTypeMultiSig)updateKey).getKey();
            keys.getWeightedKeys().stream().forEach(weightKey -> weightKey.setPublicKey(KASUtils.addUncompressedKeyPrefix(weightKey.getPublicKey())));
        } else if (updateKey instanceof RoleBasedUpdateKeyType) {
            List<OneOfRoleBasedUpdateKeyTypeKeyItems> roleKeyList = ((KeyTypeRoleBased)updateKey).getKey();
            roleKeyList.stream().forEach(roleKey -> this.makeUncompressedKeyFormat((OneOfFDAccountUpdateTransactionRequestAccountKey)((Object)roleKey)));
        } else {
            throw new IllegalArgumentException("Not supported update Key type.");
        }
        return updateKey;
    }

    OneOfFDUserAccountUpdateTransactionRequestAccountKey makeUncompressedKeyFormat(OneOfFDUserAccountUpdateTransactionRequestAccountKey updateKey) {
        if (updateKey instanceof EmptyUpdateKeyType) {
            return updateKey;
        }
        if (updateKey instanceof PubkeyUpdateKeyType) {
            ((KeyTypePublic)updateKey).setKey(KASUtils.addUncompressedKeyPrefix(((KeyTypePublic)updateKey).getKey()));
        } else if (updateKey instanceof MultisigUpdateKeyType) {
            MultisigUpdateKey keys = ((KeyTypeMultiSig)updateKey).getKey();
            keys.getWeightedKeys().stream().forEach(weightKey -> weightKey.setPublicKey(KASUtils.addUncompressedKeyPrefix(weightKey.getPublicKey())));
        } else if (updateKey instanceof RoleBasedUpdateKeyType) {
            List<OneOfRoleBasedUpdateKeyTypeKeyItems> roleKeyList = ((KeyTypeRoleBased)updateKey).getKey();
            roleKeyList.stream().forEach(roleKey -> this.makeUncompressedKeyFormat((OneOfFDAccountUpdateTransactionRequestAccountKey)((Object)roleKey)));
        } else {
            throw new IllegalArgumentException("Not supported update Key type.");
        }
        return updateKey;
    }

    private void validateMigrationAccount(MigrationAccount migrationAccount) {
        if (migrationAccount.getAddress().isEmpty()) {
            throw new IllegalArgumentException("Address of migrationAccount must not be empty.");
        }
        MigrationAccountKey<?> migrationAccountKey = migrationAccount.getMigrationAccountKey();
        if (migrationAccountKey == null) {
            throw new IllegalArgumentException("MigrationAccountKey of migrationAccount must not be empty.");
        }
        if (!(migrationAccountKey instanceof SinglePrivateKey || migrationAccountKey instanceof MultisigPrivateKeys || migrationAccountKey instanceof RoleBasedPrivateKeys)) {
            throw new IllegalArgumentException("MigrationAccountKey of Migration Account must be one of following class [SinglePrivateKey, MultisigPrivateKeys, RoleBasedPrivateKeys].");
        }
    }

    private AbstractKeyring createKeyringFromMigrationAccount(MigrationAccount migrationAccount) {
        MigrationAccountKey<?> migrationAccountKey = migrationAccount.getMigrationAccountKey();
        if (migrationAccountKey instanceof SinglePrivateKey) {
            return KeyringFactory.create((String)migrationAccount.getAddress(), (String)((SinglePrivateKey)migrationAccountKey).getKey());
        }
        if (migrationAccountKey instanceof MultisigPrivateKeys) {
            return KeyringFactory.create((String)migrationAccount.getAddress(), (String[])((MultisigPrivateKeys)migrationAccountKey).getKey());
        }
        if (migrationAccountKey instanceof RoleBasedPrivateKeys) {
            return KeyringFactory.create((String)migrationAccount.getAddress(), (List)((RoleBasedPrivateKeys)migrationAccountKey).getKey());
        }
        throw new IllegalArgumentException("MigrationAccountKey must be one of the following class instance [SinglePrivateKey, MultisigPrivateKeys, RoleBasedPrivateKeys].");
    }
}

