/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.kas.kip7;

import com.squareup.okhttp.Call;
import java.math.BigInteger;
import org.web3j.utils.Numeric;
import xyz.groundx.caver_ext_kas.kas.kip7.KIP7QueryOptions;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiCallback;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiClient;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiException;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.api.Kip7ContractApi;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.api.Kip7DeployerApi;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.api.Kip7TokenApi;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.AddMinterKip7Request;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.AddPauserKip7Request;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.ApproveKip7TokenRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.BurnFromKip7TokenRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.BurnKip7TokenRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.DeployKip7ContractRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.Kip7ContractListResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.Kip7ContractMetadataResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.Kip7DeployResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.Kip7DeployerResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.Kip7FeePayerOptions;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.Kip7TokenBalanceResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.Kip7TransactionStatusResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.MintKip7TokenRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.PauseKip7Request;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.TransferKip7TokenFromRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.TransferKip7TokenRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.UnpauseKip7Request;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model.UpdateKip7ContractRequest;

public class KIP7 {
    Kip7ContractApi kip7ContractApi;
    Kip7TokenApi kip7TokenApi;
    Kip7DeployerApi kip7DeployerApi;
    String chainId;
    ApiClient apiClient;

    public KIP7(String chainId, ApiClient apiClient) {
        this.chainId = chainId;
        this.setApiClient(apiClient);
    }

    public Kip7DeployResponse deploy(String name, String symbol, int decimals, BigInteger initialSupply, String alias) throws ApiException {
        return this.deploy(name, symbol, decimals, Numeric.toHexStringWithPrefix((BigInteger)initialSupply), alias, null);
    }

    public Call deployAsync(String name, String symbol, int decimals, BigInteger initialSupply, String alias, ApiCallback<Kip7DeployResponse> callback) throws ApiException {
        return this.deployAsync(name, symbol, decimals, Numeric.toHexStringWithPrefix((BigInteger)initialSupply), alias, null, callback);
    }

    public Kip7DeployResponse deploy(String name, String symbol, int decimals, String initialSupply, String alias) throws ApiException {
        return this.deploy(name, symbol, decimals, initialSupply, alias, null);
    }

    public Call deployAsync(String name, String symbol, int decimals, String initialSupply, String alias, ApiCallback<Kip7DeployResponse> callback) throws ApiException {
        return this.deployAsync(name, symbol, decimals, initialSupply, alias, null, callback);
    }

    public Kip7DeployResponse deploy(String name, String symbol, int decimals, BigInteger initialSupply, String alias, Kip7FeePayerOptions option) throws ApiException {
        return this.deploy(name, symbol, decimals, Numeric.toHexStringWithPrefix((BigInteger)initialSupply), alias, option);
    }

    public Call deployAsync(String name, String symbol, int decimals, BigInteger initialSupply, String alias, Kip7FeePayerOptions option, ApiCallback<Kip7DeployResponse> callback) throws ApiException {
        return this.deployAsync(name, symbol, decimals, Numeric.toHexStringWithPrefix((BigInteger)initialSupply), alias, option, callback);
    }

    public Kip7DeployResponse deploy(String name, String symbol, int decimals, String initialSupply, String alias, Kip7FeePayerOptions option) throws ApiException {
        DeployKip7ContractRequest request = new DeployKip7ContractRequest();
        request.setName(name);
        request.setSymbol(symbol);
        request.setDecimals(Long.valueOf(decimals));
        request.setInitialSupply(initialSupply);
        request.setAlias(alias);
        request.setOptions(option);
        return this.kip7ContractApi.deployContract(this.chainId, request);
    }

    public Call deployAsync(String name, String symbol, int decimals, String initialSupply, String alias, Kip7FeePayerOptions option, ApiCallback<Kip7DeployResponse> callback) throws ApiException {
        DeployKip7ContractRequest request = new DeployKip7ContractRequest();
        request.setName(name);
        request.setSymbol(symbol);
        request.setDecimals(Long.valueOf(decimals));
        request.setInitialSupply(initialSupply);
        request.setAlias(alias);
        request.setOptions(option);
        return this.kip7ContractApi.deployContractAsync(this.chainId, request, callback);
    }

    public Kip7ContractMetadataResponse getContract(String addressOrAlias) throws ApiException {
        return this.kip7ContractApi.getContract(this.chainId, addressOrAlias);
    }

    public Call getContractAsync(String addressOrAlias, ApiCallback<Kip7ContractMetadataResponse> callback) throws ApiException {
        return this.kip7ContractApi.getContractAsync(this.chainId, addressOrAlias, callback);
    }

    public Kip7ContractListResponse getContractList() throws ApiException {
        return this.getContractList(new KIP7QueryOptions());
    }

    public Call getContractListAsync(ApiCallback<Kip7ContractListResponse> callback) throws ApiException {
        return this.getContractListAsync(new KIP7QueryOptions(), callback);
    }

    public Kip7ContractListResponse getContractList(KIP7QueryOptions options) throws ApiException {
        String size = null;
        if (options.getSize() != null) {
            size = Integer.toString(options.getSize());
        }
        return this.kip7ContractApi.listContractsInDeployerPool(this.chainId, size, options.getCursor(), options.getStatus());
    }

    public Call getContractListAsync(KIP7QueryOptions options, ApiCallback<Kip7ContractListResponse> callback) throws ApiException {
        String size = null;
        if (options.getSize() != null) {
            size = Integer.toString(options.getSize());
        }
        return this.kip7ContractApi.listContractsInDeployerPoolAsync(this.chainId, size, options.getCursor(), options.getStatus(), callback);
    }

    public Kip7TokenBalanceResponse allowance(String addressOrAlias, String owner, String spender) throws ApiException {
        return this.kip7TokenApi.getTokenAllowance(this.chainId, addressOrAlias, owner, spender);
    }

    public Call allowanceAsync(String addressOrAlias, String owner, String spender, ApiCallback<Kip7TokenBalanceResponse> callback) throws ApiException {
        return this.kip7TokenApi.getTokenAllowanceAsync(this.chainId, addressOrAlias, owner, spender, callback);
    }

    public Kip7TokenBalanceResponse balance(String addressOrAlias, String owner) throws ApiException {
        return this.kip7TokenApi.getTokenBalance(this.chainId, addressOrAlias, owner);
    }

    public Call balanceAsync(String addressOrAlias, String owner, ApiCallback<Kip7TokenBalanceResponse> callback) throws ApiException {
        return this.kip7TokenApi.getTokenBalanceAsync(this.chainId, addressOrAlias, owner, callback);
    }

    public Kip7TransactionStatusResponse approve(String addressOrAlias, String spender, BigInteger amount) throws ApiException {
        return this.approve(addressOrAlias, null, spender, amount);
    }

    public Call approveAsync(String addressOrAlias, String spender, BigInteger amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.approveAsync(addressOrAlias, null, spender, amount, callback);
    }

    public Kip7TransactionStatusResponse approve(String addressOrAlias, String spender, String amount) throws ApiException {
        return this.approve(addressOrAlias, null, spender, amount);
    }

    public Call approveAsync(String addressOrAlias, String spender, String amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.approveAsync(addressOrAlias, null, spender, amount, callback);
    }

    public Kip7TransactionStatusResponse approve(String addressOrAlias, String owner, String spender, BigInteger amount) throws ApiException {
        return this.approve(addressOrAlias, owner, spender, Numeric.toHexStringWithPrefix((BigInteger)amount));
    }

    public Call approveAsync(String addressOrAlias, String owner, String spender, BigInteger amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.approveAsync(addressOrAlias, owner, spender, Numeric.toHexStringWithPrefix((BigInteger)amount), callback);
    }

    public Kip7TransactionStatusResponse approve(String addressOrAlias, String owner, String spender, String amount) throws ApiException {
        ApproveKip7TokenRequest request = new ApproveKip7TokenRequest();
        request.setOwner(owner);
        request.setSpender(spender);
        request.setAmount(amount);
        return this.kip7TokenApi.approveToken(this.chainId, addressOrAlias, request);
    }

    public Call approveAsync(String addressOrAlias, String owner, String spender, String amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        ApproveKip7TokenRequest request = new ApproveKip7TokenRequest();
        request.setOwner(owner);
        request.setSpender(spender);
        request.setAmount(amount);
        return this.kip7TokenApi.approveTokenAsync(this.chainId, addressOrAlias, request, callback);
    }

    public Kip7TransactionStatusResponse transfer(String addressOrAlias, String to, BigInteger amount) throws ApiException {
        return this.transfer(addressOrAlias, null, to, Numeric.toHexStringWithPrefix((BigInteger)amount));
    }

    public Call transferAsync(String addressOrAlias, String to, BigInteger amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.transferAsync(addressOrAlias, null, to, Numeric.toHexStringWithPrefix((BigInteger)amount), callback);
    }

    public Kip7TransactionStatusResponse transfer(String addressOrAlias, String to, String amount) throws ApiException {
        return this.transfer(addressOrAlias, null, to, amount);
    }

    public Call transferAsync(String addressOrAlias, String to, String amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.transferAsync(addressOrAlias, null, to, amount, callback);
    }

    public Kip7TransactionStatusResponse transfer(String addressOrAlias, String from, String to, BigInteger amount) throws ApiException {
        return this.transfer(addressOrAlias, from, to, Numeric.toHexStringWithPrefix((BigInteger)amount));
    }

    public Call transferAsync(String addressOrAlias, String from, String to, BigInteger amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.transferAsync(addressOrAlias, from, to, Numeric.toHexStringWithPrefix((BigInteger)amount), callback);
    }

    public Kip7TransactionStatusResponse transfer(String addressOrAlias, String from, String to, String amount) throws ApiException {
        TransferKip7TokenRequest request = new TransferKip7TokenRequest();
        request.setFrom(from);
        request.setTo(to);
        request.setAmount(amount);
        return this.kip7TokenApi.transferToken(this.chainId, addressOrAlias, request);
    }

    public Call transferAsync(String addressOrAlias, String from, String to, String amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        TransferKip7TokenRequest request = new TransferKip7TokenRequest();
        request.setFrom(from);
        request.setTo(to);
        request.setAmount(amount);
        return this.kip7TokenApi.transferTokenAsync(this.chainId, addressOrAlias, request, callback);
    }

    public Kip7TransactionStatusResponse transferFrom(String addressOrAlias, String spender, String owner, String to, BigInteger amount) throws ApiException {
        return this.transferFrom(addressOrAlias, spender, owner, to, Numeric.toHexStringWithPrefix((BigInteger)amount));
    }

    public Call transferFromAsync(String addressOrAlias, String spender, String owner, String to, BigInteger amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.transferFromAsync(addressOrAlias, spender, owner, to, Numeric.toHexStringWithPrefix((BigInteger)amount), callback);
    }

    public Kip7TransactionStatusResponse transferFrom(String addressOrAlias, String spender, String owner, String to, String amount) throws ApiException {
        TransferKip7TokenFromRequest request = new TransferKip7TokenFromRequest();
        request.setSpender(spender);
        request.setOwner(owner);
        request.setTo(to);
        request.setAmount(amount);
        return this.kip7TokenApi.transferFromToken(this.chainId, addressOrAlias, request);
    }

    public Call transferFromAsync(String addressOrAlias, String spender, String owner, String to, String amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        TransferKip7TokenFromRequest request = new TransferKip7TokenFromRequest();
        request.setSpender(spender);
        request.setOwner(owner);
        request.setTo(to);
        request.setAmount(amount);
        return this.kip7TokenApi.transferFromTokenAsync(this.chainId, addressOrAlias, request, callback);
    }

    public Kip7TransactionStatusResponse mint(String addressOrAlias, String to, BigInteger amount) throws ApiException {
        return this.mint(addressOrAlias, to, Numeric.toHexStringWithPrefix((BigInteger)amount), null);
    }

    public Kip7TransactionStatusResponse mint(String addressOrAlias, String to, BigInteger amount, String minter) throws ApiException {
        return this.mint(addressOrAlias, to, Numeric.toHexStringWithPrefix((BigInteger)amount), minter);
    }

    public Call mintAsync(String addressOrAlias, String to, BigInteger amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.mintAsync(addressOrAlias, to, Numeric.toHexStringWithPrefix((BigInteger)amount), null, callback);
    }

    public Call mintAsync(String addressOrAlias, String to, BigInteger amount, String minter, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.mintAsync(addressOrAlias, to, Numeric.toHexStringWithPrefix((BigInteger)amount), minter, callback);
    }

    public Kip7TransactionStatusResponse mint(String addressOrAlias, String to, String amount) throws ApiException {
        return this.mint(addressOrAlias, to, amount, null);
    }

    public Kip7TransactionStatusResponse mint(String addressOrAlias, String to, String amount, String minter) throws ApiException {
        MintKip7TokenRequest request = new MintKip7TokenRequest();
        request.setTo(to);
        request.setFrom(minter);
        request.setAmount(amount);
        return this.kip7TokenApi.mintToken(this.chainId, addressOrAlias, request);
    }

    public Call mintAsync(String addressOrAlias, String to, String amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.mintAsync(addressOrAlias, to, amount, null, callback);
    }

    public Call mintAsync(String addressOrAlias, String to, String amount, String minter, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        MintKip7TokenRequest request = new MintKip7TokenRequest();
        request.setTo(to);
        request.setFrom(minter);
        request.setAmount(amount);
        return this.kip7TokenApi.mintTokenAsync(this.chainId, addressOrAlias, request, callback);
    }

    public Kip7TransactionStatusResponse burn(String addressOrAlias, BigInteger amount) throws ApiException {
        return this.burn(addressOrAlias, null, Numeric.toHexStringWithPrefix((BigInteger)amount));
    }

    public Call burnAsync(String addressOrAlias, BigInteger amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.burnAsync(addressOrAlias, null, amount, callback);
    }

    public Kip7TransactionStatusResponse burn(String addressOrAlias, String amount) throws ApiException {
        return this.burn(addressOrAlias, null, amount);
    }

    public Call burnAsync(String addressOrAlias, String amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.burnAsync(addressOrAlias, null, amount, callback);
    }

    public Kip7TransactionStatusResponse burn(String addressOrAlias, String from, BigInteger amount) throws ApiException {
        return this.burn(addressOrAlias, from, Numeric.toHexStringWithPrefix((BigInteger)amount));
    }

    public Call burnAsync(String addressOrAlias, String from, BigInteger amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.burnAsync(addressOrAlias, from, Numeric.toHexStringWithPrefix((BigInteger)amount), callback);
    }

    public Kip7TransactionStatusResponse burn(String addressOrAlias, String from, String amount) throws ApiException {
        BurnKip7TokenRequest request = new BurnKip7TokenRequest();
        request.setFrom(from);
        request.setAmount(amount);
        return this.kip7TokenApi.burnToken(this.chainId, addressOrAlias, request);
    }

    public Call burnAsync(String addressOrAlias, String from, String amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        BurnKip7TokenRequest request = new BurnKip7TokenRequest();
        request.setFrom(from);
        request.setAmount(amount);
        return this.kip7TokenApi.burnTokenAsync(this.chainId, addressOrAlias, request, callback);
    }

    public Kip7TransactionStatusResponse burnFrom(String addressOrAlias, String spender, String owner, BigInteger amount) throws ApiException {
        return this.burnFrom(addressOrAlias, spender, owner, Numeric.toHexStringWithPrefix((BigInteger)amount));
    }

    public Call burnFromAsync(String addressOrAlias, String spender, String owner, BigInteger amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.burnFromAsync(addressOrAlias, spender, owner, Numeric.toHexStringWithPrefix((BigInteger)amount), callback);
    }

    public Kip7TransactionStatusResponse burnFrom(String addressOrAlias, String spender, String owner, String amount) throws ApiException {
        BurnFromKip7TokenRequest request = new BurnFromKip7TokenRequest();
        request.setSpender(spender);
        request.setOwner(owner);
        request.setAmount(amount);
        return this.kip7TokenApi.burnFromToken(this.chainId, addressOrAlias, request);
    }

    public Call burnFromAsync(String addressOrAlias, String spender, String owner, String amount, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        BurnFromKip7TokenRequest request = new BurnFromKip7TokenRequest();
        request.setSpender(spender);
        request.setOwner(owner);
        request.setAmount(amount);
        return this.kip7TokenApi.burnFromTokenAsync(this.chainId, addressOrAlias, request, callback);
    }

    public Kip7TransactionStatusResponse pause(String addressOrAlias) throws ApiException {
        return this.pause(addressOrAlias, null);
    }

    public Kip7TransactionStatusResponse pause(String addressOrAlias, String pauser) throws ApiException {
        PauseKip7Request request = new PauseKip7Request();
        request.setPauser(pauser);
        return this.kip7ContractApi.pauseContract(this.chainId, addressOrAlias, request);
    }

    public Call pauseAsync(String addressOrAlias, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.pauseAsync(addressOrAlias, null, callback);
    }

    public Call pauseAsync(String addressOrAlias, String pauser, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        PauseKip7Request request = new PauseKip7Request();
        request.setPauser(pauser);
        return this.kip7ContractApi.pauseContractAsync(this.chainId, addressOrAlias, request, callback);
    }

    public Kip7TransactionStatusResponse unpause(String addressOrAlias) throws ApiException {
        return this.unpause(addressOrAlias, null);
    }

    public Kip7TransactionStatusResponse unpause(String addressOrAlias, String pauser) throws ApiException {
        UnpauseKip7Request request = new UnpauseKip7Request();
        request.setPauser(pauser);
        return this.kip7ContractApi.unpauseContract(this.chainId, addressOrAlias, request);
    }

    public Call unpauseAsync(String addressOrAlias, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.unpauseAsync(addressOrAlias, null, callback);
    }

    public Call unpauseAsync(String addressOrAlias, String pauser, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        UnpauseKip7Request request = new UnpauseKip7Request();
        request.setPauser(pauser);
        return this.kip7ContractApi.unpauseContractAsync(this.chainId, addressOrAlias, request, callback);
    }

    public Kip7TransactionStatusResponse addMinter(String addressOrAlias, String accountToBeMinter) throws ApiException {
        return this.addMinter(addressOrAlias, accountToBeMinter, null);
    }

    public Call addMinterAsync(String addressOrAlias, String accountToBeMinter, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.addMinterAsync(addressOrAlias, accountToBeMinter, null, callback);
    }

    public Kip7TransactionStatusResponse addMinter(String addressOrAlias, String accountToBeMinter, String minter) throws ApiException {
        AddMinterKip7Request request = new AddMinterKip7Request();
        request.setMinter(accountToBeMinter);
        request.setSender(minter);
        return this.kip7TokenApi.addMinter(this.chainId, addressOrAlias, request);
    }

    public Call addMinterAsync(String addressOrAlias, String accountToBeMinter, String minter, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        AddMinterKip7Request request = new AddMinterKip7Request();
        request.setMinter(accountToBeMinter);
        request.setSender(minter);
        return this.kip7TokenApi.addMinterAsync(this.chainId, addressOrAlias, request, callback);
    }

    public Kip7TransactionStatusResponse renounceMinter(String addressOrAlias, String minter) throws ApiException {
        return this.kip7TokenApi.renounceMinter(addressOrAlias, minter, this.chainId);
    }

    public Call renounceMinterAsync(String addressOrAlias, String minter, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.kip7TokenApi.renounceMinterAsync(addressOrAlias, minter, this.chainId, callback);
    }

    public Kip7TransactionStatusResponse addPauser(String addressOrAlias, String accountToBePauser) throws ApiException {
        return this.addPauser(addressOrAlias, accountToBePauser, null);
    }

    public Call addPauserAsync(String addressOrAlias, String accountToBePauser, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.addPauserAsync(addressOrAlias, accountToBePauser, null, callback);
    }

    public Kip7TransactionStatusResponse addPauser(String addressOrAlias, String accountToBePauser, String pauser) throws ApiException {
        AddPauserKip7Request request = new AddPauserKip7Request();
        request.setSender(pauser);
        request.setPauser(accountToBePauser);
        return this.kip7ContractApi.addPauser(this.chainId, addressOrAlias, request);
    }

    public Call addPauserAsync(String addressOrAlias, String accountToBePauser, String pauser, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        AddPauserKip7Request request = new AddPauserKip7Request();
        request.setSender(pauser);
        request.setPauser(accountToBePauser);
        return this.kip7ContractApi.addPauserAsync(this.chainId, addressOrAlias, request, callback);
    }

    public Kip7TransactionStatusResponse renouncePauser(String addressOrAlias, String pauser) throws ApiException {
        return this.kip7ContractApi.renouncePauser(addressOrAlias, pauser, this.chainId);
    }

    public Call renouncePauserAsync(String addressOrAlias, String pauser, ApiCallback<Kip7TransactionStatusResponse> callback) throws ApiException {
        return this.kip7ContractApi.renouncePauserAsync(addressOrAlias, pauser, this.chainId, callback);
    }

    public Kip7ContractMetadataResponse updateContractOptions(String addressOrAlias) throws ApiException {
        return this.updateContractOptions(addressOrAlias, null);
    }

    public Call updateContractOptionsAsync(String addressOrAlias, ApiCallback<Kip7ContractMetadataResponse> callback) throws ApiException {
        return this.updateContractOptionsAsync(addressOrAlias, null, callback);
    }

    public Kip7ContractMetadataResponse updateContractOptions(String addressOrAlias, Kip7FeePayerOptions option) throws ApiException {
        UpdateKip7ContractRequest request = new UpdateKip7ContractRequest();
        request.setOptions(option);
        return this.kip7ContractApi.updateContract(this.chainId, addressOrAlias, request);
    }

    public Call updateContractOptionsAsync(String addressOrAlias, Kip7FeePayerOptions option, ApiCallback<Kip7ContractMetadataResponse> callback) throws ApiException {
        UpdateKip7ContractRequest request = new UpdateKip7ContractRequest();
        request.setOptions(option);
        return this.kip7ContractApi.updateContractAsync(this.chainId, addressOrAlias, request, callback);
    }

    public Kip7DeployerResponse getDeployer() throws ApiException {
        return this.kip7DeployerApi.getDefaultDeployer(this.chainId);
    }

    public Call getDeployerAsync(ApiCallback<Kip7DeployerResponse> callback) throws ApiException {
        return this.kip7DeployerApi.getDefaultDeployerAsync(this.chainId, callback);
    }

    public Kip7DeployerApi getKip7DeployerApi() {
        return this.kip7DeployerApi;
    }

    public void setKip7DeployerApi(Kip7DeployerApi kip7DeployerApi) {
        this.kip7DeployerApi = kip7DeployerApi;
    }

    public Kip7ContractApi getKip7ContractApi() {
        return this.kip7ContractApi;
    }

    public void setKip7ContractApi(Kip7ContractApi kip7ContractApi) {
        this.kip7ContractApi = kip7ContractApi;
    }

    public Kip7TokenApi getKip7TokenApi() {
        return this.kip7TokenApi;
    }

    public void setKip7TokenApi(Kip7TokenApi kip7TokenApi) {
        this.kip7TokenApi = kip7TokenApi;
    }

    public String getChainId() {
        return this.chainId;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.setKip7ContractApi(new Kip7ContractApi(apiClient));
        this.setKip7TokenApi(new Kip7TokenApi(apiClient));
        this.setKip7DeployerApi(new Kip7DeployerApi(apiClient));
    }
}

