/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Contract deploy transaction request schema")
public class ContractDeployTransactionRequest {
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="value")
    private String value = null;
    @SerializedName(value="input")
    private String input = null;
    @SerializedName(value="nonce")
    private Long nonce = null;
    @SerializedName(value="gas")
    private Long gas = 100000L;
    @SerializedName(value="submit")
    private Boolean submit = null;

    public ContractDeployTransactionRequest from(String from) {
        this.from = from;
        return this;
    }

    @Schema(example="552714228230442729489415054454372803633806727088", required=true, description="Klaytn account address to send transaction")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public ContractDeployTransactionRequest value(String value) {
        this.value = value;
        return this;
    }

    @Schema(example="0", description="KLAY converted into PEB")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ContractDeployTransactionRequest input(String input) {
        this.input = input;
        return this;
    }

    @Schema(example="580287299737565567628489557492757204895646568890939015285620570035592757743967908856804894971088843461568898669160635235446199246690516837470169525891165228652969731216232050820434315981933343744553267043883135573432644831710846853327980409390587281885072709725103816957555307217627011728105699968287369313146606286351821168367418818449795969393003480596798768558853555279198415544561108598415883792066756170378207593660264527269102015395636982372818098189751816675320091461991339299650193684409392215302466468436921918400285386647246540178208929890057351547269243098731141856688778727709574582242688514258297406650844727495490893494391090367377053488497542467057543102803919361681614252196798963508515932644772594885311269359235467749990487109703799078953", required=true, description="Data that is sent along with the transaction and used for the execution.")
    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public ContractDeployTransactionRequest nonce(Long nonce) {
        this.nonce = nonce;
        return this;
    }

    @Schema(example="0", description="Unique identifier for the transactions being sent.(By entering 0, the nonce will be automatically determined.)")
    public Long getNonce() {
        return this.nonce;
    }

    public void setNonce(Long nonce) {
        this.nonce = nonce;
    }

    public ContractDeployTransactionRequest gas(Long gas) {
        this.gas = gas;
        return this;
    }

    @Schema(example="0", description="Maximum gas fee to be used for sending the transaction (By entering 0, it will be set to default value) ")
    public Long getGas() {
        return this.gas;
    }

    public void setGas(Long gas) {
        this.gas = gas;
    }

    public ContractDeployTransactionRequest submit(Boolean submit) {
        this.submit = submit;
        return this;
    }

    @Schema(example="true", description="To send or not sent transaction to Klaytn")
    public Boolean isSubmit() {
        return this.submit;
    }

    public void setSubmit(Boolean submit) {
        this.submit = submit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContractDeployTransactionRequest contractDeployTransactionRequest = (ContractDeployTransactionRequest)o;
        return Objects.equals(this.from, contractDeployTransactionRequest.from) && Objects.equals(this.value, contractDeployTransactionRequest.value) && Objects.equals(this.input, contractDeployTransactionRequest.input) && Objects.equals(this.nonce, contractDeployTransactionRequest.nonce) && Objects.equals(this.gas, contractDeployTransactionRequest.gas) && Objects.equals(this.submit, contractDeployTransactionRequest.submit);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.value, this.input, this.nonce, this.gas, this.submit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContractDeployTransactionRequest {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    gas: ").append(this.toIndentedString(this.gas)).append("\n");
        sb.append("    submit: ").append(this.toIndentedString(this.submit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

